/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.plugins;

import java.io.PrintWriter;
import org.eclipse.core.runtime.model.ConfigurationElementModel;
import org.eclipse.core.runtime.model.ConfigurationPropertyModel;
import org.eclipse.core.runtime.model.ExtensionModel;
import org.eclipse.core.runtime.model.ExtensionPointModel;
import org.eclipse.core.runtime.model.LibraryModel;
import org.eclipse.core.runtime.model.PluginDescriptorModel;
import org.eclipse.core.runtime.model.PluginFragmentModel;
import org.eclipse.core.runtime.model.PluginPrerequisiteModel;
import org.eclipse.core.runtime.model.PluginRegistryModel;

public class RegistryWriter {
    public void writeConfigurationElement(ConfigurationElementModel configElement, PrintWriter w, int indent) {
        int subElementSize;
        String element = configElement.getName();
        if (element == null) {
            return;
        }
        String gap1 = "";
        int i = 0;
        while (i < indent) {
            gap1 = String.valueOf(gap1) + " ";
            ++i;
        }
        String gap2 = gap1;
        int i2 = 0;
        while (i2 < 2) {
            gap2 = String.valueOf(gap2) + " ";
            ++i2;
        }
        w.print(String.valueOf(gap1) + "<" + element);
        ConfigurationPropertyModel[] propList = configElement.getProperties();
        int propSize = propList == null ? 0 : propList.length;
        int i3 = 0;
        while (i3 < propSize) {
            this.writeConfigurationProperty(propList[i3], w, indent + 2);
            ++i3;
        }
        ConfigurationElementModel[] subElementList = configElement.getSubElements();
        int n = subElementSize = subElementList == null ? 0 : subElementList.length;
        if (configElement.getValue() == null && subElementSize == 0) {
            w.println("/>");
            return;
        }
        w.println(">");
        if (configElement.getValue() != null) {
            w.println(String.valueOf(gap2) + RegistryWriter.xmlSafe(configElement.getValue()));
        }
        int i4 = 0;
        while (i4 < subElementSize) {
            this.writeConfigurationElement(subElementList[i4], w, indent + 2);
            ++i4;
        }
        w.println(String.valueOf(gap1) + "</" + element + ">");
    }

    public void writeConfigurationProperty(ConfigurationPropertyModel configProp, PrintWriter w, int indent) {
        if (configProp.getName() == null) {
            return;
        }
        w.print(" " + RegistryWriter.xmlSafe(configProp.getName()) + "=\"");
        if (configProp.getValue() != null) {
            w.print(RegistryWriter.xmlSafe(configProp.getValue()));
        }
        w.print("\"");
    }

    public void writeExtension(ExtensionModel extension, PrintWriter w, int indent) {
        ConfigurationElementModel[] subElements;
        int size;
        String gap1 = "";
        int i = 0;
        while (i < indent) {
            gap1 = String.valueOf(gap1) + " ";
            ++i;
        }
        w.print(String.valueOf(gap1) + "<" + "extension");
        if (extension.getExtensionPoint() != null) {
            w.print(" point=\"" + RegistryWriter.xmlSafe(extension.getExtensionPoint()) + "\"");
        }
        if (extension.getId() != null) {
            w.print(" id=\"" + RegistryWriter.xmlSafe(extension.getId()) + "\"");
        }
        if (extension.getName() != null) {
            w.print(" name=\"" + RegistryWriter.xmlSafe(extension.getName()) + "\"");
        }
        int n = size = (subElements = extension.getSubElements()) == null ? 0 : subElements.length;
        if (size == 0) {
            w.println("/>");
            return;
        }
        w.println(">");
        int i2 = 0;
        while (i2 < size) {
            this.writeConfigurationElement(subElements[i2], w, indent + 2);
            ++i2;
        }
        w.println(String.valueOf(gap1) + "</" + "extension" + ">");
    }

    public void writeExtensionPoint(ExtensionPointModel extPt, PrintWriter w, int indent) {
        String gap1 = "";
        int i = 0;
        while (i < indent) {
            gap1 = String.valueOf(gap1) + " ";
            ++i;
        }
        w.print(String.valueOf(gap1) + "<" + "extension-point");
        if (extPt.getId() != null) {
            w.print(" id=\"" + RegistryWriter.xmlSafe(extPt.getId()) + "\"");
        }
        if (extPt.getName() != null) {
            w.print(" name=\"" + RegistryWriter.xmlSafe(extPt.getName()) + "\"");
        }
        if (extPt.getSchema() != null) {
            w.print(" schema=\"" + RegistryWriter.xmlSafe(extPt.getSchema()) + "\"");
        }
        w.println("/>");
    }

    public void writeLibrary(LibraryModel library, PrintWriter w, int indent) {
        String gap1 = "";
        int i = 0;
        while (i < indent) {
            gap1 = String.valueOf(gap1) + " ";
            ++i;
        }
        String gap2 = gap1;
        int i2 = 0;
        while (i2 < 2) {
            gap2 = String.valueOf(gap2) + " ";
            ++i2;
        }
        w.print(String.valueOf(gap1) + "<" + "library");
        if (library.getName() != null) {
            w.print(" name=\"" + RegistryWriter.xmlSafe(library.getName()) + "\"");
        }
        if (library.getType() != null) {
            w.print(" type=\"" + RegistryWriter.xmlSafe(library.getType()) + "\"");
        }
        if (!library.isExported()) {
            w.println("/>");
        } else {
            w.println(">");
            String[] exports = library.getExports();
            int size = exports == null ? 0 : exports.length;
            int i3 = 0;
            while (i3 < size) {
                w.println(String.valueOf(gap2) + "<" + "export" + " " + "name" + "=\"" + RegistryWriter.xmlSafe(exports[i3]) + "\"/>");
                ++i3;
            }
            w.println(String.valueOf(gap1) + "</" + "library" + ">");
        }
    }

    public void writePluginDescriptor(PluginDescriptorModel plugin, PrintWriter w, int indent) {
        ExtensionModel[] extensions;
        int extSize;
        ExtensionPointModel[] extensionPoints;
        int extPointsSize;
        LibraryModel[] runtime;
        int runtimeSize;
        int reqSize;
        String gap1 = "";
        int i = 0;
        while (i < indent) {
            gap1 = String.valueOf(gap1) + " ";
            ++i;
        }
        String gap2 = gap1;
        int i2 = 0;
        while (i2 < 2) {
            gap2 = String.valueOf(gap2) + " ";
            ++i2;
        }
        w.println("");
        w.print(String.valueOf(gap1) + "<" + "plugin");
        if (plugin.getId() != null) {
            w.print(" id=\"" + RegistryWriter.xmlSafe(plugin.getId()) + "\"");
        }
        if (plugin.getName() != null) {
            w.print(" name=\"" + RegistryWriter.xmlSafe(plugin.getName()) + "\"");
        }
        if (plugin.getProviderName() != null) {
            w.print(" provider-name=\"" + RegistryWriter.xmlSafe(plugin.getProviderName()) + "\"");
        }
        if (plugin.getVersion() != null) {
            w.print(" version=\"" + RegistryWriter.xmlSafe(plugin.getVersion()) + "\"");
        }
        if (plugin.getPluginClass() != null) {
            w.print(" class=\"" + RegistryWriter.xmlSafe(plugin.getPluginClass()) + "\"");
        }
        w.println(">");
        PluginPrerequisiteModel[] requires = plugin.getRequires();
        int n = reqSize = requires == null ? 0 : requires.length;
        if (reqSize != 0) {
            w.print(String.valueOf(gap2) + "<" + "requires");
            w.println(">");
            int i3 = 0;
            while (i3 < reqSize) {
                this.writePluginPrerequisite(requires[i3], w, indent + 4);
                ++i3;
            }
            w.println(String.valueOf(gap2) + "</" + "requires" + ">");
        }
        int n2 = runtimeSize = (runtime = plugin.getRuntime()) == null ? 0 : runtime.length;
        if (runtimeSize != 0) {
            w.println(String.valueOf(gap2) + "<" + "runtime" + ">");
            int i4 = 0;
            while (i4 < runtimeSize) {
                this.writeLibrary(runtime[i4], w, indent + 4);
                ++i4;
            }
            w.println(String.valueOf(gap2) + "</" + "runtime" + ">");
        }
        int n3 = extPointsSize = (extensionPoints = plugin.getDeclaredExtensionPoints()) == null ? 0 : extensionPoints.length;
        if (extPointsSize != 0) {
            w.println("");
            int i5 = 0;
            while (i5 < extPointsSize) {
                this.writeExtensionPoint(extensionPoints[i5], w, indent + 2);
                ++i5;
            }
        }
        int n4 = extSize = (extensions = plugin.getDeclaredExtensions()) == null ? 0 : extensions.length;
        if (extSize != 0) {
            int i6 = 0;
            while (i6 < extSize) {
                w.println("");
                this.writeExtension(extensions[i6], w, indent + 2);
                ++i6;
            }
        }
        w.println(String.valueOf(gap1) + "</" + "plugin" + ">");
    }

    public void writePluginFragment(PluginFragmentModel fragment, PrintWriter w, int indent) {
        ExtensionModel[] extensions;
        int extSize;
        ExtensionPointModel[] extensionPoints;
        int extPointsSize;
        LibraryModel[] runtime;
        int runtimeSize;
        int reqSize;
        String gap1 = "";
        int i = 0;
        while (i < indent) {
            gap1 = String.valueOf(gap1) + " ";
            ++i;
        }
        String gap2 = gap1;
        int i2 = 0;
        while (i2 < 2) {
            gap2 = String.valueOf(gap2) + " ";
            ++i2;
        }
        w.println("");
        w.print(String.valueOf(gap1) + "<" + "fragment");
        if (fragment.getId() != null) {
            w.print(" id=\"" + RegistryWriter.xmlSafe(fragment.getId()) + "\"");
        }
        if (fragment.getName() != null) {
            w.print(" name=\"" + RegistryWriter.xmlSafe(fragment.getName()) + "\"");
        }
        if (fragment.getProviderName() != null) {
            w.print(" provider-name=\"" + RegistryWriter.xmlSafe(fragment.getProviderName()) + "\"");
        }
        if (fragment.getVersion() != null) {
            w.print(" version=\"" + RegistryWriter.xmlSafe(fragment.getVersion()) + "\"");
        }
        if (fragment.getPluginId() != null) {
            w.print(" plugin-id=\"" + RegistryWriter.xmlSafe(fragment.getPluginId()) + "\"");
        }
        if (fragment.getPluginVersion() != null) {
            w.print(" plugin-version=\"" + RegistryWriter.xmlSafe(fragment.getPluginVersion()) + "\"");
        }
        if (fragment.getMatch() != 0) {
            switch (fragment.getMatch()) {
                case 1: {
                    w.print(" match=\"perfect\"");
                    break;
                }
                case 2: {
                    w.print(" match=\"equivalent\"");
                    break;
                }
                case 3: {
                    w.print(" match=\"compatible\"");
                    break;
                }
                case 4: {
                    w.print(" match=\"greaterOrEqual\"");
                }
            }
        }
        w.println(">");
        PluginPrerequisiteModel[] requires = fragment.getRequires();
        int n = reqSize = requires == null ? 0 : requires.length;
        if (reqSize != 0) {
            w.print(String.valueOf(gap2) + "<" + "requires");
            w.println(">");
            int i3 = 0;
            while (i3 < reqSize) {
                this.writePluginPrerequisite(requires[i3], w, indent + 4);
                ++i3;
            }
            w.println(String.valueOf(gap2) + "</" + "requires" + ">");
        }
        int n2 = runtimeSize = (runtime = fragment.getRuntime()) == null ? 0 : runtime.length;
        if (runtimeSize != 0) {
            w.println(String.valueOf(gap2) + "<" + "runtime" + ">");
            int i4 = 0;
            while (i4 < runtimeSize) {
                this.writeLibrary(runtime[i4], w, indent + 4);
                ++i4;
            }
            w.println(String.valueOf(gap2) + "</" + "runtime" + ">");
        }
        int n3 = extPointsSize = (extensionPoints = fragment.getDeclaredExtensionPoints()) == null ? 0 : extensionPoints.length;
        if (extPointsSize != 0) {
            w.println("");
            int i5 = 0;
            while (i5 < extPointsSize) {
                this.writeExtensionPoint(extensionPoints[i5], w, indent + 2);
                ++i5;
            }
        }
        int n4 = extSize = (extensions = fragment.getDeclaredExtensions()) == null ? 0 : extensions.length;
        if (extSize != 0) {
            int i6 = 0;
            while (i6 < extSize) {
                w.println("");
                this.writeExtension(extensions[i6], w, indent + 2);
                ++i6;
            }
        }
        w.println(String.valueOf(gap1) + "</" + "fragment" + ">");
    }

    public void writePluginPrerequisite(PluginPrerequisiteModel req, PrintWriter w, int indent) {
        String gap1 = "";
        int i = 0;
        while (i < indent) {
            gap1 = String.valueOf(gap1) + " ";
            ++i;
        }
        w.print(String.valueOf(gap1) + "<" + "import");
        if (req.getPlugin() != null) {
            w.print(" plugin=\"" + RegistryWriter.xmlSafe(req.getPlugin()) + "\"");
        }
        if (req.getVersion() != null) {
            w.print(" version=\"" + RegistryWriter.xmlSafe(req.getVersion()) + "\"");
        }
        if (req.getExport()) {
            w.print(" export=\"true\"");
        }
        if (req.getOptional()) {
            w.print(" optional=\"true\"");
        }
        switch (req.getMatchByte()) {
            case 1: {
                w.print(" match=\"perfect\"");
                break;
            }
            case 2: {
                w.print(" match=\"equivalent\"");
                break;
            }
            case 3: {
                w.print(" match=\"compatible\"");
                break;
            }
            case 4: {
                w.print(" match=\"greaterOrEqual\"");
            }
        }
        w.println("/>");
    }

    public void writePluginRegistry(PluginRegistryModel registry, PrintWriter w, int indent) {
        String gap1 = "";
        int i = 0;
        while (i < indent) {
            gap1 = String.valueOf(gap1) + " ";
            ++i;
        }
        w.println(String.valueOf(gap1) + "<" + "plugin-registry" + ">");
        PluginDescriptorModel[] pluginList = registry.getPlugins();
        int i2 = 0;
        while (i2 < pluginList.length) {
            this.writePluginDescriptor(pluginList[i2], w, indent + 2);
            ++i2;
        }
        PluginFragmentModel[] fragmentList = registry.getFragments();
        int i3 = 0;
        while (i3 < fragmentList.length) {
            this.writePluginFragment(fragmentList[i3], w, indent + 2);
            ++i3;
        }
        w.println(String.valueOf(gap1) + "</" + "plugin-registry" + ">");
    }

    private static void appendEscapedChar(StringBuffer buffer, char c) {
        String replacement = RegistryWriter.getReplacement(c);
        if (replacement != null) {
            buffer.append('&');
            buffer.append(replacement);
            buffer.append(';');
        } else if (c >= ' ' && c <= '~' || c == '\n' || c == '\r' || c == '\t') {
            buffer.append(c);
        } else {
            buffer.append("&#");
            buffer.append(Integer.toString(c));
            buffer.append(';');
        }
    }

    public static String xmlSafe(String s) {
        StringBuffer result = new StringBuffer(s.length() + 10);
        int i = 0;
        while (i < s.length()) {
            RegistryWriter.appendEscapedChar(result, s.charAt(i));
            ++i;
        }
        return result.toString();
    }

    private static String getReplacement(char c) {
        switch (c) {
            case '<': {
                return "lt";
            }
            case '>': {
                return "gt";
            }
            case '\"': {
                return "quot";
            }
            case '\'': {
                return "apos";
            }
            case '&': {
                return "amp";
            }
        }
        return null;
    }
}

