/*
 * Decompiled with CFR 0.152.
 */
package org.drools.spi;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.drools.spi.DuplicateRuleNameException;
import org.drools.spi.InvalidRuleException;
import org.drools.spi.Rule;

public class RuleSet {
    private String name;
    private Map rules;

    public RuleSet(String name) {
        this.name = name;
        this.rules = Collections.EMPTY_MAP;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void addRule(Rule rule) throws DuplicateRuleNameException, InvalidRuleException {
        String name;
        rule.checkValidity();
        if (this.rules == Collections.EMPTY_MAP) {
            this.rules = new HashMap();
        }
        if (this.containsRule(name = rule.getName())) {
            throw new DuplicateRuleNameException(this, this.getRule(name), rule);
        }
        this.rules.put(name, rule);
    }

    public Rule getRule(String name) {
        return (Rule)this.rules.get(name);
    }

    public boolean containsRule(String name) {
        return this.rules.containsKey(name);
    }

    public Collection getRules() {
        return this.rules.values();
    }

    public Iterator getRuleIterator() {
        return this.rules.values().iterator();
    }
}

