/*
 * Decompiled with CFR 0.152.
 */
package org.drools.spi;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.drools.spi.Action;
import org.drools.spi.ArraySet;
import org.drools.spi.AssignmentCondition;
import org.drools.spi.Declaration;
import org.drools.spi.DeclarationAlreadyCompleteException;
import org.drools.spi.FilterCondition;
import org.drools.spi.InvalidRuleException;
import org.drools.spi.NoConditionException;
import org.drools.spi.NoParameterDeclarationException;

public class Rule {
    private static int STATE_DECL = 1;
    private static int STATE_OTHER = 2;
    private int state;
    private String name;
    private Set parameterDeclarations;
    private Set localDeclarations;
    private Set filterConditions;
    private Set assignmentConditions;
    private Action action;

    public Rule(String name) {
        this.setState(STATE_DECL);
        this.name = name;
        this.parameterDeclarations = Collections.EMPTY_SET;
        this.localDeclarations = Collections.EMPTY_SET;
        this.filterConditions = Collections.EMPTY_SET;
        this.assignmentConditions = Collections.EMPTY_SET;
    }

    public String toString() {
        return "[Rule: name='" + this.name + "'; paramDecls=" + this.parameterDeclarations + "; localDecls=" + this.localDeclarations + "; filterConds=" + this.filterConditions + "; assignConds=" + this.assignmentConditions + "]";
    }

    private int getState() {
        return this.state;
    }

    private void setState(int state) {
        this.state = state;
    }

    public boolean isValid() {
        return !this.getParameterDeclarations().isEmpty() && (!this.getFilterConditions().isEmpty() || !this.getAssignmentConditions().isEmpty());
    }

    public void checkValidity() throws InvalidRuleException {
        if (this.getParameterDeclarations().isEmpty()) {
            throw new NoParameterDeclarationException(this);
        }
        if (this.getFilterConditions().isEmpty() && this.getAssignmentConditions().isEmpty()) {
            throw new NoConditionException(this);
        }
    }

    public String getName() {
        return this.name;
    }

    public void addParameterDeclaration(Declaration declaration) throws DeclarationAlreadyCompleteException {
        if (this.getState() == STATE_DECL) {
            if (this.parameterDeclarations == Collections.EMPTY_SET) {
                this.parameterDeclarations = new HashSet();
            }
        } else {
            throw new DeclarationAlreadyCompleteException(this);
        }
        this.parameterDeclarations.add(declaration);
    }

    private void addLocalDeclaration(Declaration declaration) {
        this.setState(STATE_OTHER);
        if (this.localDeclarations == Collections.EMPTY_SET) {
            this.localDeclarations = new HashSet();
        }
        this.localDeclarations.add(declaration);
    }

    public Set getParameterDeclarations() {
        return this.parameterDeclarations;
    }

    public Set getLocalDeclarations() {
        return this.localDeclarations;
    }

    public void addFilterCondition(FilterCondition filterCondition) {
        this.setState(STATE_OTHER);
        if (this.filterConditions == Collections.EMPTY_SET) {
            this.filterConditions = new ArraySet();
        }
        this.filterConditions.add(filterCondition);
    }

    public void addAssignmentCondition(AssignmentCondition assignmentCondition) {
        this.setState(STATE_OTHER);
        if (this.assignmentConditions == Collections.EMPTY_SET) {
            this.assignmentConditions = new HashSet();
        }
        this.assignmentConditions.add(assignmentCondition);
        Declaration decl = assignmentCondition.getTargetDeclaration();
        if (!this.parameterDeclarations.contains(decl)) {
            this.addLocalDeclaration(decl);
        }
    }

    public Set getFilterConditions() {
        return this.filterConditions;
    }

    public Set getAssignmentConditions() {
        return this.assignmentConditions;
    }

    public void setAction(Action action) {
        this.action = action;
    }

    public Action getAction() {
        return this.action;
    }
}

