/*
 * Decompiled with CFR 0.152.
 */
package org.drools.reteoo;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.drools.AssertionException;
import org.drools.ModificationException;
import org.drools.RetractionException;
import org.drools.WorkingMemory;
import org.drools.reteoo.ObjectTypeNode;
import org.drools.spi.ObjectType;

public class RootNode {
    private Map objectTypeNodes = Collections.EMPTY_MAP;

    public void assertObject(Object object, WorkingMemory workingMemory) throws AssertionException {
        Iterator nodeIter = this.getObjectTypeNodeIterator();
        ObjectTypeNode eachNode = null;
        while (nodeIter.hasNext()) {
            eachNode = (ObjectTypeNode)nodeIter.next();
            eachNode.assertObject(object, workingMemory);
        }
    }

    public void retractObject(Object object, WorkingMemory workingMemory) throws RetractionException {
        Iterator nodeIter = this.getObjectTypeNodeIterator();
        ObjectTypeNode eachNode = null;
        while (nodeIter.hasNext()) {
            eachNode = (ObjectTypeNode)nodeIter.next();
            eachNode.retractObject(object, workingMemory);
        }
    }

    public void modifyObject(Object object, WorkingMemory workingMemory) throws ModificationException {
        Iterator nodeIter = this.getObjectTypeNodeIterator();
        ObjectTypeNode eachNode = null;
        while (nodeIter.hasNext()) {
            eachNode = (ObjectTypeNode)nodeIter.next();
            eachNode.modifyObject(object, workingMemory);
        }
    }

    protected void addObjectTypeNode(ObjectTypeNode node) {
        if (this.objectTypeNodes == Collections.EMPTY_MAP) {
            this.objectTypeNodes = new HashMap();
        }
        this.objectTypeNodes.put(node.getObjectType(), node);
    }

    protected Collection getObjectTypeNodes() {
        return this.objectTypeNodes.values();
    }

    protected Iterator getObjectTypeNodeIterator() {
        return this.objectTypeNodes.values().iterator();
    }

    protected ObjectTypeNode getObjectTypeNode(ObjectType objectType) {
        return (ObjectTypeNode)this.objectTypeNodes.get(objectType);
    }

    protected ObjectTypeNode getOrCreateObjectTypeNode(ObjectType objectType) {
        ObjectTypeNode node = this.getObjectTypeNode(objectType);
        if (node == null) {
            node = new ObjectTypeNode(objectType);
            this.addObjectTypeNode(node);
        }
        return node;
    }
}

