/*
 * Decompiled with CFR 0.152.
 */
package org.drools.reteoo;

import java.util.Collections;
import java.util.Set;
import org.drools.AssertionException;
import org.drools.ModificationException;
import org.drools.RetractionException;
import org.drools.WorkingMemory;
import org.drools.reteoo.ObjectTypeNode;
import org.drools.reteoo.ParameterTuple;
import org.drools.reteoo.TupleSource;
import org.drools.spi.Declaration;

public class ParameterNode
extends TupleSource {
    private Declaration declaration;

    public ParameterNode(ObjectTypeNode inputNode, Declaration declaration) {
        this.declaration = declaration;
        if (inputNode != null) {
            inputNode.addParameterNode(this);
        }
    }

    public Declaration getDeclaration() {
        return this.declaration;
    }

    public Set getTupleDeclarations() {
        return Collections.singleton(this.declaration);
    }

    protected void assertObject(Object object, WorkingMemory workingMemory) throws AssertionException {
        ParameterTuple tuple = new ParameterTuple(this.getDeclaration(), object);
        this.propagateAssertTuple(tuple, workingMemory);
    }

    protected void retractObject(Object object, WorkingMemory workingMemory) throws RetractionException {
        this.propagateRetractObject(object, workingMemory);
    }

    protected void modifyObject(Object object, WorkingMemory workingMemory) throws ModificationException {
        try {
            this.propagateRetractObject(object, workingMemory);
            this.assertObject(object, workingMemory);
        }
        catch (RetractionException e) {
            throw new ModificationException(e);
        }
        catch (AssertionException e) {
            throw new ModificationException(e);
        }
    }
}

