/*
 * Decompiled with CFR 0.152.
 */
package org.drools.reteoo;

import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.drools.AssertionException;
import org.drools.ModificationException;
import org.drools.RetractionException;
import org.drools.WorkingMemory;
import org.drools.reteoo.ParameterNode;
import org.drools.spi.ObjectType;

public class ObjectTypeNode {
    private ObjectType objectType;
    private Set parameterNodes;

    ObjectTypeNode(ObjectType objectType) {
        this.objectType = objectType;
        this.parameterNodes = Collections.EMPTY_SET;
    }

    public ObjectType getObjectType() {
        return this.objectType;
    }

    protected void addParameterNode(ParameterNode node) {
        if (this.parameterNodes == Collections.EMPTY_SET) {
            this.parameterNodes = new HashSet();
        }
        this.parameterNodes.add(node);
    }

    protected Set getParameterNodes() {
        return this.parameterNodes;
    }

    protected Iterator getParameterNodeIterator() {
        return this.parameterNodes.iterator();
    }

    public void assertObject(Object object, WorkingMemory workingMemory) throws AssertionException {
        ObjectType objectType = this.getObjectType();
        Iterator nodeIter = this.getParameterNodeIterator();
        ParameterNode eachNode = null;
        while (nodeIter.hasNext()) {
            eachNode = (ParameterNode)nodeIter.next();
            if (!objectType.matches(object)) continue;
            eachNode.assertObject(object, workingMemory);
        }
    }

    public void retractObject(Object object, WorkingMemory workingMemory) throws RetractionException {
        ObjectType objectType = this.getObjectType();
        Iterator nodeIter = this.getParameterNodeIterator();
        ParameterNode eachNode = null;
        while (nodeIter.hasNext()) {
            eachNode = (ParameterNode)nodeIter.next();
            if (!objectType.matches(object)) continue;
            eachNode.retractObject(object, workingMemory);
        }
    }

    public void modifyObject(Object object, WorkingMemory workingMemory) throws ModificationException {
        ObjectType objectType = this.getObjectType();
        Iterator nodeIter = this.getParameterNodeIterator();
        ParameterNode eachNode = null;
        while (nodeIter.hasNext()) {
            eachNode = (ParameterNode)nodeIter.next();
            if (!objectType.matches(object)) continue;
            eachNode.modifyObject(object, workingMemory);
        }
    }
}

