/*
 * Decompiled with CFR 0.152.
 */
package org.drools.reteoo;

import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.drools.AssertionException;
import org.drools.RetractionException;
import org.drools.WorkingMemory;
import org.drools.reteoo.JoinMemory;
import org.drools.reteoo.ReteTuple;
import org.drools.reteoo.TupleSink;
import org.drools.reteoo.TupleSource;
import org.drools.spi.Declaration;

public class JoinNode
extends TupleSource
implements TupleSink {
    private TupleSource leftInput;
    private TupleSource rightInput;
    private Set commonDeclarations;

    public JoinNode(TupleSource leftInput, TupleSource rightInput) {
        this.leftInput = leftInput;
        this.rightInput = rightInput;
        this.determineCommonDeclarations();
        leftInput.setTupleSink(this);
        rightInput.setTupleSink(this);
    }

    private void determineCommonDeclarations() {
        this.commonDeclarations = new HashSet();
        Set leftDecls = this.leftInput.getTupleDeclarations();
        Set rightDecls = this.rightInput.getTupleDeclarations();
        Iterator declIter = rightDecls.iterator();
        Declaration eachDecl = null;
        while (declIter.hasNext()) {
            eachDecl = (Declaration)declIter.next();
            if (!leftDecls.contains(eachDecl)) continue;
            this.commonDeclarations.add(eachDecl);
        }
    }

    public Set getCommonDeclarations() {
        return this.commonDeclarations;
    }

    public Set getTupleDeclarations() {
        HashSet decls = new HashSet();
        decls.addAll(this.getLeftInput().getTupleDeclarations());
        decls.addAll(this.getRightInput().getTupleDeclarations());
        return decls;
    }

    protected TupleSource getLeftInput() {
        return this.leftInput;
    }

    protected TupleSource getRightInput() {
        return this.rightInput;
    }

    public void assertTuple(TupleSource inputSource, ReteTuple tuple, WorkingMemory workingMemory) throws AssertionException {
        JoinMemory memory = workingMemory.getJoinMemory(this);
        List joinedTuples = null;
        joinedTuples = inputSource == this.leftInput ? memory.addLeftTuple(tuple) : memory.addRightTuple(tuple);
        if (joinedTuples.isEmpty()) {
            return;
        }
        Iterator tupleIter = joinedTuples.iterator();
        ReteTuple eachTuple = null;
        while (tupleIter.hasNext()) {
            eachTuple = (ReteTuple)tupleIter.next();
            this.propagateAssertTuple(eachTuple, workingMemory);
        }
    }

    public void retractObject(TupleSource inputSource, Object object, WorkingMemory workingMemory) throws RetractionException {
        JoinMemory memory = workingMemory.getJoinMemory(this);
        memory.retractObject(object);
        this.propagateRetractObject(object, workingMemory);
    }
}

