/*
 * Decompiled with CFR 0.152.
 */
package org.drools.reteoo;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.drools.reteoo.JoinNode;
import org.drools.reteoo.JoinTuple;
import org.drools.reteoo.ReteTuple;
import org.drools.spi.Declaration;

public class JoinMemory {
    private List leftTuples = new LinkedList();
    private List rightTuples = new LinkedList();
    private Set joinDeclarations;

    public JoinMemory(JoinNode node) {
        this.joinDeclarations = node.getCommonDeclarations();
    }

    public String toString() {
        return "[JoinMemory \n\tleft=" + this.leftTuples + "\n\tright=" + this.rightTuples + "]";
    }

    protected void retractObject(Object object) {
        ReteTuple eachTuple = null;
        Iterator tupleIter = this.leftTuples.iterator();
        while (tupleIter.hasNext()) {
            eachTuple = (ReteTuple)tupleIter.next();
            if (!eachTuple.containsRootFactObject(object)) continue;
            tupleIter.remove();
        }
        tupleIter = this.rightTuples.iterator();
        while (tupleIter.hasNext()) {
            eachTuple = (ReteTuple)tupleIter.next();
            if (!eachTuple.containsRootFactObject(object)) continue;
            tupleIter.remove();
        }
    }

    protected List addLeftTuple(ReteTuple tuple) {
        this.leftTuples.add(tuple);
        return this.attemptJoin(tuple, this.getRightTupleIterator());
    }

    protected List getLeftTuples() {
        return this.leftTuples;
    }

    protected Iterator getLeftTupleIterator() {
        return this.leftTuples.iterator();
    }

    protected List addRightTuple(ReteTuple tuple) {
        this.rightTuples.add(tuple);
        return this.attemptJoin(tuple, this.getLeftTupleIterator());
    }

    protected List getRightTuples() {
        return this.rightTuples;
    }

    protected Iterator getRightTupleIterator() {
        return this.rightTuples.iterator();
    }

    protected Iterator getJoinDeclarationIterator() {
        return this.joinDeclarations.iterator();
    }

    protected List attemptJoin(ReteTuple tuple, Iterator tupleIter) {
        ArrayList<ReteTuple> joinedTuples = Collections.EMPTY_LIST;
        ReteTuple eachTuple = null;
        ReteTuple joinedTuple = null;
        while (tupleIter.hasNext()) {
            eachTuple = (ReteTuple)tupleIter.next();
            joinedTuple = this.attemptJoin(tuple, eachTuple);
            if (joinedTuple == null) continue;
            if (joinedTuples == Collections.EMPTY_LIST) {
                joinedTuples = new ArrayList<ReteTuple>();
            }
            joinedTuples.add(joinedTuple);
        }
        return joinedTuples;
    }

    protected ReteTuple attemptJoin(ReteTuple left, ReteTuple right) {
        Iterator declIter = this.getJoinDeclarationIterator();
        Declaration eachDecl = null;
        Object leftValue = null;
        Object rightValue = null;
        while (declIter.hasNext()) {
            eachDecl = (Declaration)declIter.next();
            leftValue = left.get(eachDecl);
            rightValue = right.get(eachDecl);
            if (leftValue == null && rightValue == null) continue;
            if (leftValue == null || rightValue == null) {
                return null;
            }
            if (leftValue.equals(rightValue)) continue;
            return null;
        }
        JoinTuple joinedTuple = new JoinTuple(left, right);
        return joinedTuple;
    }
}

