/*
 * Decompiled with CFR 0.152.
 */
package org.drools.reteoo;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.drools.reteoo.AssignmentNode;
import org.drools.reteoo.FilterNode;
import org.drools.reteoo.JoinNode;
import org.drools.reteoo.ObjectTypeNode;
import org.drools.reteoo.ParameterNode;
import org.drools.reteoo.ReteConstructionException;
import org.drools.reteoo.RootNode;
import org.drools.reteoo.TerminalNode;
import org.drools.reteoo.TupleSource;
import org.drools.spi.AssignmentCondition;
import org.drools.spi.Condition;
import org.drools.spi.Declaration;
import org.drools.spi.FilterCondition;
import org.drools.spi.ObjectType;
import org.drools.spi.Rule;

public class Builder {
    private RootNode rootNode;

    public Builder(RootNode rootNode) {
        this.rootNode = rootNode;
    }

    public RootNode getRootNode() {
        return this.rootNode;
    }

    public void addRule(Rule rule) throws ReteConstructionException {
        HashSet assignmentConds = new HashSet(rule.getAssignmentConditions());
        HashSet filterConds = new HashSet(rule.getFilterConditions());
        Set attachableNodes = null;
        boolean performedJoin = false;
        boolean attachAssign = false;
        boolean cycleAttachAssign = false;
        attachableNodes = this.createParameterNodes(rule);
        do {
            performedJoin = false;
            attachAssign = false;
            if (!filterConds.isEmpty()) {
                this.attachFilterConditions(filterConds, attachableNodes);
            }
            attachAssign = this.attachAssignmentConditions(assignmentConds, attachableNodes);
            performedJoin = this.createJoinNodes(attachableNodes);
        } while (!attachableNodes.isEmpty() && (performedJoin || attachAssign));
        TupleSource lastNode = (TupleSource)attachableNodes.iterator().next();
        TerminalNode terminal = new TerminalNode(lastNode, rule.getAction());
    }

    protected Set createParameterNodes(Rule rule) {
        HashSet<ParameterNode> attachableNodes = new HashSet<ParameterNode>();
        Set parameterDecls = rule.getParameterDeclarations();
        Iterator declIter = parameterDecls.iterator();
        Declaration eachDecl = null;
        ObjectType objectType = null;
        ObjectTypeNode objectTypeNode = null;
        ParameterNode paramNode = null;
        while (declIter.hasNext()) {
            eachDecl = (Declaration)declIter.next();
            objectType = eachDecl.getObjectType();
            objectTypeNode = this.getRootNode().getOrCreateObjectTypeNode(objectType);
            paramNode = new ParameterNode(objectTypeNode, eachDecl);
            attachableNodes.add(paramNode);
        }
        return attachableNodes;
    }

    protected void attachFilterConditions(Set filterConds, Set attachableNodes) {
        Iterator condIter = filterConds.iterator();
        FilterCondition eachCond = null;
        TupleSource tupleSource = null;
        FilterNode filterNode = null;
        while (condIter.hasNext()) {
            eachCond = (FilterCondition)condIter.next();
            tupleSource = this.findMatchingTupleSourceForFiltering(eachCond, attachableNodes);
            if (tupleSource == null) continue;
            condIter.remove();
            filterNode = new FilterNode(tupleSource, eachCond);
            attachableNodes.remove(tupleSource);
            attachableNodes.add(filterNode);
        }
    }

    protected boolean createJoinNodes(Set attachableNodes) {
        boolean performedJoin = false;
        Object[] leftNodes = attachableNodes.toArray();
        Object[] rightNodes = attachableNodes.toArray();
        TupleSource left = null;
        TupleSource right = null;
        JoinNode joinNode = null;
        int i = 0;
        while (i < leftNodes.length) {
            left = (TupleSource)leftNodes[i];
            if (attachableNodes.contains(left)) {
                int j = i + 1;
                while (j < rightNodes.length) {
                    right = (TupleSource)rightNodes[j];
                    if (attachableNodes.contains(right)) {
                        this.canBeJoined(left, right);
                        joinNode = new JoinNode(left, right);
                        attachableNodes.remove(left);
                        attachableNodes.remove(right);
                        attachableNodes.add(joinNode);
                        performedJoin = true;
                        break;
                    }
                    ++j;
                }
            }
            ++i;
        }
        return performedJoin;
    }

    protected boolean canBeJoined(TupleSource left, TupleSource right) {
        Set leftDecls = left.getTupleDeclarations();
        Iterator rightDeclIter = right.getTupleDeclarations().iterator();
        while (rightDeclIter.hasNext()) {
            if (!leftDecls.contains(rightDeclIter.next())) continue;
            return true;
        }
        return false;
    }

    protected boolean attachAssignmentConditions(Set assignmentConds, Set attachableNodes) {
        boolean attached = false;
        boolean cycleAttached = false;
        do {
            cycleAttached = false;
            Iterator condIter = assignmentConds.iterator();
            AssignmentCondition eachCond = null;
            TupleSource tupleSource = null;
            AssignmentNode assignNode = null;
            while (condIter.hasNext()) {
                eachCond = (AssignmentCondition)condIter.next();
                tupleSource = this.findMatchingTupleSourceForAssignment(eachCond, attachableNodes);
                if (tupleSource == null) continue;
                condIter.remove();
                assignNode = new AssignmentNode(tupleSource, eachCond.getTargetDeclaration(), eachCond.getFactExtractor());
                attachableNodes.remove(tupleSource);
                attachableNodes.add(assignNode);
                cycleAttached = true;
            }
            if (!cycleAttached) continue;
            attached = true;
        } while (cycleAttached);
        return attached;
    }

    protected TupleSource findMatchingTupleSourceForFiltering(FilterCondition condition, Set sources) {
        Iterator sourceIter = sources.iterator();
        TupleSource eachSource = null;
        Set decls = null;
        while (sourceIter.hasNext()) {
            eachSource = (TupleSource)sourceIter.next();
            decls = eachSource.getTupleDeclarations();
            if (!this.matches(condition, decls)) continue;
            return eachSource;
        }
        return null;
    }

    protected TupleSource findMatchingTupleSourceForAssignment(AssignmentCondition condition, Set sources) {
        Declaration targetDecl = condition.getTargetDeclaration();
        Iterator sourceIter = sources.iterator();
        TupleSource eachSource = null;
        Set decls = null;
        while (sourceIter.hasNext()) {
            eachSource = (TupleSource)sourceIter.next();
            decls = eachSource.getTupleDeclarations();
            if (decls.contains(targetDecl) || !this.matches(condition, decls)) continue;
            return eachSource;
        }
        return null;
    }

    protected boolean matches(Condition condition, Set declarations) {
        Declaration[] requiredDecls = condition.getRequiredTupleMembers();
        int i = 0;
        while (i < requiredDecls.length) {
            if (!declarations.contains(requiredDecls[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }
}

