/*
 * Decompiled with CFR 0.152.
 */
package org.drools;

import java.util.Iterator;
import org.drools.AssertionException;
import org.drools.ModificationException;
import org.drools.RetractionException;
import org.drools.WorkingMemory;
import org.drools.reteoo.Builder;
import org.drools.reteoo.ReteConstructionException;
import org.drools.reteoo.RootNode;
import org.drools.spi.Rule;
import org.drools.spi.RuleSet;

public class RuleBase {
    private RootNode rootNode = new RootNode();

    public void addRuleSet(RuleSet ruleSet) throws ReteConstructionException {
        Iterator ruleIter = ruleSet.getRuleIterator();
        Rule eachRule = null;
        while (ruleIter.hasNext()) {
            eachRule = (Rule)ruleIter.next();
            this.addRule(eachRule);
        }
    }

    public void addRule(Rule rule) throws ReteConstructionException {
        Builder builder = new Builder(this.getRootNode());
        builder.addRule(rule);
    }

    public WorkingMemory createWorkingMemory() {
        return new WorkingMemory(this);
    }

    protected RootNode getRootNode() {
        return this.rootNode;
    }

    protected void assertObject(Object object, WorkingMemory workingMemory) throws AssertionException {
        this.getRootNode().assertObject(object, workingMemory);
    }

    protected void retractObject(Object object, WorkingMemory workingMemory) throws RetractionException {
        this.getRootNode().retractObject(object, workingMemory);
    }

    protected void modifyObject(Object object, WorkingMemory workingMemory) throws ModificationException {
        this.getRootNode().modifyObject(object, workingMemory);
    }
}

