/*
 * Decompiled with CFR 0.152.
 */
package org.drools;

import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.Locale;

public class DroolsException
extends Exception {
    private Throwable rootCause;

    public DroolsException() {
    }

    public DroolsException(Throwable rootCause) {
        this.rootCause = rootCause;
    }

    public Throwable getRootCause() {
        return this.rootCause;
    }

    public String getMessage() {
        Throwable rootCause = this.getRootCause();
        if (rootCause == null) {
            return this.getMyMessage();
        }
        StringBuffer msg = new StringBuffer();
        msg.append(this.getMyMessage());
        msg.append(" -> ");
        msg.append(rootCause.getMessage());
        return msg.toString();
    }

    public String getLocalizedMessage() {
        Throwable rootCause = this.getRootCause();
        if (rootCause == null) {
            return this.getMyLocalizedMessage();
        }
        StringBuffer msg = new StringBuffer();
        msg.append(this.getMyMessage());
        msg.append(" -> ");
        msg.append(rootCause.getLocalizedMessage());
        return msg.toString();
    }

    public String getLocalizedMessage(Locale locale) {
        Throwable rootCause = this.getRootCause();
        if (rootCause == null) {
            return this.getMyLocalizedMessage(locale);
        }
        StringBuffer msg = new StringBuffer();
        msg.append(this.getMyMessage());
        msg.append(" -> ");
        if (rootCause instanceof DroolsException) {
            msg.append(((DroolsException)rootCause).getLocalizedMessage(locale));
        } else {
            msg.append(rootCause.getLocalizedMessage());
        }
        return msg.toString();
    }

    public String getMyMessage() {
        String msg = super.getMessage();
        if (msg == null || msg.equals("")) {
            msg = this.getClass().getName();
        }
        return msg;
    }

    public String getMyLocalizedMessage() {
        String msg = super.getLocalizedMessage();
        if (msg == null || msg.equals("")) {
            msg = this.getClass().getName();
        }
        return msg;
    }

    public String getMyLocalizedMessage(Locale locale) {
        return this.getMyLocalizedMessage();
    }

    public void printStackTrace() {
        this.printMyStackTrace();
        Throwable rootCause = this.getRootCause();
        if (rootCause != null) {
            System.err.println(" ->");
            rootCause.printStackTrace();
        }
    }

    public void printStackTrace(PrintStream s) {
        this.printMyStackTrace();
        Throwable rootCause = this.getRootCause();
        if (rootCause != null) {
            s.println(" ->");
            rootCause.printStackTrace(s);
        }
    }

    public void printStackTrace(PrintWriter s) {
        this.printMyStackTrace();
        Throwable rootCause = this.getRootCause();
        if (rootCause != null) {
            s.println(" ->");
            rootCause.printStackTrace(s);
        }
    }

    public void printMyStackTrace() {
        super.printStackTrace();
    }

    public void printMyStackTrace(PrintStream s) {
        super.printStackTrace(s);
    }

    public void printMyStackTrace(PrintWriter s) {
        super.printStackTrace(s);
    }
}

