/*
 * Decompiled with CFR 0.152.
 */
package com.sap.util.monitor.jarm;

import com.sap.util.monitor.jarm.CompMonitor;
import com.sap.util.monitor.jarm.CompSingleOverview;
import com.sap.util.monitor.jarm.CompSingleOverviewExt;
import com.sap.util.monitor.jarm.CondenseThread;
import com.sap.util.monitor.jarm.ConfMonitor;
import com.sap.util.monitor.jarm.RequestOverview;
import com.sap.util.monitor.jarm.RequestOverviewExt;
import com.sap.util.monitor.jarm.RequestSummary;
import com.sap.util.monitor.jarm.RequestSummaryExt;
import com.sap.util.monitor.jarm.TaskMonitor;
import com.sap.util.monitor.jarm.TaskOverview;
import com.sap.util.monitor.jarm.TaskOverviewExt;
import com.sap.util.monitor.jarm.TopList;
import com.sap.util.monitor.jarm.TopStruct;
import com.sap.util.monitor.jarm.UserMonitor;

class ReqMonitor {
    private static TopList topReqTime;
    private static TopList topReqOutData;
    private static ReqMonitor headReadyRequestList;
    private static ReqMonitor tailReadyRequestList;
    private static int readyListCompCount;
    private static long reqFirstTS;
    private static long resetReqTS;
    private static long resetCompTS;
    private static long resetUserTS;
    private static long reqAccNr;
    private static long reqAccStatusOk;
    private static long reqAccStatusCompNotClosed;
    private static long reqAccStatusEndForced;
    private static long reqCompLevelBasic;
    private static long reqCompLevelMedium;
    private static long reqCompLevelDetail;
    protected static long reqStartAccUserNr;
    protected static long reqAccUserNr;
    private static long reqAccComp;
    private static long reqAccTime;
    private static long reqAccCpuTime;
    private static long reqAccInDataFilled;
    private static long reqAccOutDataFilled;
    private static long reqAccInData;
    private static long reqAccOutData;
    private static long lastCondenseThreadCallTS;
    private static Object resetLockObj;
    protected ReqMonitor nextReqMonitor;
    protected boolean monitorIsOn;
    protected boolean traceIsOn;
    protected String userName;
    protected String reqName;
    protected String reqDescr;
    protected long reqTS;
    protected long reqTime;
    protected long reqCpuTime;
    protected int reqOutData;
    private boolean active;
    private TaskMonitor mainTask;
    private int reqStatus;
    private int reqComp;
    private int reqCompLevel;
    private long reqElapsedTS;
    private long reqCpuTS;
    private int topListNr;
    private boolean overviewDone = false;
    private String compNetTimeName;
    private long compNetTime;
    private String compNetCpuTimeName;
    private long compNetCpuTime;
    private String compOutDataName;
    private long compOutData;

    protected ReqMonitor(TaskMonitor taskParam, String userParam, String reqParam, long currentTS, long elapsedTS, long cpuTS, boolean startTrace) {
        this.userName = userParam;
        this.reqName = reqParam;
        this.mainTask = taskParam;
        this.reqTS = currentTS;
        this.reqElapsedTS = elapsedTS;
        this.reqCpuTS = cpuTS;
        this.active = true;
        this.traceIsOn = startTrace;
        boolean bl = this.monitorIsOn = ConfMonitor.initMonitorSwitch == 1;
        if (!this.traceIsOn && !this.monitorIsOn) {
            this.monitorIsOn = true;
        }
    }

    protected static RequestSummary getSummaryOfRequests() {
        RequestSummary reqSum = new RequestSummary();
        ReqMonitor.privSummaryOfRequests(reqSum);
        return reqSum;
    }

    protected static RequestSummaryExt getSummaryOfRequestsExt() {
        if (!ConfMonitor.initTimingReady) {
            ConfMonitor.initTiming();
        }
        RequestSummaryExt reqSum = new RequestSummaryExt();
        ReqMonitor.privSummaryOfRequests(reqSum);
        if (ConfMonitor.availCpuTime) {
            reqSum.reqAccCpuTime = reqAccCpuTime;
            reqSum.reqAvgCpuTime = reqAccNr > 0L ? reqAccCpuTime / reqAccNr : 0L;
        } else {
            reqSum.reqAccCpuTime = -1L;
            reqSum.reqAvgCpuTime = -1L;
        }
        return reqSum;
    }

    protected static RequestOverview[] getTopRequests(int retOverview, int criterion, String namePattern, int maxResults) {
        RequestOverviewExt[] reqOverExt = ReqMonitor.getTopRequestsExt(retOverview, criterion, namePattern, maxResults);
        if (reqOverExt == null) {
            return null;
        }
        int reqNum = reqOverExt.length;
        RequestOverview[] reqOver = new RequestOverview[reqNum];
        int i = 0;
        while (i < reqNum) {
            reqOver[i] = ReqMonitor.copyReqOverviewExtToReqOverview(retOverview, reqOverExt[i]);
            ++i;
        }
        return reqOver;
    }

    protected static RequestOverviewExt[] getTopRequestsExt(int retOverview, int criterion, String namePattern, int maxResults) {
        if (!ConfMonitor.initTimingReady) {
            ConfMonitor.initTiming();
        }
        if (retOverview == 0 || maxResults < 1) {
            return null;
        }
        if (criterion == 0) {
            if (topReqTime == null) {
                return null;
            }
            TopList topList = topReqTime;
            synchronized (topList) {
                Object[] objs = topReqTime.searchElems(namePattern, maxResults);
                RequestOverviewExt[] requestOverviewExtArray = ReqMonitor.buildRequestOverview(retOverview, objs);
                return requestOverviewExtArray;
            }
        }
        if (criterion == 2) {
            if (topReqOutData == null) {
                return null;
            }
            TopList topList = topReqOutData;
            synchronized (topList) {
                Object[] objs = topReqOutData.searchElems(namePattern, maxResults);
                RequestOverviewExt[] requestOverviewExtArray = ReqMonitor.buildRequestOverview(retOverview, objs);
                return requestOverviewExtArray;
            }
        }
        return null;
    }

    protected static RequestOverview copyReqOverviewExtToReqOverview(int retOverview, RequestOverviewExt reqOverExt) {
        TaskOverview task;
        if (reqOverExt == null) {
            return null;
        }
        RequestOverview reqOver = new RequestOverview();
        reqOver.userName = reqOverExt.userName;
        reqOver.reqName = reqOverExt.reqName;
        reqOver.reqDescr = reqOverExt.reqDescr;
        reqOver.reqStatus = reqOverExt.reqStatus;
        reqOver.reqTS = reqOverExt.reqTS;
        reqOver.reqTime = reqOverExt.reqTime;
        reqOver.reqOutData = reqOverExt.reqOutData;
        reqOver.reqComp = reqOverExt.reqComp;
        reqOver.reqCompLevel = reqOverExt.reqCompLevel;
        reqOver.compNetTimeName = reqOverExt.compNetTimeName;
        reqOver.compNetTime = reqOverExt.compNetTime;
        reqOver.compOutDataName = reqOverExt.compOutDataName;
        reqOver.compOutData = reqOverExt.compOutData;
        if (retOverview != 1) {
            reqOver.taskOverview = null;
            return reqOver;
        }
        reqOver.taskOverview = new TaskOverview[1];
        reqOver.taskOverview[0] = task = new TaskOverview();
        TaskOverviewExt taskExt = reqOverExt.taskOverviewExt[0];
        task.taskName = taskExt.taskName;
        task.taskStatus = taskExt.taskStatus;
        task.taskTS = taskExt.taskTS;
        task.taskTime = taskExt.taskTime;
        task.taskOutData = taskExt.taskOutData;
        int compNum = taskExt.compOverviewExt.length;
        task.compOverview = new CompSingleOverview[compNum];
        int i = 0;
        while (i < compNum) {
            CompSingleOverview comp;
            task.compOverview[i] = comp = new CompSingleOverview();
            CompSingleOverviewExt compExt = taskExt.compOverviewExt[i];
            comp.compName = compExt.compName;
            comp.compDescr = compExt.compDescr;
            comp.level = compExt.level;
            comp.compStartTS = compExt.compStartTS;
            comp.compGrossTime = compExt.compGrossTime;
            comp.compNetTime = compExt.compNetTime;
            comp.compOutData = compExt.compOutData;
            comp.compProps = compExt.compProps;
            comp.actionOverview = compExt.actionOverview;
            ++i;
        }
        return reqOver;
    }

    protected static void startCondenseThread(long currentTS) {
        if (currentTS - lastCondenseThreadCallTS > (long)ConfMonitor.initCondenseStart) {
            lastCondenseThreadCallTS = currentTS;
            if (!CondenseThread.condenseThreadActive()) {
                CondenseThread condThreadRunner = new CondenseThread();
                Thread condThread = new Thread((Runnable)condThreadRunner, ConfMonitor.threadPrefix + ConfMonitor.threadCondenseSuffix);
                if (ConfMonitor.initCondenseDaemon == 1) {
                    condThread.setDaemon(true);
                }
                condThread.start();
            }
        }
    }

    protected static synchronized void putReadyList(ReqMonitor reqMonitor) {
        if (tailReadyRequestList != null) {
            ReqMonitor.tailReadyRequestList.nextReqMonitor = reqMonitor;
        } else {
            headReadyRequestList = reqMonitor;
        }
        tailReadyRequestList = reqMonitor;
        if ((readyListCompCount += reqMonitor.reqComp) >= ConfMonitor.initCondenseCompLimit) {
            readyListCompCount = 0;
            CondenseThread.wakeUp();
        }
    }

    protected static ReqMonitor getReadyList() {
        if (headReadyRequestList == null) {
            return null;
        }
        if (headReadyRequestList != tailReadyRequestList && tailReadyRequestList != null) {
            ReqMonitor hlpMonitor = headReadyRequestList;
            headReadyRequestList = hlpMonitor.nextReqMonitor;
            hlpMonitor.nextReqMonitor = null;
            return hlpMonitor;
        }
        return ReqMonitor.getReadyListSync();
    }

    protected static void resetMonitorData(int criterion) {
        Object object = resetLockObj;
        synchronized (object) {
            long resetTS = System.currentTimeMillis();
            try {
                CondenseThread.pause();
                switch (criterion) {
                    case 0: 
                    case 3: {
                        UserMonitor.resetUserData();
                        resetUserTS = resetTS;
                        if (criterion == 3) break;
                    }
                    case 2: {
                        CompMonitor.resetCompData();
                        resetCompTS = resetTS;
                        if (criterion == 2) break;
                    }
                    case 1: {
                        ReqMonitor.resetReqData();
                        ReqMonitor.resetReadyList();
                        resetReqTS = resetTS;
                    }
                }
                Object var5_3 = null;
            }
            catch (Throwable throwable) {
                Object var5_4 = null;
                CondenseThread.resume();
                throw throwable;
            }
            CondenseThread.resume();
        }
    }

    private static synchronized ReqMonitor getReadyListSync() {
        readyListCompCount = 0;
        if (headReadyRequestList == null) {
            return null;
        }
        ReqMonitor hlpMonitor = headReadyRequestList;
        headReadyRequestList = hlpMonitor.nextReqMonitor;
        if (headReadyRequestList == null) {
            tailReadyRequestList = null;
        } else {
            hlpMonitor.nextReqMonitor = null;
        }
        return hlpMonitor;
    }

    private static RequestOverviewExt[] buildRequestOverview(int retOverview, Object[] reqArr) {
        if (reqArr == null) {
            return null;
        }
        int nrOfRequests = reqArr.length;
        RequestOverviewExt[] resultReqs = new RequestOverviewExt[nrOfRequests];
        int i = 0;
        while (i < nrOfRequests) {
            resultReqs[i] = ((ReqMonitor)reqArr[i]).getRequestOverview(retOverview, false);
            ++i;
        }
        return resultReqs;
    }

    private static void privSummaryOfRequests(RequestSummary reqSum) {
        long currentTS = System.currentTimeMillis();
        reqSum.reqAccStatusCompNotClosed = reqAccStatusCompNotClosed;
        reqSum.reqAccStatusEndForced = reqAccStatusEndForced;
        reqSum.reqCompLevelBasic = reqCompLevelBasic;
        reqSum.reqCompLevelMedium = reqCompLevelMedium;
        reqSum.reqCompLevelDetail = reqCompLevelDetail;
        reqSum.reqAccNr = reqAccNr;
        reqSum.reqFirstTS = reqFirstTS;
        reqSum.reqAccOutDataFilled = reqAccOutDataFilled;
        reqSum.reqAccTime = reqAccTime;
        reqSum.reqAccOutData = reqAccOutData;
        reqSum.reqAccStatusOk = reqSum.reqAccNr - reqSum.reqAccStatusCompNotClosed - reqSum.reqAccStatusEndForced;
        if (reqSum.reqAccNr > 0L) {
            reqSum.reqAccComp = reqAccComp;
            reqSum.reqAvgTime = reqSum.reqAccTime / reqSum.reqAccNr;
            reqSum.reqAvgComp = reqSum.reqAccComp / reqSum.reqAccNr;
        } else {
            reqSum.reqAvgTime = 0L;
            reqSum.reqAvgComp = 0L;
        }
        long nrOfSeconds = (currentTS - (resetReqTS == 0L ? reqFirstTS : resetReqTS)) / 1000L;
        reqSum.reqPerSec = nrOfSeconds > 0L ? reqSum.reqAccNr / nrOfSeconds : 0L;
        reqSum.reqAvgOutData = reqSum.reqAccOutDataFilled > 0L ? reqSum.reqAccOutData / reqSum.reqAccOutDataFilled : 0L;
        reqSum.reqAccUserNr = reqAccUserNr;
        reqSum.reqStartAccUserNr = reqStartAccUserNr;
        reqSum.resetReqTS = resetReqTS;
        reqSum.resetCompTS = resetCompTS;
        reqSum.resetUserTS = resetUserTS;
    }

    /*
     * WARNING - void declaration
     */
    private static void resetReqData() {
        TopStruct currElem;
        int i;
        TopList topList;
        if (topReqTime != null) {
            topList = topReqTime;
            synchronized (topList) {
                i = 0;
                while ((currElem = topReqTime.getElem(i++)) != null) {
                    void var0_2;
                    ((ReqMonitor)var0_2.obj).freeRequest(1);
                }
                topReqTime.resetAll();
            }
        }
        if (topReqOutData != null) {
            topList = topReqOutData;
            synchronized (topList) {
                i = 0;
                while ((currElem = topReqOutData.getElem(i++)) != null) {
                    ((ReqMonitor)currElem.obj).freeRequest(1);
                }
                topReqOutData.resetAll();
            }
        }
        reqCompLevelDetail = 0L;
        reqCompLevelMedium = 0L;
        reqCompLevelBasic = 0L;
        reqAccOutData = 0L;
        reqAccInData = 0L;
        reqAccOutDataFilled = 0L;
        reqAccInDataFilled = 0L;
        reqAccTime = 0L;
        reqAccComp = 0L;
        reqAccStatusEndForced = 0L;
        reqAccStatusCompNotClosed = 0L;
        reqAccStatusOk = 0L;
        reqAccNr = 0L;
        if (ConfMonitor.availCpuTime) {
            reqAccCpuTime = 0L;
        }
    }

    /*
     * WARNING - void declaration
     */
    private static void resetReadyList() {
        ReqMonitor reqMon;
        while ((reqMon = ReqMonitor.getReadyList()) != null) {
            void var0;
            var0.freeRequest(0);
        }
    }

    protected RequestOverviewExt endRequest(int retOverview, int reqStatusParam, int dataLength, int reqCompParam, long currentTS, long elapsedTS, long cpuTS, int compLevel) {
        boolean returnOverview;
        RequestOverviewExt reqOverview = null;
        this.active = false;
        this.reqTime = ConfMonitor.getTimeDifference(true, this.reqElapsedTS, elapsedTS);
        this.reqCpuTime = ConfMonitor.getTimeDifference(false, this.reqCpuTS, cpuTS);
        this.reqOutData = dataLength;
        this.reqComp = reqCompParam;
        this.reqStatus = reqStatusParam;
        this.reqCompLevel = compLevel;
        if (this.userName == null) {
            this.userName = " ";
        }
        boolean provideTrace = this.traceIsOn && this.mainTask.checkTrace(false);
        boolean bl = returnOverview = this.monitorIsOn && retOverview != 0;
        if (provideTrace || returnOverview) {
            reqOverview = this.getRequestOverview(retOverview, provideTrace);
        }
        if (provideTrace) {
            this.mainTask.provideTraceData(reqOverview);
        }
        if (this.monitorIsOn) {
            ReqMonitor.putReadyList(this);
            ReqMonitor.startCondenseThread(currentTS);
        } else if (this.traceIsOn) {
            this.mainTask.freeTask();
        }
        if (returnOverview) {
            if (retOverview == 2) {
                reqOverview.taskOverview = null;
            }
            return reqOverview;
        }
        return null;
    }

    protected void updComponents() {
        reqAccComp += (long)this.mainTask.updComponents();
        if (reqFirstTS == 0L) {
            reqFirstTS = this.reqTS;
        }
        ++reqAccNr;
        reqAccTime += this.reqTime;
        if (ConfMonitor.availCpuTime) {
            reqAccCpuTime += this.reqCpuTime;
        }
        if (this.reqOutData > 0) {
            ++reqAccOutDataFilled;
            reqAccOutData += (long)this.reqOutData;
        }
        switch (this.reqStatus) {
            case 0: {
                ++reqAccStatusOk;
                break;
            }
            case 1: {
                ++reqAccStatusCompNotClosed;
                break;
            }
            case 2: 
            case 3: {
                ++reqAccStatusEndForced;
            }
        }
        switch (this.reqCompLevel) {
            case 0: {
                ++reqCompLevelBasic;
                break;
            }
            case 1: {
                ++reqCompLevelMedium;
                break;
            }
            case 2: {
                ++reqCompLevelDetail;
            }
        }
    }

    protected void updUser() {
        UserMonitor.updUser(this.userName, this);
    }

    protected boolean updTopRequests() {
        TopStruct replacedElem;
        TopStruct newElem = new TopStruct();
        boolean inserted = false;
        if (topReqTime == null) {
            topReqTime = new TopList(ConfMonitor.initNrTops, 0L);
            topReqOutData = new TopList(ConfMonitor.initNrTops, 0L);
        }
        TopList topList = topReqTime;
        synchronized (topList) {
            newElem.value = this.reqTime;
            newElem.objName = this.reqName;
            newElem.obj = this;
            replacedElem = topReqTime.insertElem(newElem);
            if (replacedElem != null) {
                inserted = true;
                ++this.topListNr;
                if (replacedElem.obj != null) {
                    ((ReqMonitor)replacedElem.obj).freeRequest(1);
                }
            }
        }
        TopList topList2 = topReqOutData;
        synchronized (topList2) {
            newElem.value = this.reqOutData;
            replacedElem = topReqOutData.insertElem(newElem);
            if (replacedElem != null) {
                inserted = true;
                ++this.topListNr;
                if (replacedElem.obj != null) {
                    ((ReqMonitor)replacedElem.obj).freeRequest(1);
                }
            }
        }
        return inserted;
    }

    protected synchronized void freeRequest(int topListSubtract) {
        this.topListNr -= topListSubtract;
        if (this.topListNr <= 0) {
            this.mainTask.freeTask();
        }
    }

    private RequestOverviewExt getRequestOverview(int retOverview, boolean provideTrace) {
        RequestOverviewExt reqOver = new RequestOverviewExt();
        CompSingleOverviewExt[] compOverview = null;
        reqOver.userName = this.userName;
        reqOver.reqName = this.reqName;
        reqOver.reqStatus = this.reqStatus;
        reqOver.reqDescr = this.reqDescr;
        reqOver.reqTS = this.reqTS;
        reqOver.reqTime = this.reqTime;
        reqOver.reqCpuTime = this.reqCpuTime;
        reqOver.reqOutData = this.reqOutData;
        reqOver.reqComp = this.reqComp;
        reqOver.reqCompLevel = this.reqCompLevel;
        if (retOverview == 1 || !this.overviewDone || provideTrace) {
            reqOver.taskOverviewExt = new TaskOverviewExt[1];
            reqOver.taskOverview = reqOver.taskOverviewExt;
            reqOver.taskOverviewExt[0] = new TaskOverviewExt();
            reqOver.taskOverviewExt[0].taskName = this.reqName;
            reqOver.taskOverviewExt[0].taskStatus = this.reqStatus;
            reqOver.taskOverviewExt[0].taskTS = this.reqTS;
            reqOver.taskOverviewExt[0].taskTime = this.reqTime;
            reqOver.taskOverviewExt[0].taskOutData = this.reqOutData;
            reqOver.taskOverviewExt[0].taskCpuTime = this.reqCpuTime;
            reqOver.taskOverviewExt[0].compOverviewExt = this.mainTask.getCompOverview(provideTrace);
            compOverview = reqOver.taskOverviewExt[0].compOverviewExt;
            reqOver.taskOverview[0].compOverview = compOverview;
        }
        if (!this.overviewDone) {
            this.compNetCpuTime = 0L;
            this.compNetCpuTimeName = " ";
            if (compOverview == null) {
                this.compNetTime = 0L;
                this.compNetTimeName = " ";
                this.compOutData = 0L;
                this.compOutDataName = " ";
            } else {
                this.compOutData = -1L;
                this.compNetTime = compOverview[0].compNetTime;
                this.compNetTimeName = compOverview[0].compName;
                if (ConfMonitor.availCpuTime) {
                    this.compNetCpuTime = compOverview[0].compNetCpuTime;
                    this.compNetCpuTimeName = compOverview[0].compName;
                }
                int i = 1;
                while (i < this.reqComp) {
                    if (compOverview[i].compNetTime > this.compNetTime) {
                        this.compNetTime = compOverview[i].compNetTime;
                        this.compNetTimeName = compOverview[i].compName;
                    }
                    if (ConfMonitor.availCpuTime && compOverview[i].compNetCpuTime > this.compNetCpuTime) {
                        this.compNetCpuTime = compOverview[i].compNetCpuTime;
                        this.compNetCpuTimeName = compOverview[i].compName;
                    }
                    if (compOverview[i].compOutData > this.compOutData && compOverview[i].level > 0) {
                        this.compOutData = compOverview[i].compOutData;
                        this.compOutDataName = compOverview[i].compName;
                    }
                    ++i;
                }
                if (this.compOutData == -1L) {
                    this.compOutDataName = " ";
                }
            }
            this.overviewDone = true;
        }
        reqOver.compNetTime = this.compNetTime;
        reqOver.compNetTimeName = this.compNetTimeName;
        reqOver.compNetCpuTime = this.compNetCpuTime;
        reqOver.compNetCpuTimeName = this.compNetCpuTimeName;
        reqOver.compOutData = this.compOutData;
        reqOver.compOutDataName = this.compOutDataName;
        if (retOverview == 2 && !provideTrace) {
            reqOver.taskOverview = null;
            reqOver.taskOverviewExt = null;
        }
        return reqOver;
    }

    static {
        resetLockObj = new Object();
    }
}

