/*
 * Decompiled with CFR 0.152.
 */
package com.sap.mbs.util.bogenerator.util;

import com.sap.mbs.util.bogenerator.util.XMLUtil;
import java.util.Calendar;
import java.util.Date;
import java.util.Vector;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XMLParser
extends XMLUtil {
    public static Element[] getChildElements(Element parent, String tagName) throws Exception {
        Element[] result = null;
        Vector<Element> entry = new Vector<Element>();
        NodeList children = parent.getChildNodes();
        int i = 0;
        while (i < children.getLength()) {
            Element element;
            String name;
            Node node = children.item(i);
            if (node instanceof Element && (name = (element = (Element)node).getTagName()).equals(tagName)) {
                entry.addElement((Element)node);
            }
            ++i;
        }
        int size = entry.size();
        result = new Element[size];
        int i2 = 0;
        while (i2 < size) {
            result[i2] = (Element)entry.elementAt(i2);
            ++i2;
        }
        return result;
    }

    public static Element getChildElement(Element parent, String tagName) throws Exception {
        Element result = null;
        try {
            result = XMLParser.getChildElements(parent, tagName)[0];
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }

    public static Element getFirstChild(Element root) throws Exception {
        Element child = null;
        NodeList list = root.getChildNodes();
        int i = 0;
        while (i < list.getLength()) {
            Node node = list.item(i);
            short type = node.getNodeType();
            if (1 == type) {
                child = (Element)node;
                break;
            }
            ++i;
        }
        return child;
    }

    public static String getValue(Element element) throws Exception {
        String value = null;
        value = element.getFirstChild().getNodeValue();
        return value;
    }

    public static boolean getValueAsBoolean(Element element) throws Exception {
        boolean value = false;
        String flag = XMLParser.getValue(element);
        if ("true".equals(flag)) {
            return true;
        }
        return value;
    }

    public static boolean isCreateInputQualityType(Element element, String name) throws Exception {
        String inputType = XMLParser.getAttrAsString(element, name);
        if ("create".equals(inputType)) {
            return true;
        }
        return false;
    }

    public static String getChildValue(Element element) throws Exception {
        String value = null;
        value = element.getFirstChild().getNodeValue();
        return value;
    }

    public static String getChildAsString(Element element, String name) throws Exception {
        String value = null;
        try {
            value = XMLParser.getChildElements(element, name)[0].getFirstChild().getNodeValue();
        }
        catch (Exception e) {
            String tag = element.getTagName();
            throw new Exception("tag/name/value:" + tag + "/" + name + "/" + value);
        }
        return value;
    }

    public static int getChildAsInt(Element element, String name) throws Exception {
        String value = null;
        try {
            value = XMLParser.getChildAsString(element, name);
            return Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            String tag = element.getTagName();
            throw new Exception("tag/name/value:" + tag + "/" + name + "/" + value);
        }
        catch (Exception e) {
            throw e;
        }
    }

    public static boolean getChildAsBoolean(Element element, String name) throws Exception {
        String value = null;
        try {
            value = XMLParser.getChildAsString(element, name);
            if ("true".equals(value)) {
                return true;
            }
        }
        catch (Exception e) {
            String tag = element.getTagName();
            throw new Exception("tag/name/value:" + tag + "/" + name + "/" + value);
        }
        return false;
    }

    public static String getAttrAsString(Element element, String name) throws Exception {
        String value = null;
        try {
            value = element.getAttribute(name);
        }
        catch (Exception e) {
            String tag = element.getTagName();
            throw new Exception("tag/name/value:" + tag + "/" + name + "/" + value);
        }
        return value;
    }

    public static int getAttrAsInt(Element element, String name) throws Exception {
        String value = null;
        try {
            value = XMLParser.getAttrAsString(element, name);
            value = value.trim();
            return Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            String tag = element.getTagName();
            throw new Exception("tag/name/value:" + tag + "/" + name + "/" + value);
        }
        catch (Exception e) {
            throw e;
        }
    }

    public static Date getAttrAsDate(Element element, String name) throws Exception {
        String value = null;
        try {
            value = XMLParser.getAttrAsString(element, name);
            String year = value.substring(0, 4);
            String month = value.substring(4, 6);
            String day = value.substring(6);
            Calendar cal = Calendar.getInstance();
            cal.set(2, new Integer(month) - 1);
            cal.set(5, new Integer(day));
            cal.set(1, new Integer(year));
            return cal.getTime();
        }
        catch (NumberFormatException e) {
            String tag = element.getTagName();
            throw new Exception("tag/name/value:" + tag + "/" + name + "/" + value);
        }
        catch (Exception e) {
            throw e;
        }
    }

    public static boolean getAttrAsBoolean(Element element, String name) throws Exception {
        String value = null;
        try {
            value = XMLParser.getAttrAsString(element, name);
            if ("true".equals(value)) {
                return true;
            }
        }
        catch (Exception e) {
            String tag = element.getTagName();
            throw new Exception("tag/name/value:" + tag + "/" + name + "/" + value);
        }
        return false;
    }
}

