/*
 * Decompiled with CFR 0.152.
 */
package com.sap.mbs.util.bogenerator.template;

import com.sap.mbs.util.bogenerator.template.DollarTag;
import com.sap.mbs.util.bogenerator.template.LoopTag;
import com.sap.mbs.util.bogenerator.template.TemplateException;
import com.sap.mbs.util.bogenerator.util.DateUtils;
import com.sap.mbs.util.bogenerator.util.FileReader;
import com.sap.mbs.util.bogenerator.util.Logger;
import com.sap.mbs.util.bogenerator.util.StringUtils;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.Calendar;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class TemplateParser {
    private static final Logger logger_ = new Logger();
    private static final String ENCODE_UTF8 = "UTF8";
    private static final String ENCODE_SJIS = "SJIS";
    private String template_;
    private String encoding_ = "UTF8";
    private Hashtable params_;
    private InputStream in_ = null;

    public TemplateParser(String template, String encoding) {
        this.template_ = template;
        this.encoding_ = encoding;
    }

    public TemplateParser(String template) {
        this.template_ = template;
    }

    public TemplateParser(InputStream in) {
        this.in_ = in;
    }

    public void setParameter(Hashtable params) {
        this.params_ = params;
    }

    public String parse() throws TemplateException, Exception {
        String content = null;
        try {
            content = this.in_ == null ? FileReader.readFile(this.template_, this.encoding_) : FileReader.readFile(this.in_);
            Enumeration e = this.params_.keys();
            while (e.hasMoreElements()) {
                DollarTag dollar;
                String key = (String)e.nextElement();
                Object obj = this.params_.get(key);
                if (obj instanceof String) {
                    dollar = null;
                    try {
                        dollar = new DollarTag(key);
                        content = StringUtils.replaceAll(content, dollar.getKey(), (String)obj);
                    }
                    catch (Exception e1) {
                        throw new TemplateException("not replace " + dollar.getKey() + " with " + (String)obj + " in " + this.template_);
                    }
                }
                if (obj instanceof Calendar) {
                    dollar = null;
                    try {
                        dollar = new DollarTag(key);
                        content = StringUtils.replaceAll(content, dollar.getKey(), DateUtils.Calendar2String((Calendar)obj));
                    }
                    catch (Exception e1) {
                        throw new TemplateException("not replace " + dollar.getKey() + " with " + (String)obj + " in " + this.template_);
                    }
                }
                if (!(obj instanceof Vector)) continue;
                LoopTag loop = null;
                try {
                    loop = new LoopTag(key, (Vector)obj);
                    content = loop.parse(content);
                }
                catch (Exception e2) {
                    throw new TemplateException("not replace " + loop.getKey() + " with " + obj.toString() + " in " + this.template_);
                }
            }
        }
        catch (TemplateException e) {
            throw e;
        }
        catch (FileNotFoundException e) {
            throw new TemplateException("File(" + this.template_ + ") not found: " + e.toString());
        }
        catch (Exception e) {
            throw e;
        }
        return content;
    }

    public static void main(String[] args) {
        try {
            Hashtable<String, Object> data = new Hashtable<String, Object>();
            data.put("lead_time", "12.12.2002");
            data.put("av_qty", "201");
            Vector v = new Vector();
            int i = 0;
            while (i < 3) {
                Hashtable<String, String> params = new Hashtable<String, String>();
                params.put("list.date", "date" + i);
                params.put("list.qty", "qty" + i);
                v.addElement(params);
                ++i;
            }
            data.put("list", v);
            TemplateParser obj = new TemplateParser("template.html", "");
            obj.setParameter(data);
            String str = obj.parse();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

