/*
 * Decompiled with CFR 0.152.
 */
package com.sap.mbs.util.bogenerator.meta;

import com.sap.mbs.util.bogenerator.meta.RowDefinition;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class SyncBoDefinition {
    private String id_ = null;
    private int version_ = -1;
    private String syncProcessing_ = null;
    private boolean allowCreate_ = false;
    private boolean allowModify_ = false;
    private boolean allowDelete_ = false;
    private boolean reqDirectSync_ = false;
    private boolean multiLangSupport_ = false;
    private RowDefinition topRowDefinition_ = null;
    private Hashtable rowDefinitionList_ = null;
    private Vector relationList_ = null;
    private boolean hasRelation_ = false;

    public SyncBoDefinition(String id, int version, String syncProcessing, boolean allowCreate, boolean allowModify, boolean allowDelete, boolean reqDirectSync, boolean multiLangSupport) {
        this._init();
        this.id_ = id;
        this.version_ = version;
        this.syncProcessing_ = syncProcessing;
        this.allowCreate_ = allowCreate;
        this.allowModify_ = allowModify;
        this.allowDelete_ = allowDelete;
        this.reqDirectSync_ = reqDirectSync;
        this.multiLangSupport_ = multiLangSupport;
    }

    private void _init() {
        this.rowDefinitionList_ = new Hashtable();
    }

    private void _initRelationList() throws Exception {
        this.relationList_ = new Vector();
        if (this.topRowDefinition_.hasRelation()) {
            this.relationList_.addAll(this.topRowDefinition_.getRelations());
        }
        Enumeration e = this.rowDefinitionList_.elements();
        while (e.hasMoreElements()) {
            RowDefinition row = (RowDefinition)e.nextElement();
            if (!row.hasRelation()) continue;
            this.relationList_.addAll(row.getRelations());
        }
        if (!this.relationList_.isEmpty()) {
            this.hasRelation_ = true;
        }
    }

    public boolean hasRelation() throws Exception {
        if (this.relationList_ == null) {
            this._initRelationList();
        }
        return this.hasRelation_;
    }

    public Vector getRelations() throws Exception {
        if (this.relationList_ == null) {
            this._initRelationList();
        }
        return this.relationList_;
    }

    public void setTopRowDefinition(RowDefinition topRowDefinition) throws Exception {
        this.topRowDefinition_ = topRowDefinition;
    }

    public void addRowDefinition(RowDefinition rowDefinition) throws Exception {
        String key = rowDefinition.getRowName();
        this.rowDefinitionList_.put(key, rowDefinition);
    }

    public boolean hasChildRow() {
        return this.rowDefinitionList_ != null && !this.rowDefinitionList_.isEmpty();
    }

    public String getSyncBoName() {
        return this.id_;
    }

    public String getSyncProcessing() {
        return this.syncProcessing_;
    }

    public RowDefinition getRowDefinition(String rowName) {
        if (this.topRowDefinition_.getRowName().equals(rowName)) {
            return this.topRowDefinition_;
        }
        return (RowDefinition)this.rowDefinitionList_.get(rowName);
    }

    public Hashtable getRowDefinitionList() {
        return this.rowDefinitionList_;
    }

    public Enumeration getRowDefinitionKeys() {
        return this.rowDefinitionList_.keys();
    }

    public boolean isRequiredDirectSync() {
        return this.reqDirectSync_;
    }

    public boolean isAllowedCreate() {
        return this.allowCreate_;
    }

    public boolean isAllowedModify() {
        return this.allowModify_;
    }

    public boolean isAllowedDelete() {
        return this.allowDelete_;
    }

    public boolean isMultiLangSupport() {
        return this.multiLangSupport_;
    }

    public int getVersionUid() {
        return this.version_;
    }

    public RowDefinition getTopRowDefinition() {
        return this.topRowDefinition_;
    }

    public String toXMLString() throws Exception {
        StringBuffer buf = new StringBuffer();
        buf.append("<SyncBo>");
        buf.append("[id:" + this.id_ + "]");
        buf.append("[version:" + this.version_ + "]");
        buf.append("[syncProcessing:" + this.syncProcessing_ + "]");
        buf.append("[allowCreate;" + this.allowCreate_ + "]");
        buf.append("[allowModify:" + this.allowModify_ + "]");
        buf.append("[allowDelete:" + this.allowDelete_ + "]");
        buf.append("[reqDirectSync:" + this.reqDirectSync_ + "]");
        buf.append("[multiLangSuppor:" + this.multiLangSupport_ + "]");
        buf.append("<TopRow>");
        buf.append(this.topRowDefinition_.toXMLString());
        buf.append("</TopRow>");
        if (!this.rowDefinitionList_.isEmpty()) {
            buf.append("<ChildRows>");
            Enumeration e = this.rowDefinitionList_.elements();
            while (e.hasMoreElements()) {
                RowDefinition row = (RowDefinition)e.nextElement();
                buf.append(row.toXMLString());
            }
            buf.append("</ChildRows>");
        }
        buf.append("</SyncBo>");
        return buf.toString();
    }
}

