/*
 * Decompiled with CFR 0.152.
 */
package com.sap.mbs.util.bogenerator.formatter;

import com.sap.mbs.util.bogenerator.UserProperty;
import java.util.Hashtable;
import java.util.StringTokenizer;

abstract class NameFormatter {
    String boPattern_ = null;
    String rowPattern_ = null;
    String fieldPattern_ = null;
    String boName_ = null;

    public NameFormatter(String boPattern, String rowPattern, String fieldPattern, String boName) {
        this.boPattern_ = boPattern;
        this.rowPattern_ = rowPattern;
        this.fieldPattern_ = fieldPattern;
        this.boName_ = boName;
    }

    public NameFormatter(UserProperty property, String boName) {
        try {
            this.boPattern_ = property.getBoPattern();
            this.rowPattern_ = property.getRowPattern();
            this.fieldPattern_ = property.getFieldPattern();
            this.boName_ = boName;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public String getBoPattern() {
        return this.boPattern_;
    }

    public String getRowPattern() {
        return this.rowPattern_;
    }

    public String getFieldPattern() {
        return this.fieldPattern_;
    }

    public String getSyncBoName() {
        return this.boName_;
    }

    public String getBaseClassName() throws Exception {
        String name;
        block5: {
            name = null;
            if (this.boPattern_.equals("XX_YY")) {
                name = NameFormatter.XX_YY2XxYy(this.boName_);
                break block5;
            }
            if (this.boPattern_.equals("Xx_Yy")) {
                name = NameFormatter.Xx_Yy2XxYy(this.boName_);
                break block5;
            }
            if (this.boPattern_.equals("XxYy")) {
                name = NameFormatter.XxYy2XxYy(this.boName_);
                break block5;
            }
            throw new UnsupportedOperationException();
        }
        return name;
    }

    public static String XX2Xx(String name) throws Exception {
        String result = null;
        result = name.toLowerCase();
        char[] chars = result.toCharArray();
        chars[0] = Character.toUpperCase(chars[0]);
        result = new String(chars);
        return result;
    }

    public static String XxYy2XXYY(String name) throws Exception {
        String result = null;
        result = name.toUpperCase();
        return result;
    }

    public static String XxYy2XxYy(String name) throws Exception {
        return name;
    }

    public static String XxYy2xxYy(String name) throws Exception {
        String result = null;
        char[] chars = name.toCharArray();
        chars[0] = Character.toLowerCase(chars[0]);
        result = new String(chars);
        return result;
    }

    public static String XxYy2XX_YY_NAME(String name) throws Exception {
        String result = null;
        result = NameFormatter.XxYy2XX_YY(name);
        return result + "_NAME";
    }

    public static String XxYy2XX_YY(String name) throws Exception {
        StringBuffer result = new StringBuffer();
        char[] chars = name.toCharArray();
        StringBuffer temp = new StringBuffer();
        int i = 0;
        while (i < chars.length) {
            if (i != 0 && Character.isUpperCase(chars[i])) {
                result.append(temp.toString().toUpperCase() + "_");
                temp = new StringBuffer();
                temp.append(chars[i]);
            } else {
                temp.append(chars[i]);
            }
            ++i;
        }
        result.append(temp.toString().toUpperCase());
        return result.toString();
    }

    public static String Xx_Yy2XxYy(String name) throws Exception {
        StringBuffer buf = null;
        buf = new StringBuffer();
        StringTokenizer token = new StringTokenizer(name, "_");
        while (token.hasMoreTokens()) {
            String str = token.nextToken();
            String str1 = str.substring(0, 1);
            String str2 = str.substring(1, str.length());
            str1 = str1.toUpperCase();
            str2 = str2.toLowerCase();
            buf.append(str1 + str2);
        }
        return buf.toString();
    }

    public static String Xx_Yy2XX_YY_NAME(String name) throws Exception {
        return name.toUpperCase() + "_NAME";
    }

    public static String XX_YY2XX_YY_NAME(String name) throws Exception {
        String result = null;
        result = name + "_NAME";
        return result;
    }

    public static String XX_YY2XX_YY(String name) throws Exception {
        return name;
    }

    public static String XX_YY2xxYy(String name) throws Exception {
        StringBuffer buf = null;
        buf = new StringBuffer();
        StringTokenizer token = new StringTokenizer(name, "_");
        int i = 0;
        while (token.hasMoreTokens()) {
            String str = token.nextToken();
            String str1 = str.substring(0, 1);
            String str2 = str.substring(1, str.length());
            str1 = i++ != 0 ? str1.toUpperCase() : str1.toLowerCase();
            str2 = str2.toLowerCase();
            buf.append(str1 + str2);
        }
        return buf.toString();
    }

    public static String XX_YY2XxYy(String name) throws Exception {
        StringBuffer buf = null;
        buf = new StringBuffer();
        StringTokenizer token = new StringTokenizer(name, "_");
        boolean i = false;
        while (token.hasMoreTokens()) {
            String str = token.nextToken();
            String str1 = str.substring(0, 1);
            String str2 = str.substring(1, str.length());
            str1 = str1.toUpperCase();
            str2 = str2.toLowerCase();
            buf.append(str1 + str2);
        }
        return buf.toString();
    }

    public static String convertDefaultType(String type) throws Exception {
        String result = null;
        type = NameFormatter.getJavaType(type);
        Hashtable<String, String> params = new Hashtable<String, String>();
        params.put("String", "DEF_STRING");
        params.put("Integer", "DEF_INTEGER");
        params.put("Calendar", "DEF_CALENDAR");
        params.put("FixedDecimal", "DEF_DECIMAL");
        result = (String)params.get(type);
        return result;
    }

    public static String getJavaType(String str) {
        Hashtable<String, String> params = new Hashtable<String, String>();
        params.put("N", "String");
        params.put("C", "String");
        params.put("I", "Integer");
        params.put("D", "Calendar");
        params.put("T", "Calendar");
        params.put("P", "FixedDecimal");
        return (String)params.get(str);
    }
}

