/*
 * Decompiled with CFR 0.152.
 */
package com.sap.mbs.util.bogenerator.builder.sample.menu.configure;

import com.sap.mbs.util.bogenerator.builder.BuildHelper;
import com.sap.mbs.util.bogenerator.builder.IClassBuilder;
import com.sap.mbs.util.bogenerator.builder.sample.api.Item;
import com.sap.mbs.util.bogenerator.builder.sample.api.ItemList;
import com.sap.mbs.util.bogenerator.builder.sample.api.Top;
import com.sap.mbs.util.bogenerator.builder.sample.api.TopItemsList;
import com.sap.mbs.util.bogenerator.formatter.SampleNameFormatter;
import java.util.Hashtable;

public class ConfigureBuilder
implements IClassBuilder {
    private BuildHelper helper_ = null;
    private TopItemsList list_ = null;

    public ConfigureBuilder(TopItemsList list) throws Exception {
        this.list_ = list;
        this.helper_ = new BuildHelper(this);
    }

    public void create() throws Exception {
        CoreBuilder builder1 = new CoreBuilder();
        builder1.create(this.list_);
    }

    private class CoreBuilder
    extends Builder {
        private CoreBuilder() {
        }

        public void create(TopItemsList list) throws Exception {
            String name1 = SampleNameFormatter.getApplicationJavaNameWithPackage();
            String name2 = SampleNameFormatter.getApplicationImplJavaNameWithPackage();
            String name3 = SampleNameFormatter.getAppComponentJavaNameWithPackage();
            String name4 = SampleNameFormatter.getAppComponentImplJavaNameWithPackage();
            this.params.put("application_java_with_package", name1);
            this.params.put("applicationimpl_java_with_package", name2);
            this.params.put("appcomponent_java_with_package", name3);
            this.params.put("appcomponentimpl_java_with_package", name4);
            this.params.put("block1", this._getBlock1(list));
            String content = ConfigureBuilder.this.helper_.getParsedContent("core.txt", this.params);
            String name = SampleNameFormatter.getCoreConfigureName();
            String dir = SampleNameFormatter.getCoreConfigureDir();
            ConfigureBuilder.this.helper_.saveFile(dir, name, content);
        }

        private String _getBlock1(TopItemsList list) throws Exception {
            StringBuffer buf = new StringBuffer();
            Hashtable<String, String> params = new Hashtable<String, String>();
            int i = 0;
            while (i < list.size()) {
                Top top = list.getTop(i);
                String name1 = top.getTopComponentJavaNameWithPackage();
                String name2 = top.getTopComponentImplJavaNameWithPackage();
                String name3 = top.getTopCustomJavaNameWithPackage();
                String name4 = top.getTopCustomImplJavaNameWithPackage();
                String name5 = top.getBoInterfacePackage();
                String name6 = top.getBoImplPackage();
                String name7 = top.getTopBoJavaName();
                params.put("top_component_java_with_package", name1);
                params.put("top_componentimpl_java_with_package", name2);
                params.put("top_custom_java_with_package", name3);
                params.put("top_customimpl_java_with_package", name4);
                params.put("bo_interface_package", name5);
                params.put("bo_impl_package", name6);
                params.put("top_bo_name", name7);
                String block2 = "";
                ItemList items = list.getItems(i);
                int j = 0;
                while (j < items.size()) {
                    Item item = items.get(j);
                    block2 = block2 + this._getBlock2(item);
                    ++j;
                }
                params.put("block2", block2);
                buf.append(ConfigureBuilder.this.helper_.getParsedContent("core_block1.txt", params));
                ++i;
            }
            return buf.toString();
        }

        private String _getBlock2(Item item) throws Exception {
            StringBuffer buf = new StringBuffer();
            String name1 = item.getBoInterfacePackage();
            String name2 = item.getBoImplPackage();
            String name3 = item.getItemBoJavaName();
            Hashtable<String, String> params = new Hashtable<String, String>();
            params.put("bo_interface_package", name1);
            params.put("bo_impl_package", name2);
            params.put("item_bo_name", name3);
            buf.append(ConfigureBuilder.this.helper_.getParsedContent("core_block2.txt", params));
            return buf.toString();
        }
    }

    abstract class Builder {
        public Hashtable params = new Hashtable();

        Builder() {
        }
    }
}

