/*
 * Decompiled with CFR 0.152.
 */
package com.sap.mbs.util.bogenerator.builder.sample.list.view;

import com.sap.mbs.util.bogenerator.builder.IClassBuilder;
import com.sap.mbs.util.bogenerator.builder.sample.AbstractSampleBuilder;
import com.sap.mbs.util.bogenerator.builder.sample.api.AbstractRow;
import com.sap.mbs.util.bogenerator.builder.sample.api.Item;
import com.sap.mbs.util.bogenerator.builder.sample.api.ItemList;
import com.sap.mbs.util.bogenerator.builder.sample.api.Top;
import com.sap.mbs.util.bogenerator.formatter.SampleNameFormatter;
import java.util.Hashtable;

public class ViewBuilder
extends AbstractSampleBuilder
implements IClassBuilder {
    public ViewBuilder(Top top, ItemList list) throws Exception {
        super(top, list);
        this.setBuildHelper(this);
    }

    public void create() throws Exception {
        TopBuilder tBuilder = new TopBuilder();
        tBuilder.create(this.top_, this.list_);
        if (this.list_.isEmpty()) {
            return;
        }
        int i = 0;
        while (i < this.list_.size()) {
            Item item = this.list_.get(i);
            ItemBuilder iBuilder = new ItemBuilder();
            iBuilder.create(item);
            ++i;
        }
    }

    private class ItemBuilder
    extends Builder {
        private ItemBuilder() {
        }

        public void create(Item item) throws Exception {
            Hashtable params = this._getDefaultParams(item);
            String name1 = item.getItemBoJavaName();
            String name2 = item.getItemListPackage();
            String name3 = item.getTopBoJavaName();
            params.put("item_bo_name", name1);
            params.put("item_list_java_package", name2);
            params.put("top_bo_name", name3);
            String content = ViewBuilder.this.helper_.getParsedContent("ItemList.txt", params);
            String dir = item.getItemListViewDir();
            ViewBuilder.this.helper_.saveFile(dir, item.getItemListViewName(), content);
        }
    }

    private class TopBuilder
    extends Builder {
        private TopBuilder() {
        }

        public void create(Top top, ItemList list) throws Exception {
            Hashtable params = this._getDefaultParams(top);
            String name1 = top.getTopBoJavaName();
            String name2 = top.getTopDetailPackage();
            params.put("top_bo_name", name1);
            params.put("top_detail_java_package", name2);
            String content = ViewBuilder.this.helper_.getParsedContent("TopList.txt", params);
            String dir = top.getTopListViewDir();
            ViewBuilder.this.helper_.saveFile(dir, top.getTopListViewName(), content);
        }

        private String _getBlock1(ItemList list) throws Exception {
            StringBuffer buf = new StringBuffer();
            if (list.isEmpty()) {
                return "";
            }
            int i = 0;
            while (i < list.size()) {
                Item item = list.get(i);
                String name = item.getItemBoJavaName();
                Hashtable<String, String> params = new Hashtable<String, String>();
                params.put("item_name", name);
                buf.append(ViewBuilder.this.helper_.getParsedContent("TopList_block1.txt", params));
                ++i;
            }
            return buf.toString();
        }
    }

    abstract class Builder {
        Builder() {
        }

        public Hashtable _getDefaultParams(AbstractRow row) throws Exception {
            Hashtable<String, String> params = new Hashtable<String, String>();
            String name1 = row.getComponentName();
            String name2 = SampleNameFormatter.getMenuComponentName(row.getUserProperty());
            params.put("component_name", name1);
            params.put("menu_component_name", name2);
            return params;
        }
    }
}

