/*
 * Decompiled with CFR 0.152.
 */
package com.sap.mbs.util.bogenerator.builder.sample.list.jsp;

import com.sap.mbs.util.bogenerator.builder.IClassBuilder;
import com.sap.mbs.util.bogenerator.builder.sample.AbstractSampleBuilder;
import com.sap.mbs.util.bogenerator.builder.sample.api.AbstractRow;
import com.sap.mbs.util.bogenerator.builder.sample.api.Item;
import com.sap.mbs.util.bogenerator.builder.sample.api.ItemList;
import com.sap.mbs.util.bogenerator.builder.sample.api.Top;
import java.util.Hashtable;

public class JspBuilder
extends AbstractSampleBuilder
implements IClassBuilder {
    public JspBuilder(Top top, ItemList list) throws Exception {
        super(top, list);
        this.setBuildHelper(this);
    }

    public void create() throws Exception {
        TopBuilder tBuilder = new TopBuilder();
        tBuilder.create(this.top_, this.list_);
        if (this.list_.isEmpty()) {
            return;
        }
        int i = 0;
        while (i < this.list_.size()) {
            Item item = this.list_.get(i);
            ItemBuilder iBuilder = new ItemBuilder();
            iBuilder.create(item);
            ++i;
        }
    }

    private class ItemBuilder
    extends Builder {
        private ItemBuilder() {
        }

        public void create(Item item) throws Exception {
            Hashtable params = this._getDefaultParams(item);
            String name3 = item.getItemBoJavaName();
            params.put("item_bo_name", name3);
            String content = JspBuilder.this.helper_.getParsedContent("ItemList.txt", params);
            String dir = item.getItemListJspDir();
            JspBuilder.this.helper_.saveFile(dir, item.getItemListJspName(), content);
        }
    }

    private class TopBuilder
    extends Builder {
        private TopBuilder() {
        }

        public void create(Top top, ItemList list) throws Exception {
            Hashtable params = this._getDefaultParams(top);
            String name1 = top.getTopBoJavaName();
            params.put("top_bo_name", name1);
            String content = JspBuilder.this.helper_.getParsedContent("TopList.txt", params);
            String dir = top.getTopListJspDir();
            JspBuilder.this.helper_.saveFile(dir, top.getTopListJspName(), content);
        }
    }

    abstract class Builder {
        Builder() {
        }

        public Hashtable _getDefaultParams(AbstractRow row) throws Exception {
            Hashtable params = new Hashtable();
            return params;
        }
    }
}

