/*
 * Decompiled with CFR 0.152.
 */
package com.sap.mbs.util.bogenerator.builder.sample.list.java;

import com.sap.mbs.util.bogenerator.builder.IClassBuilder;
import com.sap.mbs.util.bogenerator.builder.sample.AbstractSampleBuilder;
import com.sap.mbs.util.bogenerator.builder.sample.api.AbstractRow;
import com.sap.mbs.util.bogenerator.builder.sample.api.Item;
import com.sap.mbs.util.bogenerator.builder.sample.api.ItemList;
import com.sap.mbs.util.bogenerator.builder.sample.api.Top;
import java.util.Hashtable;

public class JavaBuilder
extends AbstractSampleBuilder
implements IClassBuilder {
    public JavaBuilder(Top top, ItemList list) throws Exception {
        super(top, list);
        this.setBuildHelper(this);
    }

    public void create() throws Exception {
        TopBuilder tBuilder = new TopBuilder();
        tBuilder.create(this.top_);
        if (this.list_.isEmpty()) {
            return;
        }
        int i = 0;
        while (i < this.list_.size()) {
            Item item = this.list_.get(i);
            ItemBuilder iBuilder = new ItemBuilder();
            iBuilder.create(item);
            ++i;
        }
    }

    private class ItemBuilder
    extends Builder {
        private ItemBuilder() {
        }

        public void create(Item item) throws Exception {
            Hashtable params = this._getDefaultParams(item);
            String name1 = item.getItemListPackage();
            String name2 = item.getItemListJavaName();
            String name3 = item.getItemBoJavaName();
            String name4 = item.getTopBoJavaName();
            params.put("package_name", name1);
            params.put("class_name", name2);
            params.put("item_bo_name", name3);
            params.put("top_bo_name_upper", name4.toUpperCase());
            params.put("top_bo_name", name4);
            String content = JavaBuilder.this.helper_.getParsedContent("ItemList.txt", params);
            JavaBuilder.this.helper_.saveJava(name1, name2, content);
        }
    }

    private class TopBuilder
    extends Builder {
        private TopBuilder() {
        }

        public void create(Top top) throws Exception {
            Hashtable params = this._getDefaultParams(top);
            String name1 = top.getTopListPackage();
            String name2 = top.getTopListJavaName();
            String name3 = top.getTopBoJavaName();
            params.put("package_name", name1);
            params.put("class_name", name2);
            params.put("top_bo_name_upper", name3.toUpperCase());
            params.put("top_bo_name", name3);
            String content = JavaBuilder.this.helper_.getParsedContent("TopList.txt", params);
            JavaBuilder.this.helper_.saveJava(name1, name2, content);
        }
    }

    abstract class Builder {
        Builder() {
        }

        public Hashtable _getDefaultParams(AbstractRow row) throws Exception {
            Hashtable<String, String> params = new Hashtable<String, String>();
            String name1 = row.getBoInterfacePackage();
            String name2 = row.getManagerJavaName();
            String name3 = row.getAbstractJavaName();
            params.put("bo_interface_package_name", name1);
            params.put("bo_manager_name", name2);
            params.put("abstract_class_name", name3);
            return params;
        }
    }
}

