/*
 * Decompiled with CFR 0.152.
 */
package com.sap.mbs.util.bogenerator.builder.sample.etc.xml;

import com.sap.mbs.util.bogenerator.builder.BuildHelper;
import com.sap.mbs.util.bogenerator.builder.IClassBuilder;
import com.sap.mbs.util.bogenerator.formatter.SampleNameFormatter;
import java.util.Hashtable;

public class XmlBuilder
implements IClassBuilder {
    private BuildHelper helper_ = new BuildHelper(this);

    public void create() throws Exception {
        WebBuilder builder1 = new WebBuilder();
        builder1.create();
        BuildBuilder builder2 = new BuildBuilder();
        builder2.create();
    }

    private class BuildBuilder
    extends Builder {
        private BuildBuilder() {
        }

        public void create() throws Exception {
            String project = SampleNameFormatter.getWebApplicationName();
            String name1 = SampleNameFormatter.getBoImplDir();
            String name2 = SampleNameFormatter.getPropertyFileName();
            this.params.put("project_name_lower", project.toLowerCase());
            this.params.put("project_name", project);
            this.params.put("bo_impl_dir", name1);
            this.params.put("property_file_name", name2);
            String content = XmlBuilder.this.helper_.getParsedContent("build.txt", this.params);
            String name = SampleNameFormatter.getBuildXmlName();
            String dir = SampleNameFormatter.getBuildXmlDir();
            XmlBuilder.this.helper_.saveFile(dir, name, content);
        }
    }

    private class WebBuilder
    extends Builder {
        private WebBuilder() {
        }

        public void create() throws Exception {
            String name1 = SampleNameFormatter.getFrontServletNameWithPackage();
            String name2 = SampleNameFormatter.getApplicationNameWithPackage();
            this.params.put("front_servlet_name_with_package", name1);
            this.params.put("application_name_with_package", name2);
            String content = XmlBuilder.this.helper_.getParsedContent("web.txt", this.params);
            String name = SampleNameFormatter.getWebXmlName();
            String dir = SampleNameFormatter.getWebXmlDir();
            XmlBuilder.this.helper_.saveFile(dir, name, content);
        }
    }

    abstract class Builder {
        Hashtable params = new Hashtable();

        Builder() {
        }
    }
}

