/*
 * Decompiled with CFR 0.152.
 */
package com.sap.mbs.util.bogenerator.builder.sample.detail.java;

import com.sap.mbs.util.bogenerator.builder.IClassBuilder;
import com.sap.mbs.util.bogenerator.builder.sample.AbstractSampleBuilder;
import com.sap.mbs.util.bogenerator.builder.sample.api.AbstractRow;
import com.sap.mbs.util.bogenerator.builder.sample.api.Item;
import com.sap.mbs.util.bogenerator.builder.sample.api.ItemList;
import com.sap.mbs.util.bogenerator.builder.sample.api.Top;
import com.sap.mbs.util.bogenerator.formatter.BoNameFormatter;
import com.sap.mbs.util.bogenerator.meta.FieldDefinition;
import java.util.Enumeration;
import java.util.Hashtable;

public class JavaBuilder
extends AbstractSampleBuilder
implements IClassBuilder {
    public JavaBuilder(Top top, ItemList list) throws Exception {
        super(top, list);
        this.setBuildHelper(this);
    }

    public void create() throws Exception {
        TopBuilder tBuilder = new TopBuilder();
        tBuilder.create(this.top_);
        if (this.list_.isEmpty()) {
            return;
        }
        int i = 0;
        while (i < this.list_.size()) {
            Item item = this.list_.get(i);
            ItemBuilder iBuilder = new ItemBuilder();
            iBuilder.create(item);
            ++i;
        }
    }

    private class ItemBuilder
    extends Builder {
        private ItemBuilder() {
        }

        public void create(Item item) throws Exception {
            Hashtable params = this._getDefaultParams(item);
            String name1 = item.getItemDetailPackage();
            String name2 = item.getItemDetailJavaName();
            String name3 = item.getItemBoJavaName();
            String name4 = item.getTopBoJavaName();
            params.put("package_name", name1);
            params.put("class_name", name2);
            params.put("item_bo_name", name3);
            params.put("top_bo_name_upper", name4.toUpperCase());
            params.put("top_bo_name", name4);
            params.put("block1", this._getBlock1(item));
            String content = JavaBuilder.this.helper_.getParsedContent("ItemDetail.txt", params);
            JavaBuilder.this.helper_.saveJava(name1, name2, content);
        }

        private String _getBlock1(Item item) throws Exception {
            StringBuffer buf = new StringBuffer();
            BoNameFormatter bnf = item.getBoNameFormatter();
            Enumeration e = item.getFieldElements();
            while (e.hasMoreElements()) {
                FieldDefinition field = (FieldDefinition)e.nextElement();
                String name = field.getFieldName();
                if (name.equals(bnf.getSyncKey())) continue;
                String type = field.getFieldType();
                String name1 = bnf.field2XxYy(name);
                String name2 = this.getConvertMethodName(type);
                Hashtable<String, String> params = new Hashtable<String, String>();
                params.put("field_method_name", name1);
                params.put("convert_method", name2);
                buf.append(JavaBuilder.this.helper_.getParsedContent("ItemDetail_block1.txt", params) + "\n");
            }
            return buf.toString();
        }
    }

    private class TopBuilder
    extends Builder {
        private TopBuilder() {
        }

        public void create(Top top) throws Exception {
            Hashtable params = this._getDefaultParams(top);
            String name1 = top.getTopDetailPackage();
            String name2 = top.getTopDetailJavaName();
            String name3 = top.getTopBoJavaName();
            params.put("package_name", name1);
            params.put("class_name", name2);
            params.put("top_bo_name_upper", name3.toUpperCase());
            params.put("top_bo_name", name3);
            params.put("block1", this._getBlock1(top));
            String content = JavaBuilder.this.helper_.getParsedContent("TopDetail.txt", params);
            JavaBuilder.this.helper_.saveJava(name1, name2, content);
        }

        private String _getBlock1(Top top) throws Exception {
            StringBuffer buf = new StringBuffer();
            BoNameFormatter bnf = top.getBoNameFormatter();
            Enumeration e = top.getFieldElements();
            while (e.hasMoreElements()) {
                FieldDefinition field = (FieldDefinition)e.nextElement();
                String name = field.getFieldName();
                if (name.equals(bnf.getSyncKey())) continue;
                String type = field.getFieldType();
                String name1 = bnf.field2XxYy(name);
                String name2 = this.getConvertMethodName(type);
                Hashtable<String, String> params = new Hashtable<String, String>();
                params.put("field_method_name", name1);
                params.put("convert_method", name2);
                buf.append(JavaBuilder.this.helper_.getParsedContent("TopDetail_block1.txt", params) + "\n");
            }
            return buf.toString();
        }
    }

    abstract class Builder {
        Builder() {
        }

        public String getConvertMethodName(String str) throws Exception {
            String method = null;
            Hashtable<String, String> methods = new Hashtable<String, String>();
            methods.put("N", "String2String");
            methods.put("C", "String2String");
            methods.put("I", "Integer2String");
            methods.put("D", "Calendar2String");
            methods.put("T", "CalendarTime2String");
            methods.put("P", "FixedDecimal2String");
            method = (String)methods.get(str);
            return method;
        }

        public Hashtable _getDefaultParams(AbstractRow row) throws Exception {
            Hashtable<String, String> params = new Hashtable<String, String>();
            String name1 = row.getBoInterfacePackage();
            String name2 = row.getManagerJavaName();
            String name3 = row.getAbstractJavaName();
            params.put("bo_interface_package_name", name1);
            params.put("bo_manager_name", name2);
            params.put("abstract_class_name", name3);
            return params;
        }
    }
}

