/*
 * Decompiled with CFR 0.152.
 */
package com.sap.mbs.util.bogenerator.builder.sample.common.java;

import com.sap.mbs.util.bogenerator.builder.IClassBuilder;
import com.sap.mbs.util.bogenerator.builder.sample.AbstractSampleBuilder;
import com.sap.mbs.util.bogenerator.builder.sample.api.AbstractRow;
import com.sap.mbs.util.bogenerator.builder.sample.api.Item;
import com.sap.mbs.util.bogenerator.builder.sample.api.ItemList;
import com.sap.mbs.util.bogenerator.builder.sample.api.Top;
import java.util.Hashtable;

public class JavaBuilder
extends AbstractSampleBuilder
implements IClassBuilder {
    public JavaBuilder(Top top, ItemList list) throws Exception {
        super(top, list);
        this.setBuildHelper(this);
    }

    public void create() throws Exception {
        AbstractBuilder builder1 = new AbstractBuilder();
        builder1.create(this.top_);
        ComponentBuilder builder2 = new ComponentBuilder();
        builder2.create(this.top_);
        CustomBuilder builder3 = new CustomBuilder();
        builder3.create(this.top_, this.list_);
    }

    private class CustomBuilder
    extends Builder {
        private CustomBuilder() {
        }

        private String _getBlock1(ItemList list) throws Exception {
            StringBuffer buf = new StringBuffer();
            if (list.isEmpty()) {
                return "";
            }
            int i = 0;
            while (i < list.size()) {
                Item item = list.get(i);
                String name = item.getItemBoJavaName();
                Hashtable<String, String> params = new Hashtable<String, String>();
                params.put("item_bo_name", name);
                buf.append(JavaBuilder.this.helper_.getParsedContent("TopCustom_block1.txt", params));
                ++i;
            }
            return buf.toString();
        }

        private String _getBlock1(Top top, ItemList list) throws Exception {
            StringBuffer buf = new StringBuffer();
            if (list.isEmpty()) {
                return "";
            }
            int i = 0;
            while (i < list.size()) {
                Item item = list.get(i);
                String name = item.getItemBoJavaName();
                Hashtable<String, String> params = new Hashtable<String, String>();
                params.put("item_bo_name", name);
                params.put("item_bo_name_lower", name.toLowerCase());
                buf.append(JavaBuilder.this.helper_.getParsedContent("TopCustomImpl_block1.txt", params));
                ++i;
            }
            return buf.toString();
        }

        private String _getBlock2(Top top, ItemList list) throws Exception {
            StringBuffer buf = new StringBuffer();
            if (list.isEmpty()) {
                return "";
            }
            int i = 0;
            while (i < list.size()) {
                Item item = list.get(i);
                String name = item.getItemBoJavaName();
                Hashtable<String, String> params = new Hashtable<String, String>();
                params.put("item_bo_name_lower", name.toLowerCase());
                buf.append(JavaBuilder.this.helper_.getParsedContent("TopCustomImpl_block2.txt", params));
                ++i;
            }
            return buf.toString();
        }

        private String _getBlock3(Top top, ItemList list) throws Exception {
            StringBuffer buf = new StringBuffer();
            if (list.isEmpty()) {
                return "";
            }
            int i = 0;
            while (i < list.size()) {
                Item item = list.get(i);
                String name1 = item.getItemBoJavaName();
                String name2 = item.getTopBoJavaName();
                Hashtable<String, String> params = new Hashtable<String, String>();
                params.put("item_bo_name", name1);
                params.put("top_bo_name", name2);
                params.put("item_bo_name_lower", name1.toLowerCase());
                buf.append(JavaBuilder.this.helper_.getParsedContent("TopCustomImpl_block3.txt", params));
                ++i;
            }
            return buf.toString();
        }

        public void create(Top top, ItemList list) throws Exception {
            Hashtable params = this._getDefaultParams(top);
            String name1 = top.getTopCustomPackage();
            String name2 = top.getTopCustomJavaName();
            String name3 = top.getTopBoJavaName();
            String name4 = top.getBoInterfacePackage();
            params.put("package_name", name1);
            params.put("class_name", name2);
            params.put("top_bo_name", name3);
            params.put("bo_interface_package", name4);
            params.put("block1", this._getBlock1(list));
            String content = JavaBuilder.this.helper_.getParsedContent("TopCustom.txt", params);
            JavaBuilder.this.helper_.saveJava(name1, name2, content);
            params.remove("class_name");
            params.remove("package_name");
            params.remove("block1");
            String name5 = top.getTopCustomImplPackage();
            String name6 = top.getTopCustomImplJavaName();
            params.put("package_name", name5);
            params.put("class_name", name6);
            params.put("control_package_name", name1);
            params.put("top_bo_name_lower", name3.toLowerCase());
            params.put("block1", this._getBlock1(top, list));
            params.put("block2", this._getBlock2(top, list));
            params.put("block3", this._getBlock3(top, list));
            content = JavaBuilder.this.helper_.getParsedContent("TopCustomImpl.txt", params);
            JavaBuilder.this.helper_.saveJava(name5, name6, content);
        }
    }

    private class ComponentBuilder
    extends Builder {
        private ComponentBuilder() {
        }

        public void create(Top top) throws Exception {
            Hashtable params = this._getDefaultParams(top);
            String name1 = top.getTopComponentPackage();
            String name2 = top.getTopComponentJavaName();
            String name3 = top.getTopBoJavaName();
            params.put("package_name", name1);
            params.put("class_name", name2);
            params.put("top_bo_name", name3);
            String content = JavaBuilder.this.helper_.getParsedContent("TopComponent.txt", params);
            JavaBuilder.this.helper_.saveJava(name1, name2, content);
            params.remove("class_name");
            params.remove("package_name");
            String name4 = top.getTopComponentImplPackage();
            String name5 = top.getTopComponentImplJavaName();
            String name6 = top.getComponentName();
            params.put("package_name", name4);
            params.put("class_name", name5);
            params.put("component_package_name", name1);
            params.put("top_bo_name_upper", name3.toUpperCase());
            params.put("component_name", name6);
            content = JavaBuilder.this.helper_.getParsedContent("TopComponentImpl.txt", params);
            JavaBuilder.this.helper_.saveJava(name4, name5, content);
        }
    }

    private class AbstractBuilder
    extends Builder {
        private AbstractBuilder() {
        }

        public void create(Top top) throws Exception {
            Hashtable params = this._getDefaultParams(top);
            String name1 = top.getTopAbstractPackage();
            String name2 = top.getTopAbstractJavaName();
            String name3 = top.getTopBoJavaName();
            params.put("package_name", name1);
            params.put("class_name", name2);
            params.put("top_bo_name", name3);
            String content = JavaBuilder.this.helper_.getParsedContent("TopAbstract.txt", params);
            JavaBuilder.this.helper_.saveJava(name1, name2, content);
        }
    }

    abstract class Builder {
        Builder() {
        }

        public Hashtable _getDefaultParams(AbstractRow row) throws Exception {
            Hashtable params = new Hashtable();
            return params;
        }
    }
}

