/*
 * Decompiled with CFR 0.152.
 */
package com.sap.mbs.util.bogenerator.builder.sample.api;

import com.sap.mbs.util.bogenerator.builder.sample.api.Item;
import com.sap.mbs.util.bogenerator.meta.RowDefinition;
import com.sap.mbs.util.bogenerator.meta.SyncBoDefinition;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class ItemList
implements Comparator {
    private Vector list_ = null;

    public ItemList(Hashtable list) throws Exception {
        this._init();
        this._transform(list);
        this._sort();
    }

    public static ItemList toItemList(SyncBoDefinition bo) throws Exception {
        ItemList list = null;
        Hashtable items = bo.getRowDefinitionList();
        list = new ItemList(items);
        return list;
    }

    private void _init() {
        this.list_ = new Vector();
    }

    public int compare(Object o1, Object o2) throws ClassCastException {
        try {
            Item item1 = (Item)o1;
            Item item2 = (Item)o2;
            String name1 = item1.getItemBoJavaName();
            String name2 = item2.getItemBoJavaName();
            return name1.compareTo(name2);
        }
        catch (Exception e) {
            throw new ClassCastException();
        }
    }

    private void _sort() throws Exception {
        try {
            Object[] arrays = this.list_.toArray();
            Arrays.sort(arrays, this);
            Vector<Item> temp = new Vector<Item>();
            int i = 0;
            while (i < arrays.length) {
                temp.add(i, (Item)arrays[i]);
                ++i;
            }
            this.list_ = temp;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void _transform(Hashtable list) throws Exception {
        if (list.isEmpty()) {
            return;
        }
        Item item = null;
        Enumeration e = list.elements();
        while (e.hasMoreElements()) {
            RowDefinition child = (RowDefinition)e.nextElement();
            item = new Item(child);
            this.list_.add(item);
        }
    }

    public int size() {
        return this.list_.size();
    }

    public Item get(int index) {
        return (Item)this.list_.get(index);
    }

    public boolean isEmpty() {
        return this.list_.isEmpty();
    }
}

