/*
 * Decompiled with CFR 0.152.
 */
package com.sap.mbs.util.bogenerator.builder.bomanager.interfaceclass;

import com.sap.mbs.util.bogenerator.UserProperty;
import com.sap.mbs.util.bogenerator.builder.BuildHelper;
import com.sap.mbs.util.bogenerator.builder.IClassBuilder;
import com.sap.mbs.util.bogenerator.builder.bomanager.AbstractManagerClassBuilder;
import com.sap.mbs.util.bogenerator.formatter.BoNameFormatter;
import com.sap.mbs.util.bogenerator.formatter.MgrNameFormatter;
import com.sap.mbs.util.bogenerator.meta.RelationDefinition;
import com.sap.mbs.util.bogenerator.meta.RowDefinition;
import com.sap.mbs.util.bogenerator.meta.SyncBoDefinition;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class ManagerInterfaceClassBuilder
extends AbstractManagerClassBuilder
implements IClassBuilder {
    private BuildHelper helper_ = null;
    private MgrNameFormatter formatter_ = null;

    public ManagerInterfaceClassBuilder(SyncBoDefinition syncBo) throws Exception {
        super(syncBo);
    }

    private void _init(UserProperty property) throws Exception {
        this.helper_ = new BuildHelper(this);
        this.helper_.mkJavaSrcDirs();
        this.formatter_ = new MgrNameFormatter(property.getBoPattern(), property.getRowPattern(), property.getFieldPattern(), this.getBoName());
    }

    public void createManagerClasses(UserProperty property) throws Exception {
        CharSequence buf;
        Hashtable<String, String> params = null;
        this._init(property);
        String AUTHOR = property.getAuthor();
        String CURRENT_DATE = property.getCurrentDate();
        String INTERFACE_PACKAGE_NAME = property.getInterfacePackageName();
        String CLASS_NAME = this.formatter_.getMgrInterfaceClassName();
        String TOP_BO_NAME = this.formatter_.getTopBusinessObjectName();
        params = new Hashtable<String, String>();
        params.put("package_name", INTERFACE_PACKAGE_NAME);
        params.put("class_name", CLASS_NAME);
        params.put("author", AUTHOR);
        params.put("current_date", CURRENT_DATE);
        params.put("top_bo_name", TOP_BO_NAME);
        params.put("lookup_method", this._getLookupMethod(TOP_BO_NAME));
        params.put("get_method", this._getGetMethod(TOP_BO_NAME));
        if (this.isAllowToAddCreateInsertMethods()) {
            params.put("create_method", this._getCreateMethod(TOP_BO_NAME));
            params.put("insert_method", this._getInsertMethod(TOP_BO_NAME));
            params.put("update_method", this._getUpdateMethod(TOP_BO_NAME));
            params.put("delete_method", this._getDeleteMethod(TOP_BO_NAME));
            if (this.hasChildRow()) {
                params.put("copy_method", this._getCopyMethod(TOP_BO_NAME));
            } else {
                params.put("copy_method", "");
            }
        } else {
            params.put("create_method", "");
            params.put("insert_method", "");
            if (this.isAllowToAddUpdateMethod()) {
                params.put("update_method", this._getUpdateMethod(TOP_BO_NAME));
            } else {
                params.put("update_method", "");
            }
            if (this.isAllowToAddCopyMethod()) {
                params.put("copy_method", this._getCopyMethod(TOP_BO_NAME));
            } else {
                params.put("copy_method", "");
            }
            if (this.isAllowToAddDeleteMethod()) {
                params.put("delete_method", this._getDeleteMethod(TOP_BO_NAME));
            } else {
                params.put("delete_method", "");
            }
        }
        if (this.hasChildRow()) {
            buf = this._buildMethods4ChildRow(TOP_BO_NAME);
            params.put("child_methods", (String)buf);
        } else {
            params.put("child_methods", "");
        }
        if (this.hasRelation()) {
            buf = new StringBuffer();
            Vector relations = this.getRelations();
            Enumeration e = relations.elements();
            while (e.hasMoreElements()) {
                RelationDefinition re = (RelationDefinition)e.nextElement();
                ((StringBuffer)buf).append(this._getRelationMethods(re, property) + "\n");
            }
            params.put("relation_methods", ((StringBuffer)buf).toString());
        } else {
            params.put("relation_methods", "");
        }
        String content = this.helper_.getParsedContent("template.txt", params);
        this.helper_.saveClass(INTERFACE_PACKAGE_NAME, CLASS_NAME, content);
    }

    private String _buildMethods4ChildRow(String topBoName) throws Exception {
        StringBuffer buf = null;
        buf = new StringBuffer();
        Enumeration e = this.getChildRowNames();
        while (e.hasMoreElements()) {
            String childRowName = (String)e.nextElement();
            buf.append(this._getLookupMethod2(topBoName, childRowName) + "\n");
            buf.append(this._getGetMethod2(topBoName, childRowName) + "\n");
            buf.append(this._getLookupParentMethod(topBoName, childRowName) + "\n");
            if (!this.isAllowToAddCreateInsertUpdateDeleteMethods()) continue;
            buf.append(this._getCreateMethod2(topBoName, childRowName) + "\n");
            buf.append(this._getInsertMethod2(topBoName, childRowName) + "\n");
            buf.append(this._getUpdateMethod2(topBoName, childRowName) + "\n");
            buf.append(this._getDeleteMethod2(topBoName, childRowName) + "\n");
        }
        return buf.toString();
    }

    private String _getLookupMethod(String topBoName) throws Exception {
        StringBuffer buf = new StringBuffer();
        String infile = "method_lookup.txt";
        Hashtable<String, String> params = new Hashtable<String, String>();
        params.put("top_bo_name", topBoName);
        buf.append(this.helper_.getParsedContent(infile, params));
        return buf.toString();
    }

    private String _getGetMethod(String topBoName) throws Exception {
        StringBuffer buf = new StringBuffer();
        String infile = "method_get.txt";
        Hashtable<String, String> params = new Hashtable<String, String>();
        params.put("top_bo_name", topBoName);
        buf.append(this.helper_.getParsedContent(infile, params));
        return buf.toString();
    }

    private String _getCreateMethod(String topBoName) throws Exception {
        StringBuffer buf = new StringBuffer();
        String infile = "method_create.txt";
        Hashtable<String, String> params = new Hashtable<String, String>();
        params.put("top_bo_name", topBoName);
        buf.append(this.helper_.getParsedContent(infile, params));
        return buf.toString();
    }

    private String _getInsertMethod(String topBoName) throws Exception {
        StringBuffer buf = new StringBuffer();
        String infile = "method_insert.txt";
        Hashtable<String, String> params = new Hashtable<String, String>();
        params.put("top_bo_name", topBoName);
        buf.append(this.helper_.getParsedContent(infile, params));
        return buf.toString();
    }

    private String _getCopyMethod(String topBoName) throws Exception {
        StringBuffer buf = new StringBuffer();
        String infile = "method_copy.txt";
        Hashtable<String, String> params = new Hashtable<String, String>();
        params.put("top_bo_name", topBoName);
        buf.append(this.helper_.getParsedContent(infile, params));
        return buf.toString();
    }

    private String _getUpdateMethod(String topBoName) throws Exception {
        StringBuffer buf = new StringBuffer();
        String infile = "method_update.txt";
        Hashtable<String, String> params = new Hashtable<String, String>();
        params.put("top_bo_name", topBoName);
        buf.append(this.helper_.getParsedContent(infile, params));
        return buf.toString();
    }

    private String _getDeleteMethod(String topBoName) throws Exception {
        StringBuffer buf = new StringBuffer();
        String infile = "method_delete.txt";
        Hashtable<String, String> params = new Hashtable<String, String>();
        params.put("top_bo_name", topBoName);
        buf.append(this.helper_.getParsedContent(infile, params));
        return buf.toString();
    }

    private String _getLookupMethod2(String topBoName, String childName) throws Exception {
        StringBuffer buf = new StringBuffer();
        String infile = "method_lookup2.txt";
        String CHILD_BO_NAME = this.formatter_.getChildBusinessObjectName(childName);
        Hashtable<String, String> params = new Hashtable<String, String>();
        params.put("top_bo_name", topBoName);
        params.put("child_bo_name", CHILD_BO_NAME);
        buf.append(this.helper_.getParsedContent(infile, params));
        return buf.toString();
    }

    private String _getGetMethod2(String topBoName, String childName) throws Exception {
        StringBuffer buf = new StringBuffer();
        String infile = "method_get2.txt";
        String CHILD_BO_NAME = this.formatter_.getChildBusinessObjectName(childName);
        Hashtable<String, String> params = new Hashtable<String, String>();
        params.put("top_bo_name", topBoName);
        params.put("child_bo_name", CHILD_BO_NAME);
        buf.append(this.helper_.getParsedContent(infile, params));
        return buf.toString();
    }

    private String _getCreateMethod2(String topBoName, String childName) throws Exception {
        StringBuffer buf = new StringBuffer();
        String infile = "method_create2.txt";
        String CHILD_BO_NAME = this.formatter_.getChildBusinessObjectName(childName);
        Hashtable<String, String> params = new Hashtable<String, String>();
        params.put("top_bo_name", topBoName);
        params.put("child_bo_name", CHILD_BO_NAME);
        buf.append(this.helper_.getParsedContent(infile, params));
        return buf.toString();
    }

    private String _getInsertMethod2(String topBoName, String childName) throws Exception {
        StringBuffer buf = new StringBuffer();
        String infile = "method_insert2.txt";
        String CHILD_BO_NAME = this.formatter_.getChildBusinessObjectName(childName);
        Hashtable<String, String> params = new Hashtable<String, String>();
        params.put("top_bo_name", topBoName);
        params.put("child_bo_name", CHILD_BO_NAME);
        buf.append(this.helper_.getParsedContent(infile, params));
        return buf.toString();
    }

    private String _getUpdateMethod2(String topBoName, String childName) throws Exception {
        StringBuffer buf = new StringBuffer();
        String infile = "method_update2.txt";
        String CHILD_BO_NAME = this.formatter_.getChildBusinessObjectName(childName);
        Hashtable<String, String> params = new Hashtable<String, String>();
        params.put("top_bo_name", topBoName);
        params.put("child_bo_name", CHILD_BO_NAME);
        buf.append(this.helper_.getParsedContent(infile, params));
        return buf.toString();
    }

    private String _getDeleteMethod2(String topBoName, String childName) throws Exception {
        StringBuffer buf = new StringBuffer();
        String infile = "method_delete2.txt";
        String CHILD_BO_NAME = this.formatter_.getChildBusinessObjectName(childName);
        Hashtable<String, String> params = new Hashtable<String, String>();
        params.put("top_bo_name", topBoName);
        params.put("child_bo_name", CHILD_BO_NAME);
        buf.append(this.helper_.getParsedContent(infile, params));
        return buf.toString();
    }

    private String _getLookupParentMethod(String topBoName, String childName) throws Exception {
        StringBuffer buf = new StringBuffer();
        String infile = "method_lookup_parent.txt";
        String CHILD_BO_NAME = this.formatter_.getChildBusinessObjectName(childName);
        Hashtable<String, String> params = new Hashtable<String, String>();
        params.put("top_bo_name", topBoName);
        params.put("child_bo_name", CHILD_BO_NAME);
        buf.append(this.helper_.getParsedContent(infile, params));
        return buf.toString();
    }

    private String _getRelationMethods(RelationDefinition re, UserProperty property) throws Exception {
        String buf = null;
        String boPattern = this.formatter_.getBoPattern();
        String rowPattern = this.formatter_.getRowPattern();
        String fieldPattern = this.formatter_.getFieldPattern();
        BoNameFormatter to = new BoNameFormatter(boPattern, rowPattern, fieldPattern, re.getToBoName(), re.getToRowName(), false);
        BoNameFormatter from = null;
        RowDefinition row = re.getFromRowDefinition();
        if (row.isTopRow()) {
            from = new BoNameFormatter(boPattern, rowPattern, fieldPattern, re.getFromBoName(), re.getFromRowName(), false);
            buf = this._getRelationMethods1(re, property, to, from);
        } else {
            from = new BoNameFormatter(boPattern, rowPattern, fieldPattern, re.getFromBoName(), re.getFromRowName(), true);
            BoNameFormatter parent = new BoNameFormatter(boPattern, rowPattern, fieldPattern, re.getFromBoName(), re.getFromRowName(), false);
            buf = this._getRelationMethods2(re, property, to, from, parent);
        }
        return buf;
    }

    private String _getRelationMethods1(RelationDefinition re, UserProperty property, BoNameFormatter to, BoNameFormatter from) throws Exception {
        StringBuffer buf = new StringBuffer();
        String infile = "methods_relation.txt";
        String fromFieldName = re.getFromFieldName();
        String BO_NAME = from.getBoInterfaceClassName();
        String TARGET_NAME = to.getBoInterfaceClassName();
        String FIELD_NAME = from.field2XxYy(fromFieldName);
        Hashtable<String, String> params = new Hashtable<String, String>();
        params.put("bo_name", BO_NAME);
        params.put("target_name", TARGET_NAME);
        params.put("field_name", FIELD_NAME);
        buf.append(this.helper_.getParsedContent(infile, params));
        return buf.toString();
    }

    private String _getRelationMethods2(RelationDefinition re, UserProperty property, BoNameFormatter to, BoNameFormatter from, BoNameFormatter parent) throws Exception {
        StringBuffer buf = new StringBuffer();
        String infile = "methods_relation2.txt";
        String fromFieldName = re.getFromFieldName();
        String PARENT_NAME = parent.getBoInterfaceClassName();
        String BO_NAME = from.getBoInterfaceClassName();
        String TARGET_NAME = to.getBoInterfaceClassName();
        String FIELD_NAME = from.field2XxYy(fromFieldName);
        Hashtable<String, String> params = new Hashtable<String, String>();
        params.put("bo_name", BO_NAME);
        params.put("target_name", TARGET_NAME);
        params.put("parent_name", PARENT_NAME);
        params.put("field_name", FIELD_NAME);
        buf.append(this.helper_.getParsedContent(infile, params));
        return buf.toString();
    }
}

