/*
 * Decompiled with CFR 0.152.
 */
package com.sap.mbs.util.bogenerator.builder.bo.interfaceclass;

import com.sap.mbs.util.bogenerator.UserProperty;
import com.sap.mbs.util.bogenerator.builder.BuildHelper;
import com.sap.mbs.util.bogenerator.builder.IClassBuilder;
import com.sap.mbs.util.bogenerator.builder.bo.AbstractBoClassBuilder;
import com.sap.mbs.util.bogenerator.formatter.BoNameFormatter;
import com.sap.mbs.util.bogenerator.meta.FieldDefinition;
import com.sap.mbs.util.bogenerator.meta.RelationDefinition;
import com.sap.mbs.util.bogenerator.meta.RowDefinition;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class BoInterfaceClassBuilder
extends AbstractBoClassBuilder
implements IClassBuilder {
    private BuildHelper helper_ = null;
    private BoNameFormatter formatter_ = null;

    public BoInterfaceClassBuilder(RowDefinition row, boolean isChild) throws Exception {
        super(row, isChild);
    }

    private void _init(UserProperty property) throws Exception {
        this.helper_ = new BuildHelper(this);
        this.helper_.mkJavaSrcDirs();
        this.formatter_ = new BoNameFormatter(property.getBoPattern(), property.getRowPattern(), property.getFieldPattern(), this.getBoName(), this.getRowName(), this.isChildRow());
    }

    public void createBoClasses(UserProperty property) throws Exception {
        Hashtable<String, String> params = null;
        this._init(property);
        String CLASS_NAME = this.formatter_.getBoInterfaceClassName();
        String AUTHOR = property.getAuthor();
        String CURRENT_DATE = property.getCurrentDate();
        String INTERFACE_PACKAGE_NAME = property.getInterfacePackageName();
        params = new Hashtable<String, String>();
        params.put("package_name", INTERFACE_PACKAGE_NAME);
        params.put("author", AUTHOR);
        params.put("current_date", CURRENT_DATE);
        params.put("class_name", CLASS_NAME);
        params.put("methods_block", this._getMethodBlock());
        String content = this.helper_.getParsedContent("template.txt", params);
        this.helper_.saveClass(INTERFACE_PACKAGE_NAME, CLASS_NAME, content);
    }

    String _getMethodBlock() throws Exception {
        String getInfile = "method_get.txt";
        String setInfile = "method_set.txt";
        StringBuffer buf = new StringBuffer();
        Vector list = this.getFieldElements();
        Enumeration e = list.elements();
        while (e.hasMoreElements()) {
            FieldDefinition field = (FieldDefinition)e.nextElement();
            String name = field.getFieldName();
            String type = field.getFieldType();
            String desc = field.getDescription();
            if (name.equals(this.formatter_.getSyncKey())) continue;
            String JAVA_TYPE = BoNameFormatter.getJavaType(type);
            String MEMBER_NAME = this.formatter_.field2xxYy(name);
            String DEFAULT_TYPE = BoNameFormatter.convertDefaultType(type);
            String FIELD_METHOD_NAME = this.formatter_.field2XxYy(name);
            String RELATION_DESC = "";
            if (field.hasRelation()) {
                RelationDefinition re = field.getRelationDefinition();
                RELATION_DESC = this.createRelationMessage(name, re);
            }
            Hashtable<String, String> params = new Hashtable<String, String>();
            params.put("field_type", JAVA_TYPE);
            params.put("field_name", name);
            params.put("field_name_for_method", FIELD_METHOD_NAME);
            params.put("field_description", "".equals(desc) ? "no description available" : desc);
            params.put("relation_description", RELATION_DESC);
            buf.append(this.helper_.getParsedContent(getInfile, params));
            if (this.isAllowToAddSetMethods() && (field.isModify() || field.isCreate())) {
                params.put("member_name", MEMBER_NAME);
                buf.append(this.helper_.getParsedContent(setInfile, params));
            }
            buf.append("\n");
        }
        return buf.toString();
    }
}

