/*
 * Decompiled with CFR 0.152.
 */
package com.sap.mbs.util.bogenerator.builder.bo.implclass;

import com.sap.mbs.util.bogenerator.UserProperty;
import com.sap.mbs.util.bogenerator.builder.BuildHelper;
import com.sap.mbs.util.bogenerator.builder.IClassBuilder;
import com.sap.mbs.util.bogenerator.builder.bo.AbstractBoClassBuilder;
import com.sap.mbs.util.bogenerator.formatter.BoNameFormatter;
import com.sap.mbs.util.bogenerator.meta.FieldDefinition;
import com.sap.mbs.util.bogenerator.meta.RelationDefinition;
import com.sap.mbs.util.bogenerator.meta.RowDefinition;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class BoImplClassBuilder
extends AbstractBoClassBuilder
implements IClassBuilder {
    private BuildHelper helper_ = null;
    private BoNameFormatter formatter_ = null;

    public BoImplClassBuilder(RowDefinition row, boolean isChild) throws Exception {
        super(row, isChild);
    }

    private void _init(UserProperty property) throws Exception {
        this.helper_ = new BuildHelper(this);
        this.helper_.mkJavaSrcDirs();
        this.formatter_ = new BoNameFormatter(property.getBoPattern(), property.getRowPattern(), property.getFieldPattern(), this.getBoName(), this.getRowName(), this.isChildRow());
    }

    public void createBoClasses(UserProperty property) throws Exception {
        Hashtable<String, String> params = null;
        this._init(property);
        String CLASS_NAME = this.formatter_.getBoImplClassName();
        String INTERFACE_CLASS_NAME = this.formatter_.getBoInterfaceClassName();
        String AUTHOR = property.getAuthor();
        String CURRENT_DATE = property.getCurrentDate();
        String IMPL_PACKAGE_NAME = property.getImplPackageName();
        String INTERFACE_PACKAGE_NAME = property.getInterfacePackageName();
        String PROPERTY_NAME = property.getPropertyFileName();
        String SYNCBO_NAME = this.getBoName();
        String ROW_NAME = this.getRowName();
        String WRITABLE_BO = "";
        if (this.isAllowToAddSetMethods()) {
            WRITABLE_BO = ", WritableBO";
        }
        params = new Hashtable<String, String>();
        params.put("package_name", IMPL_PACKAGE_NAME);
        params.put("class_name", CLASS_NAME);
        params.put("author", AUTHOR);
        params.put("current_date", CURRENT_DATE);
        params.put("interface_class_name", INTERFACE_CLASS_NAME);
        params.put("interface_package_name", INTERFACE_PACKAGE_NAME);
        params.put("impl_package_name", IMPL_PACKAGE_NAME);
        params.put("writable_bo", WRITABLE_BO);
        params.put("property_file_name", PROPERTY_NAME);
        params.put("syncbo_name", SYNCBO_NAME);
        params.put("row_name", ROW_NAME);
        params.put("member_block", this._getMemberBlock());
        params.put("methods_block", this._getGetSetMethodBlock());
        params.put("write_method_block", this._getWriteMethodBlock());
        params.put("toString_method_block", this._getToStringBufferMethodBlock());
        String content = this.helper_.getParsedContent("template.txt", params);
        this.helper_.saveClass(IMPL_PACKAGE_NAME, CLASS_NAME, content);
    }

    String _getMemberBlock() throws Exception {
        StringBuffer buf = new StringBuffer();
        String infile = "member.txt";
        Vector list = this.getFieldElements();
        Enumeration e = list.elements();
        while (e.hasMoreElements()) {
            FieldDefinition field = (FieldDefinition)e.nextElement();
            String name = field.getFieldName();
            String type = field.getFieldType();
            if (name.equals(this.formatter_.getSyncKey())) continue;
            String JAVA_TYPE = BoNameFormatter.getJavaType(type);
            String MEMBER_NAME = this.formatter_.field2xxYy(name);
            String FIELD_DESC_NAME = this.formatter_.field2FIELD_DESC_XX_YY(name);
            String RELATION_DESC = "";
            if (field.hasRelation()) {
                RelationDefinition re = field.getRelationDefinition();
                RELATION_DESC = this.createRelationMessage(name, re);
            }
            Hashtable<String, String> params = new Hashtable<String, String>();
            params.put("return_type", JAVA_TYPE);
            params.put("member_name", MEMBER_NAME);
            params.put("field_descriptor_name", FIELD_DESC_NAME);
            params.put("field_name", name);
            params.put("relation_desc", RELATION_DESC);
            buf.append(this.helper_.getParsedContent(infile, params) + "\n");
        }
        return buf.toString();
    }

    String _getGetSetMethodBlock() throws Exception {
        StringBuffer buf = new StringBuffer();
        String getInfile = "method_get.txt";
        String setInfile = "method_set.txt";
        Vector list = this.getFieldElements();
        Enumeration e = list.elements();
        while (e.hasMoreElements()) {
            FieldDefinition field = (FieldDefinition)e.nextElement();
            String name = field.getFieldName();
            String type = field.getFieldType();
            String desc = field.getDescription();
            if (name.equals(this.formatter_.getSyncKey())) continue;
            String JAVA_TYPE = BoNameFormatter.getJavaType(type);
            String MEMBER_NAME = this.formatter_.field2xxYy(name);
            String DEFAULT_TYPE = BoNameFormatter.convertDefaultType(type);
            String FIELD_DESC_NAME = this.formatter_.field2FIELD_DESC_XX_YY(name);
            String FIELD_METHOD_NAME = this.formatter_.field2XxYy(name);
            Hashtable<String, String> params = new Hashtable<String, String>();
            params.put("field_type", JAVA_TYPE);
            params.put("member_name", MEMBER_NAME);
            params.put("field_name", name);
            params.put("field_name_for_method", FIELD_METHOD_NAME);
            params.put("field_descriptor_name", FIELD_DESC_NAME);
            params.put("default_type", DEFAULT_TYPE);
            params.put("field_description", "".equals(desc) ? "no description available" : desc);
            buf.append(this.helper_.getParsedContent(getInfile, params));
            if (this.isAllowToAddSetMethods() && (field.isModify() || field.isCreate())) {
                buf.append(this.helper_.getParsedContent(setInfile, params));
            }
            buf.append("\n");
        }
        return buf.toString();
    }

    String _getWriteMethodBlock() throws Exception {
        StringBuffer buf = new StringBuffer();
        Hashtable<String, String> params = null;
        String infile = "method_write.txt";
        String infile1 = "method_write1.txt";
        if (!this.isAllowToAddSetMethods()) {
            return "";
        }
        Vector list = this.getFieldElements();
        Enumeration e = list.elements();
        while (e.hasMoreElements()) {
            FieldDefinition field = (FieldDefinition)e.nextElement();
            String name = field.getFieldName();
            String type = field.getFieldType();
            if (!field.isModify() && !field.isCreate() || name.equals(this.formatter_.getSyncKey())) continue;
            String MEMBER_NAME = this.formatter_.field2xxYy(name);
            String DEFAULT_TYPE = BoNameFormatter.convertDefaultType(type);
            String FIELD_DESC_NAME = this.formatter_.field2FIELD_DESC_XX_YY(name);
            params = new Hashtable();
            params.put("member_name", MEMBER_NAME);
            params.put("field_descriptor_name", FIELD_DESC_NAME);
            params.put("default_type", DEFAULT_TYPE);
            buf.append(this.helper_.getParsedContent(infile1, params));
            buf.append("\n");
        }
        params = new Hashtable<String, String>();
        params.put("set_block", buf.toString());
        buf = new StringBuffer();
        buf.append(this.helper_.getParsedContent(infile, params));
        return buf.toString();
    }

    String _getToStringBufferMethodBlock() throws Exception {
        StringBuffer buf = new StringBuffer();
        Hashtable<String, String> params = null;
        String infile = "method_tobuffer.txt";
        String infile1 = "method_tobuffer1.txt";
        Vector list = this.getFieldElements();
        Enumeration e = list.elements();
        while (e.hasMoreElements()) {
            FieldDefinition field = (FieldDefinition)e.nextElement();
            String name = field.getFieldName();
            String type = field.getFieldType();
            String desc = field.getDescription();
            String JAVA_TYPE = BoNameFormatter.getJavaType(type);
            String MEMBER_NAME = this.formatter_.field2xxYy(name);
            String FIELD_METHOD_NAME = this.formatter_.field2XxYy(name);
            if (name.equals(this.formatter_.getSyncKey())) {
                FIELD_METHOD_NAME = this.formatter_.getKey();
            }
            params = new Hashtable();
            params.put("field_type", JAVA_TYPE);
            params.put("member_name", MEMBER_NAME);
            params.put("field_name_for_method", FIELD_METHOD_NAME);
            buf.append(this.helper_.getParsedContent(infile1, params));
            buf.append("\n");
        }
        params = new Hashtable<String, String>();
        params.put("append_block", buf.toString());
        buf = new StringBuffer();
        buf.append(this.helper_.getParsedContent(infile, params));
        return buf.toString();
    }
}

