/*
 * Decompiled with CFR 0.152.
 */
package com.sap.mbs.util.bogenerator.builder;

import com.sap.mbs.util.bogenerator.UserProperty;
import com.sap.mbs.util.bogenerator.builder.IClassBuilder;
import com.sap.mbs.util.bogenerator.template.TemplateParser;
import com.sap.mbs.util.bogenerator.util.FileUtils;
import com.sap.mbs.util.bogenerator.util.FileWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.Hashtable;
import java.util.StringTokenizer;

public class BuildHelper {
    public static String SEPARATOR = File.separator;
    private IClassBuilder builder_ = null;
    private String APPLI_ROOT_DIR = null;
    private static String SRC_DIR = "java";
    private static String WEB_DIR = "web";
    private static String START = "start";
    private static String WEBINF_DIR = "WEB-INF";

    public BuildHelper(IClassBuilder builder) {
        this.builder_ = builder;
        this._init();
    }

    private void _init() {
        try {
            UserProperty property = UserProperty.getInstance();
            this.APPLI_ROOT_DIR = property.getApplicationRootDir();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void saveBuildXMLFile(String content) throws Exception {
        FileWriter.writeFile(this.APPLI_ROOT_DIR + SEPARATOR + "build.xml", content);
    }

    public void saveHtmlFile(String htmlName, String content) throws Exception {
        FileWriter.writeFile(this.APPLI_ROOT_DIR + SEPARATOR + WEB_DIR + SEPARATOR + htmlName + ".html", content);
    }

    public void saveJSPFile(String jspName, String content) throws Exception {
        FileWriter.writeFile(this.APPLI_ROOT_DIR + SEPARATOR + WEB_DIR + SEPARATOR + START + SEPARATOR + jspName + ".jsp", content);
    }

    public void saveWebXMLFile(String content) throws Exception {
        FileWriter.writeFile(this.APPLI_ROOT_DIR + SEPARATOR + WEB_DIR + SEPARATOR + WEBINF_DIR + SEPARATOR + "web.xml", content);
    }

    public void savePropertyFile(String packageName, String className, String content) throws Exception {
        FileWriter.writeFile(this._convertPackageName2DirPath(packageName) + SEPARATOR + className + ".properties", content);
    }

    public void saveClass(String packageName, String className, String content) throws Exception {
        FileWriter.writeFile(this._convertPackageName2DirPath(packageName) + SEPARATOR + className + ".java", content);
    }

    public void saveJava(String packageName, String className, String content) throws Exception {
        String dir = this._convertPackageName2DirPath(packageName);
        this.mkdirs(dir);
        FileWriter.writeFile(dir + SEPARATOR + className + ".java", content);
    }

    public void saveFile(String dir, String fileName, String content) throws Exception {
        dir = this.APPLI_ROOT_DIR + SEPARATOR + dir;
        this.mkdirs(dir);
        FileWriter.writeFile(dir + SEPARATOR + fileName, content);
    }

    public String getParsedContent(String infile, Hashtable params) throws Exception {
        TemplateParser template = null;
        StringBuffer buf = new StringBuffer();
        Class<?> clzz = this.builder_.getClass();
        template = new TemplateParser(clzz.getResourceAsStream(infile));
        template.setParameter(params);
        buf.append(template.parse());
        return buf.toString();
    }

    public void copyFile(String infile, String dir, String outfile) throws Exception {
        Object template = null;
        StringBuffer buf = new StringBuffer();
        dir = this.APPLI_ROOT_DIR + SEPARATOR + dir;
        Class<?> clzz = this.builder_.getClass();
        InputStream in = clzz.getResourceAsStream(infile);
        FileUtils.copy(in, dir + SEPARATOR + outfile);
    }

    public String getParsedContent(FileInputStream fis) throws Exception {
        TemplateParser template = null;
        StringBuffer buf = new StringBuffer();
        template = new TemplateParser(fis);
        template.setParameter(new Hashtable());
        buf.append(template.parse());
        return buf.toString();
    }

    private void mkdirs(String path) throws Exception {
        FileUtils.mkdirs(path);
    }

    public void mkdir(String path) throws Exception {
        FileUtils.mkdir(path);
    }

    public void mkJavaSrcDirs() throws Exception {
        String dir = this.APPLI_ROOT_DIR + SEPARATOR + SRC_DIR;
        this.mkdirs(dir);
    }

    public void mkWebApplicationDirs() throws Exception {
        String dir = this.APPLI_ROOT_DIR;
        this.mkdirs(dir);
        this.mkdir(this.APPLI_ROOT_DIR + SEPARATOR + SRC_DIR);
        this.mkdir(this.APPLI_ROOT_DIR + SEPARATOR + WEB_DIR);
        this.mkdir(this.APPLI_ROOT_DIR + SEPARATOR + WEB_DIR + SEPARATOR + START);
        this.mkdir(this.APPLI_ROOT_DIR + SEPARATOR + WEB_DIR + SEPARATOR + WEBINF_DIR);
    }

    private String _convertPackageName2DirPath(String packageName) throws Exception {
        String path = this.APPLI_ROOT_DIR + SEPARATOR + SRC_DIR;
        String packageDir = "";
        StringTokenizer token = new StringTokenizer(packageName, ".");
        while (token.hasMoreElements()) {
            String str = token.nextToken();
            path = path.concat(SEPARATOR + str);
            this.mkdir(path);
        }
        return path;
    }
}

