/*
 * Decompiled with CFR 0.152.
 */
package com.sap.mbs.util.bogenerator;

import com.sap.mbs.util.bogenerator.meta.FieldDefinition;
import com.sap.mbs.util.bogenerator.meta.RelationDefinition;
import com.sap.mbs.util.bogenerator.meta.RowDefinition;
import com.sap.mbs.util.bogenerator.meta.SyncBoDefinition;
import com.sap.mbs.util.bogenerator.util.XMLParser;
import com.sap.mbs.util.bogenerator.util.XMLUtil;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.w3c.dom.Element;

public class XmlToObjTransformer
extends XMLParser {
    static final String ROOT = "SyncBO";

    public Hashtable createMetaDataFromFile(InputStream xmlAsByteArray) throws Exception {
        Hashtable syncBoDefinitionList = new Hashtable();
        Element root = XMLUtil.getRootElement(xmlAsByteArray);
        Element[] syncBOs = XMLParser.getChildElements(root, ROOT);
        SyncBoHandler handler = new SyncBoHandler();
        int i = 0;
        while (i < syncBOs.length) {
            Element syncBO = syncBOs[i];
            SyncBoDefinition bo = (SyncBoDefinition)handler.execute(syncBO);
            String syncName = bo.getSyncBoName();
            syncBoDefinitionList.put(syncName, bo);
            ++i;
        }
        syncBoDefinitionList = this._buildRelationDefinition(syncBoDefinitionList);
        return syncBoDefinitionList;
    }

    private FieldDefinition _getFieldDefinition(Hashtable list, RelationDefinition re) throws Exception {
        FieldDefinition field = null;
        String boName = re.getBoName();
        String rowName = re.getRowName();
        String fieldName = re.getFieldName();
        SyncBoDefinition bo = (SyncBoDefinition)list.get(boName);
        RowDefinition row = bo.getRowDefinition(rowName);
        field = row.getFieldDefinition(fieldName);
        return field;
    }

    private Hashtable _buildRelationDefinition(Hashtable list) throws Exception {
        Enumeration e = list.elements();
        while (e.hasMoreElements()) {
            SyncBoDefinition bo = (SyncBoDefinition)e.nextElement();
            RowDefinition row = bo.getTopRowDefinition();
            Vector fields = row.getFieldDefinitionList();
            Enumeration e1 = fields.elements();
            while (e1.hasMoreElements()) {
                FieldDefinition field = (FieldDefinition)e1.nextElement();
                if (!field.hasRelation()) continue;
                RelationDefinition re = field.getRelationDefinition();
                re.setFromFieldDefinition(field);
                field = this._getFieldDefinition(list, re);
                re.setToFieldDefinition(field);
            }
            Hashtable rows = bo.getRowDefinitionList();
            Enumeration e2 = rows.elements();
            while (e2.hasMoreElements()) {
                row = (RowDefinition)e2.nextElement();
                fields = row.getFieldDefinitionList();
                Enumeration e3 = fields.elements();
                while (e3.hasMoreElements()) {
                    FieldDefinition field = (FieldDefinition)e3.nextElement();
                    if (!field.hasRelation()) continue;
                    RelationDefinition re = field.getRelationDefinition();
                    re.setFromFieldDefinition(field);
                    field = this._getFieldDefinition(list, re);
                    re.setToFieldDefinition(field);
                }
            }
        }
        return list;
    }

    private class RelationHandler
    extends Handler {
        public final String ROOT_NODE = "Relation";
        public final String ROOT_ATTR1 = "type";
        public final String CHILD_NODE1 = "BaseSyncBO";
        public final String CHILD_NODE2 = "BaseStructure";
        public final String CHILD_NODE3 = "BaseField";

        public RelationHandler() {
            this.setRoot("Relation");
        }

        public Object execute(Element root) throws Exception {
            RelationDefinition relation = null;
            this.validateRoot(root);
            String dependency = XMLParser.getAttrAsString(root, "type");
            String syncboName = XMLParser.getChildAsString(root, "BaseSyncBO");
            String rowName = XMLParser.getChildAsString(root, "BaseStructure");
            String fieldName = XMLParser.getChildAsString(root, "BaseField");
            relation = new RelationDefinition(syncboName, rowName, fieldName, dependency);
            return relation;
        }
    }

    private class FieldHandler
    extends Handler {
        public final String ROOT_NODE = "Field";
        public final String ROOT_ATTR1 = "name";
        public final String ROOT_ATTR2 = "type";
        public final String ROOT_ATTR3 = "description";
        public final String ROOT_ATTR4 = "length";
        public final String ROOT_ATTR5 = "decimalLength";
        public final String ROOT_ATTR6 = "signed";
        public final String ROOT_ATTR7 = "isKey";
        public final String ROOT_ATTR8 = "isIndex";
        public final String ROOT_ATTR9 = "isMultiLangText";
        public final String CHILD_NODE1 = "Relation";
        public final String CHILD_NODE2 = "Input";
        public final String CHILD_NODE2_ATTR1 = "type";

        public FieldHandler() {
            this.setRoot("Field");
            this.addHandler(new RelationHandler());
        }

        public Object execute(Element root) throws Exception {
            FieldDefinition field = null;
            this.validateRoot(root);
            String name = XMLParser.getAttrAsString(root, "name");
            String type = XMLParser.getAttrAsString(root, "type");
            String description = XMLParser.getAttrAsString(root, "description");
            int length = XMLParser.getAttrAsInt(root, "length");
            int decimalLength = XMLParser.getAttrAsInt(root, "decimalLength");
            boolean signed = XMLParser.getAttrAsBoolean(root, "signed");
            boolean isKey = XMLParser.getAttrAsBoolean(root, "isKey");
            boolean isIndex = XMLParser.getAttrAsBoolean(root, "isIndex");
            boolean isMultiLangText = XMLParser.getAttrAsBoolean(root, "isMultiLangText");
            boolean isCreate = true;
            boolean isModify = true;
            Element[] inputList = XMLParser.getChildElements(root, "Input");
            int i = 0;
            while (i < inputList.length) {
                String inputType = XMLParser.getAttrAsString(inputList[i], "type");
                boolean inputValue = XMLParser.getValueAsBoolean(inputList[i]);
                if ("modify".equals(inputType) && !inputValue) {
                    isModify = false;
                }
                if ("create".equals(inputType) && !inputValue) {
                    isCreate = false;
                }
                ++i;
            }
            field = new FieldDefinition(name, type, description, length, decimalLength, signed, isKey, isIndex, isMultiLangText, isCreate, isModify);
            Handler creator = this.nextHandler();
            Element[] relationList = XMLParser.getChildElements(root, "Relation");
            int i2 = 0;
            while (i2 < relationList.length) {
                RelationDefinition re = (RelationDefinition)creator.execute(relationList[i2]);
                field.setRelation(re);
                ++i2;
            }
            return field;
        }
    }

    private class ChildStructureHandler
    extends Handler {
        public final String ROOT_NODE = "ChildStructure";
        public final String ROOT_ATTR1 = "name";
        public final String ROOT_ATTR2 = "mandatory";
        public final String CHILD_NODE1 = "Field";

        public ChildStructureHandler() {
            this.setRoot("ChildStructure");
            this.addHandler(new FieldHandler());
        }

        public Object execute(Element root) throws Exception {
            RowDefinition child = null;
            this.validateRoot(root);
            Handler handler = this.nextHandler();
            String name = XMLParser.getAttrAsString(root, "name");
            boolean mandatory = false;
            try {
                mandatory = XMLParser.getAttrAsBoolean(root, "mandatory");
            }
            catch (Exception e) {
                // empty catch block
            }
            child = new RowDefinition(name, mandatory);
            Element[] fields = XMLParser.getChildElements(root, "Field");
            int i = 0;
            while (i < fields.length) {
                FieldDefinition field = (FieldDefinition)handler.execute(fields[i]);
                field.setRowDefinition(child);
                child.addFieldDefinition(field);
                ++i;
            }
            return child;
        }
    }

    private class TopStructureHandler
    extends Handler {
        public final String ROOT_NODE = "TopStructure";
        public final String ROOT_ATTR1 = "name";
        public final String ROOT_ATTR2 = "mandatory";
        public final String CHILD_NODE1 = "Field";
        public final String CHILD_NODE2 = "ChildStructure";

        public TopStructureHandler() {
            this.setRoot("TopStructure");
            this.addHandler(new FieldHandler());
        }

        public Object execute(Element root) throws Exception {
            RowDefinition top = null;
            this.validateRoot(root);
            Handler handler = this.nextHandler();
            String name = XMLParser.getAttrAsString(root, "name");
            boolean isMandantory = false;
            try {
                isMandantory = XMLParser.getAttrAsBoolean(root, "mandatory");
            }
            catch (Exception e) {
                // empty catch block
            }
            boolean thisIsTopRow = true;
            top = new RowDefinition(name, isMandantory, thisIsTopRow);
            Element[] fields = XMLParser.getChildElements(root, "Field");
            int i = 0;
            while (i < fields.length) {
                FieldDefinition field = (FieldDefinition)handler.execute(fields[i]);
                field.setRowDefinition(top);
                top.addFieldDefinition(field);
                ++i;
            }
            return top;
        }
    }

    private class SyncBoHandler
    extends Handler {
        public final String ROOT_NODE = "SyncBO";
        public final String ROOT_ATTR1 = "id";
        public final String ROOT_ATTR2 = "version";
        public final String ROOT_ATTR3 = "type";
        public final String ROOT_ATTR4 = "allowCreate";
        public final String ROOT_ATTR5 = "allowModify";
        public final String ROOT_ATTR6 = "allowDelete";
        public final String ROOT_ATTR7 = "reqDirectSync";
        public final String ROOT_ATTR8 = "multiLangSupport";
        public final String CHILD_NODE1 = "TopStructure";
        public final String GRANDCHILD_NODE1 = "ChildStructure";

        public SyncBoHandler() {
            this.setRoot(XmlToObjTransformer.ROOT);
            this.addHandler(new TopStructureHandler());
            this.addHandler(new ChildStructureHandler());
        }

        public Object execute(Element root) throws Exception {
            SyncBoDefinition syncbo = null;
            this.validateRoot(root);
            String id = XMLParser.getAttrAsString(root, "id");
            int version = -1;
            try {
                version = XMLParser.getAttrAsInt(root, "version");
            }
            catch (Exception e) {
                // empty catch block
            }
            String type = XMLParser.getAttrAsString(root, "type");
            boolean allowCreate = XMLParser.getAttrAsBoolean(root, "allowCreate");
            boolean allowModify = XMLParser.getAttrAsBoolean(root, "allowModify");
            boolean allowDelete = XMLParser.getAttrAsBoolean(root, "allowDelete");
            boolean reqDirectSync = XMLParser.getAttrAsBoolean(root, "reqDirectSync");
            boolean multiLangSupport = XMLParser.getAttrAsBoolean(root, "multiLangSupport");
            syncbo = new SyncBoDefinition(id, version, type, allowCreate, allowModify, allowDelete, reqDirectSync, multiLangSupport);
            Handler handler = this.nextHandler();
            Element topStructure = XMLParser.getChildElement(root, "TopStructure");
            RowDefinition row = (RowDefinition)handler.execute(topStructure);
            row.setSyncBoDefinition(syncbo);
            syncbo.setTopRowDefinition(row);
            handler = this.nextHandler();
            Element[] childStructures = XMLParser.getChildElements(topStructure, "ChildStructure");
            int j = 0;
            while (j < childStructures.length) {
                row = (RowDefinition)handler.execute(childStructures[j]);
                row.setSyncBoDefinition(syncbo);
                syncbo.addRowDefinition(row);
                ++j;
            }
            return syncbo;
        }
    }

    abstract class Handler {
        private String rootName_ = null;
        private Vector next_ = new Vector();

        Handler() {
        }

        public void setRoot(String rootName) {
            this.rootName_ = rootName;
        }

        public void validateRoot(Element root) throws Exception {
            if (root == null) {
                throw new Exception("root is null");
            }
            String name = root.getTagName();
            if (!this.rootName_.equals(name)) {
                String msg = "Invalid Root Name:Expected:" + this.rootName_ + "Given:" + name;
                throw new Exception(msg);
            }
        }

        public abstract Object execute(Element var1) throws Exception;

        public void addHandler(Handler next) {
            if (this.next_.isEmpty()) {
                this.next_.insertElementAt(next, 0);
                return;
            }
            this.next_.insertElementAt(next, this.next_.size());
        }

        public Handler nextHandler() {
            if (this.next_.isEmpty()) {
                return null;
            }
            Handler handler = (Handler)this.next_.elementAt(0);
            this.next_.removeElementAt(0);
            this.addHandler(handler);
            return handler;
        }
    }
}

