/*
 * Decompiled with CFR 0.152.
 */
package com.sap.mbs.util.bogenerator;

import java.io.File;
import java.text.DateFormat;
import java.util.Calendar;
import java.util.Properties;

public class UserProperty
extends Properties {
    public static String BO_PATTERN = "syncbo_id_pattern";
    public static String ROW_PATTERN = "row_id_pattern";
    public static String FIELD_PATTERN = "field_id_pattern";
    public static String PROPERTY_FILE = "property_file_name";
    public static String AUTHOR = "author";
    public static String IMPL_PACKAGE = "impl_package_name";
    public static String INTERFACE_PACKAGE = "interface_package_name";
    public static String SAVE_BASE_DIR = "save_base_dir";
    public static String SERVLET_PACKAGE = "servlet_package_name";
    public static String WEBAPPLI_NAME = "webapplication_name";
    public static String WEBAPPLI_BASE_PACKAGE = "webapplication_base_package";
    public static String VAR_BO_PATTERN = "XX_YY";
    public static String VAR_ROW_PATTERN = "XX";
    public static String VAR_FIELD_PATTERN = "XX_YY";
    public static String VAR_PROPERTY_FILE = "syncbonamelist";
    private static UserProperty property_ = null;

    private UserProperty(String author, String saveBaseDir, String webAppliName, String webAppliBasePackName, String interfacePackName, String implPackName) {
        this.setProperty(AUTHOR, author);
        this.setProperty(SAVE_BASE_DIR, saveBaseDir);
        this.setProperty(WEBAPPLI_NAME, webAppliName);
        this.setProperty(WEBAPPLI_BASE_PACKAGE, webAppliBasePackName);
        this.setProperty(INTERFACE_PACKAGE, interfacePackName);
        this.setProperty(IMPL_PACKAGE, implPackName);
        this.setProperty(BO_PATTERN, VAR_BO_PATTERN);
        this.setProperty(ROW_PATTERN, VAR_ROW_PATTERN);
        this.setProperty(FIELD_PATTERN, VAR_FIELD_PATTERN);
        this.setProperty(PROPERTY_FILE, VAR_PROPERTY_FILE);
    }

    public static void buildInstance(String author, String saveBaseDir, String webAppliName, String webAppliBasePackName, String interfacePackName, String implPackName) throws Exception {
        property_ = new UserProperty(author, saveBaseDir, webAppliName, webAppliBasePackName, interfacePackName, implPackName);
    }

    public static UserProperty getInstance() {
        return property_;
    }

    public String getSaveBaseDir() throws Exception {
        String name = null;
        try {
            name = this.getProperty(SAVE_BASE_DIR);
            if (name == null || "".equals(name)) {
                return "." + File.separator;
            }
        }
        catch (Exception e) {
            throw new Exception("could not find save base directory");
        }
        return name;
    }

    public String getApplicationRootDir() throws Exception {
        String name = null;
        name = this.getSaveBaseDir() + File.separator + this.getWebApplicationName();
        return name;
    }

    public String getWebApplicationName() throws Exception {
        String name = null;
        try {
            name = this.getProperty(WEBAPPLI_NAME);
        }
        catch (Exception e) {
            throw new Exception("could not find web appli name");
        }
        return name;
    }

    public String getWebApplicationBasePackageName() throws Exception {
        String name = null;
        try {
            name = this.getProperty(WEBAPPLI_BASE_PACKAGE);
        }
        catch (Exception e) {
            throw new Exception("could not find web appli base package name");
        }
        return name;
    }

    public String getServletPackageName() throws Exception {
        String name = null;
        try {
            name = this.getProperty(SERVLET_PACKAGE);
        }
        catch (Exception e) {
            throw new Exception("could not find servlet package name");
        }
        return name;
    }

    public String getPropertyFileName() throws Exception {
        String name = null;
        try {
            name = this.getProperty(PROPERTY_FILE);
        }
        catch (Exception e) {
            throw new Exception("could not find property file name");
        }
        return name;
    }

    public String getImplPackageName() throws Exception {
        String name = null;
        try {
            name = this.getProperty(IMPL_PACKAGE);
        }
        catch (Exception e) {
            throw new Exception("could not find impl package name");
        }
        return name;
    }

    public String getInterfacePackageName() throws Exception {
        String name = null;
        try {
            name = this.getProperty(INTERFACE_PACKAGE);
        }
        catch (Exception e) {
            throw new Exception("could not find interface package name");
        }
        return name;
    }

    public String getBoPattern() {
        return this.getProperty(BO_PATTERN);
    }

    public String getRowPattern() {
        return this.getProperty(ROW_PATTERN);
    }

    public String getFieldPattern() {
        return this.getProperty(FIELD_PATTERN);
    }

    public String getAuthor() {
        return this.getProperty(AUTHOR);
    }

    public String getCurrentDate() {
        String current = "";
        try {
            current = DateFormat.getDateInstance().format(Calendar.getInstance().getTime());
        }
        catch (Exception exception) {
            // empty catch block
        }
        return current;
    }
}

