/*
 * Decompiled with CFR 0.152.
 */
package com.sap.mbs.util.bogenerator;

import com.sap.mbs.util.bogenerator.UserProperty;
import com.sap.mbs.util.bogenerator.builder.sample.api.ItemList;
import com.sap.mbs.util.bogenerator.builder.sample.api.Top;
import com.sap.mbs.util.bogenerator.builder.sample.api.TopItemsList;
import com.sap.mbs.util.bogenerator.builder.sample.common.CommonController;
import com.sap.mbs.util.bogenerator.builder.sample.detail.DetailController;
import com.sap.mbs.util.bogenerator.builder.sample.etc.EtcController;
import com.sap.mbs.util.bogenerator.builder.sample.list.ListController;
import com.sap.mbs.util.bogenerator.builder.sample.menu.MenuController;
import com.sap.mbs.util.bogenerator.formatter.SampleNameFormatter;
import com.sap.mbs.util.bogenerator.meta.SyncBoDefinition;
import com.sap.mbs.util.bogenerator.util.FileReader;
import com.sap.mbs.util.bogenerator.util.FileWriter;
import java.io.File;
import java.util.Enumeration;
import java.util.Hashtable;

public class SampleBuildController {
    private UserProperty property_ = UserProperty.getInstance();
    private static final String PREFIX_ID = "id=\"";
    private static final String SUFFIX_ID = "\"";

    public void saveMetaXml(File file) throws Exception {
        String content = FileReader.readFile(file);
        content = this.replaceMeRepApplicationID(content);
        String name = SampleNameFormatter.getMetaXmlName();
        String dir = SampleNameFormatter.getMetaXmlDir();
        FileWriter.writeFile(dir + File.separator + name, content);
    }

    private String replaceMeRepApplicationID(String content) throws Exception {
        StringBuffer buf = null;
        String appName = this.property_.getWebApplicationName();
        int start = content.indexOf(PREFIX_ID);
        int end = content.indexOf(SUFFIX_ID, start + PREFIX_ID.length()) + 1;
        String replaceStr = PREFIX_ID + appName + SUFFIX_ID;
        buf = new StringBuffer(content);
        buf = buf.replace(start, end, replaceStr);
        return buf.toString();
    }

    public void execute(Hashtable params) throws Exception {
        TopItemsList bos = new TopItemsList();
        Enumeration e = params.elements();
        while (e.hasMoreElements()) {
            SyncBoDefinition bo = (SyncBoDefinition)e.nextElement();
            Top top = Top.toTop(bo);
            ItemList items = ItemList.toItemList(bo);
            DetailController detail = new DetailController(top, items);
            detail.execute();
            ListController list = new ListController(top, items);
            list.execute();
            CommonController common = new CommonController(top, items);
            common.execute();
            bos.add(top, items);
        }
        MenuController menu = new MenuController(bos);
        menu.execute();
        EtcController etc = new EtcController();
        etc.execute();
    }
}

