/*
 * Decompiled with CFR 0.152.
 */
package com.sap.caf.rt.ui.cool.utils;

import com.sap.caf.rt.ui.cool.utils.CoolConnectionPropertiesException;
import com.sap.tc.webdynpro.services.sal.config.api.IWDConfiguration;
import com.sap.tc.webdynpro.services.sal.config.api.WDConfiguration;
import com.sap.tc.webdynpro.services.sal.config.api.WDConfigurationNotFoundException;
import com.sap.tc.webdynpro.services.sal.config.api.WDInvalidConfigParameterException;
import com.sap.tc.webdynpro.services.sal.deployment.api.IWDDeployableObject;

public class CoolConnectionProperties {
    public static final String PROPNAME_COOL_SERVER_HOST = "cool.server.host";
    public static final String PROPNAME_COOL_SERVER_SYSNUMBER = "cool.server.sysnumber";
    public static final String PROPNAME_COOL_CLIENT = "cool.client";
    public static final String PROPNAME_COOL_URL = "cool.URL";
    public static final String PROPNAME_COOL_USER_NAME = "cool.user.name";
    public static final String PROPNAME_COOL_USER_PASSWORD = "cool.user.password";
    public static final String PROPNAME_COOL_LOCALE_STR = "cool.locale.str";
    public String coolHost = "";
    public String coolSysNumber = "";
    public String coolClient = "";
    public String coolURL = "";
    public String coolUserName = "";
    public String coolUserPassword = "";
    public String coolLocaleStr = "";

    public String getCoolHost() {
        return this.coolHost;
    }

    public String getCoolSysNumber() {
        return this.coolSysNumber;
    }

    public String getCoolClient() {
        return this.coolClient;
    }

    public String getCoolURL() {
        return this.coolURL;
    }

    public String getCoolUserName() {
        return this.coolUserName;
    }

    public String getCoolUserPassword() {
        return this.coolUserPassword;
    }

    public String getCoolLocaleStr() {
        return this.coolLocaleStr;
    }

    public static CoolConnectionProperties getCoolConnectionProperties(String deployableObjectName) throws CoolConnectionPropertiesException {
        CoolConnectionProperties cp = new CoolConnectionProperties();
        try {
            IWDConfiguration config = WDConfiguration.getConfiguration((String)deployableObjectName);
            cp.coolHost = config.getStringEntry(PROPNAME_COOL_SERVER_HOST);
            cp.coolSysNumber = config.getStringEntry(PROPNAME_COOL_SERVER_SYSNUMBER);
            cp.coolClient = config.getStringEntry(PROPNAME_COOL_CLIENT);
            cp.coolURL = config.getStringEntry(PROPNAME_COOL_URL);
            cp.coolUserName = config.getStringEntry(PROPNAME_COOL_USER_NAME);
            cp.coolUserPassword = config.getStringEntry(PROPNAME_COOL_USER_PASSWORD);
            cp.coolLocaleStr = config.getStringEntry(PROPNAME_COOL_LOCALE_STR);
        }
        catch (WDInvalidConfigParameterException e) {
            String errorMess = "Invalid property name for one of the Cool connection parameters specified.";
            throw new CoolConnectionPropertiesException(errorMess);
        }
        catch (WDConfigurationNotFoundException e) {
            String errorMess = "Configuration not found for specified deployable object name: \"" + deployableObjectName + "\" on reading Cool connection properties";
            throw new CoolConnectionPropertiesException(errorMess);
        }
        return cp;
    }

    public static CoolConnectionProperties getCoolConnectionProperties(IWDDeployableObject deployableObject) throws CoolConnectionPropertiesException {
        CoolConnectionProperties cp = new CoolConnectionProperties();
        try {
            IWDConfiguration config = WDConfiguration.getConfiguration((IWDDeployableObject)deployableObject);
            cp.coolHost = config.getStringEntry(PROPNAME_COOL_SERVER_HOST);
            cp.coolSysNumber = config.getStringEntry(PROPNAME_COOL_SERVER_SYSNUMBER);
            cp.coolClient = config.getStringEntry(PROPNAME_COOL_CLIENT);
            cp.coolURL = config.getStringEntry(PROPNAME_COOL_URL);
            cp.coolUserName = config.getStringEntry(PROPNAME_COOL_USER_NAME);
            cp.coolUserPassword = config.getStringEntry(PROPNAME_COOL_USER_PASSWORD);
            cp.coolLocaleStr = config.getStringEntry(PROPNAME_COOL_LOCALE_STR);
        }
        catch (WDInvalidConfigParameterException e) {
            String errorMess = "Invalid property name for one of the Cool connection parameters specified.";
            throw new CoolConnectionPropertiesException(errorMess);
        }
        catch (WDConfigurationNotFoundException e) {
            String errorMess = "Configuration not found for specified deployable object named: \"" + deployableObject.getName() + "\" on reading Cool connection properties";
            throw new CoolConnectionPropertiesException(errorMess);
        }
        return cp;
    }
}

