/*
 * Decompiled with CFR 0.152.
 */
package com.sap.caf.rt.ui.cool.generic;

import com.sap.caf.rt.ui.cool.generic.AspectRow;
import com.sap.tc.col.client.generic.api.IKey;
import com.sap.tc.col.client.metadata.api.IKeyAspectDescriptor;
import com.sap.tc.col.client.metadata.api.IStructureDescriptor;
import com.sap.tc.logging.Location;
import java.util.Arrays;

public class Key
implements IKey,
Cloneable {
    private static final String APPLICATION = (class$com$sap$caf$rt$ui$cool$generic$Key == null ? (class$com$sap$caf$rt$ui$cool$generic$Key = Key.class$("com.sap.caf.rt.ui.cool.generic.Key")) : class$com$sap$caf$rt$ui$cool$generic$Key).getName();
    private static final String jARMRequest = "XAP:COOL:" + APPLICATION;
    private static final Location logger = Location.getLocation((String)APPLICATION);
    private transient IKeyAspectDescriptor keyDescriptor;
    private transient String[] keyFields;
    static /* synthetic */ Class class$com$sap$caf$rt$ui$cool$generic$Key;

    protected Key(IKeyAspectDescriptor keyDescriptor) {
        this(keyDescriptor, null);
    }

    protected Key(IKeyAspectDescriptor keyDescriptor, String[] keyFields) {
        if (keyDescriptor == null) {
            throw new IllegalArgumentException("keyDescriptor must not be null");
        }
        int lenKey = keyDescriptor.getStructure().size();
        if (keyFields != null && keyFields.length != lenKey) {
            throw new IllegalArgumentException("number of key fields doesn't match structure of key");
        }
        this.keyDescriptor = keyDescriptor;
        if (keyFields != null) {
            this.keyFields = new String[lenKey];
            System.arraycopy(keyFields, 0, this.keyFields, 0, lenKey);
        }
    }

    protected IKeyAspectDescriptor getKeyDescriptor() {
        return this.keyDescriptor;
    }

    public boolean isLocalKey() {
        boolean result;
        boolean bl = result = this.keyFields == null;
        if (!result) {
            for (int i = 0; i < this.keyFields.length; ++i) {
                if (this.keyFields[i] != null) continue;
                result = true;
                break;
            }
        }
        return result;
    }

    protected void takeFieldsFromRow(AspectRow row) {
        IStructureDescriptor structureDescriptor = this.keyDescriptor.getStructure();
        int noOfFields = structureDescriptor.size();
        this.keyFields = new String[noOfFields];
        for (int i = 0; i < noOfFields; ++i) {
            String fieldName = structureDescriptor.getFieldDescriptor(i).getName();
            String fieldValue = row.getAttributeAsString(fieldName);
            this.keyFields[i] = "".equals(fieldValue) ? null : fieldValue;
        }
    }

    protected String[] getKeyFields() {
        return this.isLocalKey() ? null : this.keyFields;
    }

    protected void setKeyFields(String[] values) {
        if (this.isLocalKey()) {
            this.keyFields = new String[this.getKeyDescriptor().getStructure().size()];
        }
        if (values.length != this.keyFields.length) {
            throw new RuntimeException("Structure of fields are incompatible with the structure of key.");
        }
        for (int i = 0; i < values.length; ++i) {
            this.keyFields[i] = values[i];
        }
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other instanceof Key) {
            if (this.isLocalKey()) {
                return this == other;
            }
            return Arrays.equals(this.keyFields, ((Key)other).getKeyFields());
        }
        return false;
    }

    public int hashCode() {
        return 0;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer("[");
        if (this.isLocalKey()) {
            buf.append("localKey@").append(Integer.toHexString(System.identityHashCode(this)));
        } else {
            for (int i = 0; i < this.keyFields.length; ++i) {
                buf.append(this.keyFields[i]);
                if (i >= this.keyFields.length - 1) continue;
                buf.append(";");
            }
        }
        buf.append("]");
        return buf.toString();
    }

    public Object clone() throws CloneNotSupportedException {
        Key key = (Key)super.clone();
        key.keyDescriptor = this.getKeyDescriptor();
        return key;
    }

    public String[] getFields() {
        return this.keyFields;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

