/*
 * Decompiled with CFR 0.152.
 */
package com.sap.caf.rt.ui.cool.generic;

import com.sap.caf.rt.bol.util.QueryFilter;
import com.sap.caf.rt.exception.ServiceException;
import com.sap.caf.rt.services.serviceaccess.ICAFServiceAccess;
import com.sap.caf.rt.services.serviceaccess.ICategoryFieldService;
import com.sap.caf.rt.srv.IDataContainerBean;
import com.sap.caf.rt.ui.cool.generic.CAFServiceManager;
import com.sap.caf.rt.util.CAFPublicLogger;
import com.sap.tc.logging.Location;
import com.sap.typeservices.IModifiableSimpleValueSet;
import com.sap.typeservices.ISimpleValueSet;
import com.sap.typeservices.ModifiableSimpleValueSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

public class CategoryFieldService
implements ICategoryFieldService {
    private static final String JARM_REQUEST = "";
    private static final String APPLICATION = (class$com$sap$caf$rt$ui$cool$generic$CategoryFieldService == null ? (class$com$sap$caf$rt$ui$cool$generic$CategoryFieldService = CategoryFieldService.class$("com.sap.caf.rt.ui.cool.generic.CategoryFieldService")) : class$com$sap$caf$rt$ui$cool$generic$CategoryFieldService).getName();
    private static final Location logger = Location.getLocation((String)APPLICATION);
    private static final String jARMRequest = "" + APPLICATION;
    private CAFServiceManager sManager;
    public static final String SERVICE_NAME = "sap.com/caf.tc/CategoryService";
    private static final String VALUESET_SERVICE_NAME = "sap.com/caf.tc/CategoryValueService";
    private static final String VALUESET_NAME = "CategoryValue";
    private static final String METHOD_FIND = "findById";
    private static final String PROP_CATEGORYVALUES = "values";
    private static final String PROP_CATEGORYVALUE_NAME = "name";
    private String m_categoryID;
    private Locale m_locale;
    private Map valuesCache = new HashMap();
    static /* synthetic */ Class class$com$sap$caf$rt$ui$cool$generic$CategoryFieldService;

    public CategoryFieldService(String categoryID, Locale locale) {
        this.m_locale = locale;
        this.m_categoryID = categoryID;
    }

    protected CategoryFieldService(Locale locale, CAFServiceManager sManager) {
        this.sManager = sManager;
        this.m_locale = locale;
        if (this.m_locale == null) {
            this.m_locale = Locale.getDefault();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ISimpleValueSet getValues(Locale locale) {
        IModifiableSimpleValueSet iModifiableSimpleValueSet = this.getModifiableSimpleValueSet();
        return iModifiableSimpleValueSet;
    }

    public ISimpleValueSet getValues() {
        return this.getValues(this.m_locale);
    }

    public boolean validate(String value) {
        return this.getValues().containsKey((Object)value);
    }

    public boolean validate(Object value) {
        return this.validate(value.toString());
    }

    public Locale getLocale() {
        return this.m_locale;
    }

    public synchronized IModifiableSimpleValueSet getModifiableSimpleValueSet() {
        IModifiableSimpleValueSet result = null;
        if (this.m_categoryID != null) {
            result = (IModifiableSimpleValueSet)this.valuesCache.get(this.m_categoryID);
        }
        if (result == null) {
            try {
                result = this.loadValues(this.m_locale);
                if (this.m_categoryID != null) {
                    this.valuesCache.put(this.m_categoryID, result);
                }
            }
            catch (ServiceException e) {
                logger.catching((Throwable)e);
                return new ModifiableSimpleValueSet(this.m_locale);
            }
        }
        return result;
    }

    private ModifiableSimpleValueSet loadValues(Locale loc) throws ServiceException {
        String method = jARMRequest + ":loadValues(Locale)";
        CAFPublicLogger.entering(null, (String)jARMRequest, (String)method, (Location)logger, (int)1);
        try {
            Collection readObjects;
            IDataContainerBean categoryData;
            Collection values;
            ModifiableSimpleValueSet set = new ModifiableSimpleValueSet(loc);
            set.setLocale(loc);
            ArrayList<QueryFilter> parameters = new ArrayList<QueryFilter>();
            parameters.add(QueryFilter.getQueryFilter((Object)this.m_categoryID));
            ICAFServiceAccess srvAccess = this.sManager.getServiceAccess();
            Collection categoryValues = srvAccess.findByDataObject(SERVICE_NAME, METHOD_FIND, parameters);
            Iterator valsIter = categoryValues.iterator();
            if (categoryValues != null && valsIter.hasNext() && (values = (Collection)(categoryData = (IDataContainerBean)valsIter.next()).getProperty(PROP_CATEGORYVALUES)) != null && (readObjects = srvAccess.readDataObject(VALUESET_SERVICE_NAME, VALUESET_NAME, values)) != null) {
                Iterator iter = readObjects.iterator();
                while (iter.hasNext()) {
                    IDataContainerBean valueData = (IDataContainerBean)iter.next();
                    String valueString = (String)valueData.getProperty(PROP_CATEGORYVALUE_NAME);
                    set.put((Object)valueString, valueString);
                }
            }
            set.sort(false, true, false);
            ModifiableSimpleValueSet modifiableSimpleValueSet = set;
            return modifiableSimpleValueSet;
        }
        catch (Exception e) {
            throw new ServiceException((Throwable)e);
        }
        finally {
            CAFPublicLogger.exiting(null, (String)jARMRequest, (String)method, (Location)logger, (int)1);
        }
    }

    public Set getEnumeration() {
        return this.getModifiableSimpleValueSet().entrySet();
    }

    public Map getEnumerationTexts() {
        return (ModifiableSimpleValueSet)this.getModifiableSimpleValueSet();
    }

    public void setLocale(Locale loc) {
        if (loc != null && !loc.equals(this.m_locale)) {
            this.m_locale = loc;
            try {
                if (this.m_categoryID != null) {
                    this.valuesCache.put(this.m_categoryID, this.loadValues(this.m_locale));
                }
            }
            catch (ServiceException e) {
                e.printStackTrace();
            }
        }
    }

    public void setCategoryId(String categoryId) {
        this.m_categoryID = categoryId;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

