/*
 * Decompiled with CFR 0.152.
 */
package com.sap.caf.rt.ui.cool.generic;

import com.sap.caf.rt.exception.CAFFindException;
import com.sap.caf.rt.exception.ServiceException;
import com.sap.caf.rt.srv.IDataContainerBean;
import com.sap.caf.rt.ui.cool.generic.AspectCache;
import com.sap.caf.rt.ui.cool.generic.AspectChanges;
import com.sap.caf.rt.ui.cool.generic.AspectRow;
import com.sap.caf.rt.ui.cool.generic.ColModelInfo;
import com.sap.caf.rt.ui.cool.generic.DependantAspectCache;
import com.sap.caf.rt.ui.cool.generic.EdoTable;
import com.sap.caf.rt.ui.cool.generic.ICacheRootObject;
import com.sap.caf.rt.ui.cool.generic.IEdoTableEx;
import com.sap.caf.rt.ui.cool.generic.Key;
import com.sap.caf.rt.ui.cool.generic.KeyList;
import com.sap.caf.rt.ui.cool.generic.MessageFactory;
import com.sap.caf.rt.ui.cool.generic.MessageList;
import com.sap.caf.rt.ui.cool.generic.Relation;
import com.sap.caf.rt.ui.cool.generic.ServiceFacade;
import com.sap.caf.rt.ui.cool.generic.ServiceModule;
import com.sap.caf.rt.util.CAFPublicLogger;
import com.sap.tc.cmi.metadata.ICMIModelObjectCollectionInfo;
import com.sap.tc.cmi.model.ICMIModel;
import com.sap.tc.cmi.util.CMIAbstractObservableList;
import com.sap.tc.col.client.generic.api.IAction;
import com.sap.tc.col.client.generic.api.IAspect;
import com.sap.tc.col.client.generic.api.IAspectRow;
import com.sap.tc.col.client.generic.api.IKey;
import com.sap.tc.col.client.generic.api.IKeyList;
import com.sap.tc.col.client.generic.api.IMessageList;
import com.sap.tc.col.client.generic.api.IServiceModule;
import com.sap.tc.col.client.generic.api.IValueSet;
import com.sap.tc.col.client.generic.api.LockStrategy;
import com.sap.tc.col.client.generic.api.SortingCriteria;
import com.sap.tc.col.client.metadata.api.IAspectActionDescriptor;
import com.sap.tc.col.client.metadata.api.IAspectDescriptor;
import com.sap.tc.col.client.metadata.api.IFieldDescriptor;
import com.sap.tc.col.client.metadata.api.IKeyAspectDescriptor;
import com.sap.tc.col.client.metadata.api.IRelationDescriptor;
import com.sap.tc.col.client.metadata.api.IStructureDescriptor;
import com.sap.tc.logging.Category;
import com.sap.tc.logging.Location;
import java.lang.ref.WeakReference;
import java.lang.reflect.InvocationTargetException;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import javax.ejb.FinderException;
import javax.ejb.ObjectNotFoundException;

public class Aspect
extends CMIAbstractObservableList
implements IAspect,
ICacheRootObject {
    private static final String APPLICATION = (class$com$sap$caf$rt$ui$cool$generic$Aspect == null ? (class$com$sap$caf$rt$ui$cool$generic$Aspect = Aspect.class$("com.sap.caf.rt.ui.cool.generic.Aspect")) : class$com$sap$caf$rt$ui$cool$generic$Aspect).getName();
    private static final String jARMRequest = "XAP:COOL:" + APPLICATION;
    private static final Location logger = Location.getLocation((String)APPLICATION);
    protected static final int CLEAN = 0;
    protected static final int HOLLOW = 1;
    protected static final int DIRTY = 2;
    protected static final int DIRTY_PENDING = 3;
    protected static final int INVALID = 4;
    protected static final int PROCESS_QUEUE_WAITING = 5;
    protected static final int INVALIDATE_ON_INSERT = 0;
    protected static final int INVALIDATE_ON_UPDATE = 1;
    protected static final int INVALIDATE_ON_DELETE = 2;
    protected static final int INVALIDATE_ON_ACTION = 3;
    protected static final int NUMBER_OF_HINTS = 4;
    protected static final BitSet NO_INVALIDATION = new BitSet(4);
    private final MessageList messages;
    static final boolean EXPLICIT_FLUSH = false;
    private ArrayList actionCalls;
    private IEdoTableEx aspectData;
    private IKeyList liveKeyList = new LiveKeyList();
    private boolean cacheRootObject = false;
    private Boolean fieldWiseChange;
    protected IKeyList m_originalKeyList;
    private Aspect sourceAspectOfCreatingRelation;
    private AspectRow sourceAspectRowOfCreatingRelation;
    private BitSet invalidationHints;
    private AspectCache aspectCache;
    private final AspectChanges aspectChanges;
    private final ServiceModule serviceModule;
    private final ArrayList aspectRows = new ArrayList();
    private final IAspectDescriptor descriptor;
    private int state = 0;
    private final ICMIModelObjectCollectionInfo modelObjectCollectionInfo;
    private HashMap aspectRowsMap = new HashMap();
    protected List m_relatedAspects;
    protected List m_observableList;
    private static List m_aspects = Collections.synchronizedList(new WeakArrayList(15));
    private boolean m_waitingCommit = false;
    private final DependantAspectCache dependantAspectCache = new DependantAspectCache();
    static /* synthetic */ Class class$com$sap$caf$rt$ui$cool$generic$Aspect;

    public static synchronized IAspect createEmptyInstance(ServiceModule serviceModule, IAspectDescriptor descriptor) {
        Aspect.cleanupList();
        Aspect a = new Aspect(serviceModule, descriptor);
        m_aspects.add(a);
        return a;
    }

    public static synchronized IAspect createPopulatedInstance(ServiceModule serviceModule, IKeyAspectDescriptor descriptor, IKeyList keyList) {
        Aspect.cleanupList();
        Aspect a = new Aspect(serviceModule, descriptor, keyList);
        m_aspects.add(a);
        return a;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Aspect(ServiceModule serviceModule, IAspectDescriptor descriptor) {
        String method = jARMRequest + ":Aspect(ServiceModule, IAspectDescriptor)";
        CAFPublicLogger.entering(null, (String)jARMRequest, (String)method, (Location)logger, (int)2);
        try {
            this.m_observableList = new ArrayList(25);
            if (descriptor == null) {
                throw new IllegalArgumentException("AspectDescriptor must not be null");
            }
            if (serviceModule == null) {
                throw new IllegalArgumentException("ServiceModule must not be null");
            }
            this.descriptor = descriptor;
            this.serviceModule = serviceModule;
            this.aspectChanges = new AspectChanges(this);
            this.messages = new MessageList(serviceModule.getAllMessagesInternal());
            this.modelObjectCollectionInfo = ((ColModelInfo)serviceModule.associatedModelInfo()).getOrCreateModelObjectCollectionInfo(descriptor);
            if (this.state == 0) {
                this.aspectData = new EdoTable(descriptor.getStructure());
            }
            this.m_relatedAspects = new ArrayList(5);
        }
        finally {
            CAFPublicLogger.exiting(null, (String)jARMRequest, (String)method, (Location)logger, (int)2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Aspect(ServiceModule serviceModule, IKeyAspectDescriptor descriptor, IKeyList keyList) {
        this(serviceModule, (IAspectDescriptor)descriptor);
        String method = jARMRequest + ":Aspect(ServiceModule, IKeyAspectDescriptor, IKeyList)";
        CAFPublicLogger.entering(null, (String)jARMRequest, (String)method, (Location)logger, (int)2);
        try {
            if (keyList == null) {
                this.setState(1);
                this.aspectData = null;
            } else {
                this.setState(5);
                int size = keyList.size();
                for (int i = 0; i < size; ++i) {
                    IKey key = keyList.getKey(i);
                    if (key.isLocalKey()) continue;
                    AspectRow keyRow = (AspectRow)this.createAspectRow(key);
                }
                this.setState(0);
            }
        }
        finally {
            CAFPublicLogger.exiting(null, (String)jARMRequest, (String)method, (Location)logger, (int)2);
        }
    }

    public ICMIModel associatedModel() {
        return this.serviceModule;
    }

    public ICMIModelObjectCollectionInfo associatedModelObjectCollectionInfo() {
        return this.modelObjectCollectionInfo;
    }

    public String getName() {
        return this.descriptor.getName();
    }

    protected int getState() {
        return this.state;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setState(int state) {
        String method = jARMRequest + ":setState(int)";
        CAFPublicLogger.entering(null, (String)jARMRequest, (String)method, (Location)logger, (int)2);
        try {
            this.state = state;
            if (state == 0) {
                IKeyList keyList = this.getKeyList();
                if (keyList instanceof KeyList) {
                    this.m_originalKeyList = (IKeyList)((KeyList)keyList).clone();
                } else if (keyList instanceof Cloneable) {
                    try {
                        this.m_originalKeyList = (IKeyList)keyList.getClass().getMethod("clone", null).invoke((Object)keyList, null);
                    }
                    catch (Exception e) {
                        logger.catching("IKeyList given cannot be cloned.", (Throwable)e);
                    }
                } else {
                    logger.warning(Category.getCategory((String)"InternalError"), (Object)"IKeyList given cannot be cloned.");
                }
            }
        }
        finally {
            CAFPublicLogger.exiting(null, (String)jARMRequest, (String)method, (Location)logger, (int)2);
        }
    }

    public IAspectRow getAspectRow(IKey key) {
        return this.getAspectRow(key, LockStrategy.SHARED_READ_ONLY);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IAspectRow getAspectRow(IKey key, LockStrategy lockMode) {
        String method = jARMRequest + ":getAspectRow(IKey, LockStrategy)";
        CAFPublicLogger.entering(null, (String)jARMRequest, (String)method, (Location)logger, (int)2);
        try {
            this.handleAccessAspect(true);
            AspectRow aspectRow = (AspectRow)this.aspectRowsMap.get(key);
            if (lockMode == LockStrategy.SHARED_READ_ONLY) {
                AspectRow aspectRow2 = aspectRow;
                return aspectRow2;
            }
            this.lockAndRefresh(aspectRow, lockMode);
            AspectRow aspectRow3 = aspectRow;
            return aspectRow3;
        }
        catch (Exception e) {
            MessageFactory.createAndRegisterMessageFromException((Throwable)e, this, true);
            IAspectRow iAspectRow = null;
            return iAspectRow;
        }
        finally {
            CAFPublicLogger.exiting(null, (String)jARMRequest, (String)method, (Location)logger, (int)2);
        }
    }

    public IAspectRow getAspectRow(int row) {
        return this.getAspectRow(row, LockStrategy.SHARED_READ_ONLY);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IAspectRow getAspectRow(int row, LockStrategy lockMode) {
        String method = jARMRequest + ":getAspectRow(int, LockStrategy)";
        CAFPublicLogger.entering(null, (String)jARMRequest, (String)method, (Location)logger, (int)2);
        try {
            if (row < 0 || row > this.size()) {
                IAspectRow iAspectRow = null;
                return iAspectRow;
            }
            AspectRow aspectRow = (AspectRow)this.aspectRows.get(row);
            if (lockMode == LockStrategy.SHARED_READ_ONLY) {
                AspectRow aspectRow2 = aspectRow;
                return aspectRow2;
            }
            this.lockAndRefresh(aspectRow, lockMode);
            AspectRow aspectRow3 = aspectRow;
            return aspectRow3;
        }
        catch (Exception e) {
            MessageFactory.createAndRegisterMessageFromException((Throwable)e, this, true);
            IAspectRow iAspectRow = null;
            return iAspectRow;
        }
        finally {
            CAFPublicLogger.exiting(null, (String)jARMRequest, (String)method, (Location)logger, (int)2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IAspectRow createAspectRow() {
        String method = jARMRequest + ":createAspectRow()";
        CAFPublicLogger.entering(null, (String)jARMRequest, (String)method, (Location)logger, (int)1);
        try {
            this.handleAccessAspect(false);
            Key key = new Key(this.getDescriptor().getKeyDescriptor());
            AspectRow aspectRow = this.createAspectRowInternal(this.aspectRows.size(), key);
            int index = this.addAspectRow(aspectRow);
            super.fireElementAdded((Object)aspectRow, index);
            AspectRow aspectRow2 = aspectRow;
            return aspectRow2;
        }
        catch (Exception e) {
            MessageFactory.createAndRegisterMessageFromException((Throwable)e, this, true);
            IAspectRow iAspectRow = null;
            return iAspectRow;
        }
        finally {
            CAFPublicLogger.exiting(null, (String)jARMRequest, (String)method, (Location)logger, (int)1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IAspectRow createRelatedAspectRow(IAspectRow row) {
        String method = jARMRequest + ":createRelatedAspectRow(IAspectRow)";
        CAFPublicLogger.entering(null, (String)jARMRequest, (String)method, (Location)logger, (int)1);
        try {
            if (this.sourceAspectOfCreatingRelation == null) {
                throw new RuntimeException("Source aspect is not initialized. The Aspect must be retrived by getRelatedAspect() method.");
            }
            AspectRow insertedRow = null;
            int current_state = this.getState();
            try {
                this.setState(3);
                insertedRow = (AspectRow)this.createAspectRow();
            }
            finally {
                this.setState(current_state);
            }
            current_state = this.getState();
            try {
                this.setState(5);
                insertedRow.setAttributeValue(((AspectRow)row).getAspectRowData());
            }
            finally {
                this.setState(current_state);
            }
            AspectRow aspectRow = insertedRow;
            return aspectRow;
        }
        catch (Exception e) {
            MessageFactory.createAndRegisterMessageFromException((Throwable)e, this, true);
            IAspectRow iAspectRow = null;
            return iAspectRow;
        }
        finally {
            CAFPublicLogger.exiting(null, (String)jARMRequest, (String)method, (Location)logger, (int)1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IAspectRow createRelatedAspectRow(IKey key) {
        String method = jARMRequest + ":createRelatedAspectRow(IKey)";
        CAFPublicLogger.entering(null, (String)jARMRequest, (String)method, (Location)logger, (int)1);
        try {
            if (this.sourceAspectOfCreatingRelation == null) {
                throw new RuntimeException("Source aspect is not initialized. The Aspect must be retrived by getRelatedAspect() method.");
            }
            IAspectRow insertedRow = this.createAspectRow();
            this.aspectChanges.registerInsertRelation(insertedRow.getKey(), key);
            IAspectRow iAspectRow = insertedRow;
            return iAspectRow;
        }
        catch (Exception e) {
            MessageFactory.createAndRegisterMessageFromException((Throwable)e, this, true);
            IAspectRow iAspectRow = null;
            return iAspectRow;
        }
        finally {
            CAFPublicLogger.exiting(null, (String)jARMRequest, (String)method, (Location)logger, (int)1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IAspectRow createAspectRow(IKey key) {
        String method = jARMRequest + ":createAspectRow(IKey)";
        CAFPublicLogger.entering(null, (String)jARMRequest, (String)method, (Location)logger, (int)2);
        try {
            AspectRow aspectRow = this.createAspectRowInternal(this.aspectRows.size(), (Key)key);
            this.addAspectRow(aspectRow);
            aspectRow.setKeyFields((Key)key);
            AspectRow aspectRow2 = aspectRow;
            return aspectRow2;
        }
        catch (Exception e) {
            MessageFactory.createAndRegisterMessageFromException((Throwable)e, this, true);
            IAspectRow iAspectRow = null;
            return iAspectRow;
        }
        finally {
            CAFPublicLogger.exiting(null, (String)jARMRequest, (String)method, (Location)logger, (int)2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected IAspectRow createAspectRow(int index) {
        String method = jARMRequest + ":createAspectRow(int)";
        CAFPublicLogger.entering(null, (String)jARMRequest, (String)method, (Location)logger, (int)2);
        try {
            Key key = new Key(this.getDescriptor().getKeyDescriptor());
            AspectRow aspectRow = this.createAspectRowInternal(index, key);
            this.aspectRows.add(aspectRow);
            this.m_observableList.add(aspectRow);
            AspectRow aspectRow2 = aspectRow;
            return aspectRow2;
        }
        catch (Exception e) {
            MessageFactory.createAndRegisterMessageFromException((Throwable)e, this, true);
            IAspectRow iAspectRow = null;
            return iAspectRow;
        }
        finally {
            CAFPublicLogger.exiting(null, (String)jARMRequest, (String)method, (Location)logger, (int)2);
        }
    }

    protected AspectRow createAspectRowInternal(int index, Key key) {
        return new AspectRow(this, index, key);
    }

    public boolean removeAspectRow(IAspectRow aspectRow) {
        return this.removeAspectRow(aspectRow, LockStrategy.SHARED_READ_ONLY);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeAspectRow(IAspectRow aspectRow, LockStrategy lockMode) {
        String method = jARMRequest + ":removeAspectRow(IAspectRow, LockStrategy)";
        CAFPublicLogger.entering(null, (String)jARMRequest, (String)method, (Location)logger, (int)1);
        try {
            boolean result = false;
            int index = this.indexOf(aspectRow);
            if (index >= 0) {
                result = this.removeAspectRowSilently(aspectRow, lockMode);
                super.fireElementRemoved((Object)aspectRow, index);
            }
            boolean bl = result;
            return bl;
        }
        catch (Exception e) {
            MessageFactory.createAndRegisterMessageFromException((Throwable)e, this, true);
            boolean bl = false;
            return bl;
        }
        finally {
            CAFPublicLogger.exiting(null, (String)jARMRequest, (String)method, (Location)logger, (int)1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean removeAspectRowSilently(IAspectRow aspectRow, LockStrategy lockMode) {
        String method = jARMRequest + ":removeAspectRowSilently(IAspectRow, LockStrategy)";
        CAFPublicLogger.entering(null, (String)jARMRequest, (String)method, (Location)logger, (int)2);
        try {
            this.handleAccessAspect(false);
            if (this.contains(aspectRow)) {
                if (this.state == 3) {
                    int[] row = new int[]{((AspectRow)aspectRow).getIndex()};
                    if (this.aspectChanges != null) {
                        this.aspectChanges.resetUpdates(row);
                    }
                }
                this.aspectRowsMap.remove(aspectRow.getKey());
                this.aspectRows.remove(aspectRow);
                this.m_observableList.remove(aspectRow);
                int rowIndex = ((AspectRow)aspectRow).getIndex();
                this.aspectData.deleteFrom(rowIndex, 1);
                if (this.state == 0 || this.state == 2) {
                    AspectRow sourceRow;
                    if (this.aspectChanges != null) {
                        this.aspectChanges.registerDelete((AspectRow)aspectRow);
                    }
                    if ((sourceRow = this.getSourceAspectRowOfCreatingRelation()) != null) {
                        sourceRow.handleDirtyState("key");
                    }
                }
                for (int i = rowIndex; i < this.size(); ++i) {
                    AspectRow row = (AspectRow)this.aspectRows.get(i);
                    row.setIndex(i);
                }
                ((AspectRow)aspectRow).invalidateInternal();
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            CAFPublicLogger.exiting(null, (String)jARMRequest, (String)method, (Location)logger, (int)2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IAction createAction(String actionName) {
        String method = jARMRequest + ":createAction(String)";
        CAFPublicLogger.entering(null, (String)jARMRequest, (String)method, (Location)logger, (int)2);
        try {
            this.handleAccessAspect(true);
            IAspectActionDescriptor aspectActionDescriptor = this.descriptor.getAspectActionDescriptor(actionName);
            if (aspectActionDescriptor == null) {
                throw new IllegalArgumentException("AspectActionDescriptor for Action " + actionName + " doesn't exist");
            }
            IAction iAction = this.serviceModule.createActionInternal(aspectActionDescriptor, this);
            return iAction;
        }
        catch (Exception e) {
            MessageFactory.createAndRegisterMessageFromException((Throwable)e, this, true);
            IAction iAction = null;
            return iAction;
        }
        finally {
            CAFPublicLogger.exiting(null, (String)jARMRequest, (String)method, (Location)logger, (int)2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    IRelationDescriptor getRelationDescriptorOrFail(String relationName) throws IllegalArgumentException {
        String method = jARMRequest + ":getRelationDescriptorOrFail(String)";
        CAFPublicLogger.entering(null, (String)jARMRequest, (String)method, (Location)logger, (int)2);
        try {
            IRelationDescriptor relationDescriptor = this.descriptor.getRelationDescriptor(relationName);
            if (relationDescriptor == null) {
                if (!this.descriptor.isKeyAspect()) {
                    relationDescriptor = this.descriptor.getKeyDescriptor().getRelationDescriptor(relationName);
                }
                if (relationDescriptor == null) {
                    throw new IllegalArgumentException("aspect '" + this.getName() + "' or its Key has no relation with name '" + relationName + "'");
                }
            }
            IRelationDescriptor iRelationDescriptor = relationDescriptor;
            return iRelationDescriptor;
        }
        finally {
            CAFPublicLogger.exiting(null, (String)jARMRequest, (String)method, (Location)logger, (int)2);
        }
    }

    public IAspect getRelatedAspect(String relationName) {
        return this.getRelatedAspect(relationName, LockStrategy.SHARED_READ_ONLY);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected IAspect getRelatedFromCache(String relationName, LockStrategy lockMode) throws ServiceException, InvocationTargetException, IllegalAccessException {
        String method = jARMRequest + ":getRelatedFromCache(String, LockStrategy)";
        CAFPublicLogger.entering(null, (String)jARMRequest, (String)method, (Location)logger, (int)2);
        try {
            Aspect targetAspect = this.dependantAspectCache.getRelatedAspect(relationName);
            if (targetAspect != null) {
                if (lockMode != LockStrategy.SHARED_READ_ONLY && targetAspect.getState() != 0 && targetAspect.getState() != 1) {
                    throw new IllegalArgumentException("Locking of aspect '" + targetAspect.getName() + "' not allowed, cause Aspect is not CLEAN or HOLLOW!");
                }
            } else {
                IRelationDescriptor relationDescriptor = this.getRelationDescriptorOrFail(relationName);
                String sourceAspectName = relationDescriptor.getSourceAspectDescriptor().getName();
                if (!sourceAspectName.equals(this.getName())) {
                    IAspect iAspect = this.getAspect(sourceAspectName).getRelatedAspect(relationName, lockMode);
                    return iAspect;
                }
            }
            Aspect aspect = targetAspect;
            return aspect;
        }
        finally {
            CAFPublicLogger.exiting(null, (String)jARMRequest, (String)method, (Location)logger, (int)2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected IAspect createAndPopulateRelatedAspect(String relationName, LockStrategy lockMode) throws ServiceException, InvocationTargetException, IllegalAccessException {
        String method = jARMRequest + ":createAndPopulateRelatedAspect(String, LockStrategy)";
        CAFPublicLogger.entering(null, (String)jARMRequest, (String)method, (Location)logger, (int)2);
        try {
            IRelationDescriptor relationDescriptor = this.getRelationDescriptorOrFail(relationName);
            IAspectDescriptor targetDesc = relationDescriptor.getTargetAspectDescriptor();
            ServiceFacade facade = this.serviceModule.getServiceFacade();
            IServiceModule targetServiceModule = facade.getServiceModule(targetDesc.getServiceModuleDescriptor().getName());
            Aspect targetAspect = (Aspect)targetServiceModule.createAspect(targetDesc.getName());
            this.serviceModule.getAspectServiceAccess().readRelatedAspects(this.descriptor.getName(), relationName, (Collection)this.getKeyList(true));
            this.dependantAspectCache.addRelatedAspect(this, relationName, targetAspect, null);
            this.addRelatedAspect(targetAspect);
            Aspect aspect = targetAspect;
            return aspect;
        }
        finally {
            CAFPublicLogger.exiting(null, (String)jARMRequest, (String)method, (Location)logger, (int)2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void populateRelatedAspect(LockStrategy lockMode, IAspect targetAspect) throws ServiceException, InvocationTargetException, IllegalAccessException {
        String method = jARMRequest + ":populateRelatedAspect(LockStrategy, IAspect)";
        CAFPublicLogger.entering(null, (String)jARMRequest, (String)method, (Location)logger, (int)1);
        try {
            String methodName = "find" + targetAspect.getDescriptor().getName() + "By" + this.getName() + "Pks";
            logger.debugT("Invocation of method -->" + methodName);
            Object rawResult = null;
            ((Aspect)targetAspect).setState(5);
            try {
                if (rawResult instanceof List) {
                    Iterator it = ((List)rawResult).iterator();
                    while (it.hasNext()) {
                        this.createRow(targetAspect, (IDataContainerBean)it.next());
                    }
                } else {
                    this.createRow(targetAspect, rawResult);
                }
            }
            finally {
                ((Aspect)targetAspect).setState(0);
            }
        }
        finally {
            CAFPublicLogger.exiting(null, (String)jARMRequest, (String)method, (Location)logger, (int)1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IAspect getRelatedAspect(String relationName, LockStrategy lockMode) {
        String method = jARMRequest + ":getRelatedAspect(String, LockStrategy)";
        CAFPublicLogger.entering(null, (String)jARMRequest, (String)method, (Location)logger, (int)1);
        try {
            if (this.state != 1) {
                this.handleAccessAspect(true);
            }
            IKeyAspectDescriptor targetKeyAspectDescriptor = this.getDescriptor().getRelationDescriptor(relationName).getTargetAspectDescriptor().getKeyDescriptor();
            IServiceModule targetServiceModule = this.serviceModule.getServiceFacade().getServiceModule(this.getDescriptor().getRelationDescriptor(relationName).getTargetAspectDescriptor().getServiceModuleDescriptor().getName());
            IKeyList keyList = targetServiceModule.createKeyList(targetKeyAspectDescriptor.getName());
            if (this.aspectRows != null) {
                for (int i = 0; i < this.aspectRows.size(); ++i) {
                    AspectRow row = (AspectRow)this.aspectRows.get(i);
                    Object refKey = row.getAspectRowData().getProperty(relationName);
                    if (refKey == null) continue;
                    if (refKey instanceof Collection) {
                        String[] keys = ((Collection)refKey).toArray(new String[0]);
                        for (int j = 0; j < keys.length; ++j) {
                            Key key = new Key(targetKeyAspectDescriptor);
                            key.setKeyFields(new String[]{keys[j]});
                            keyList.add((Object)key);
                        }
                        continue;
                    }
                    Key key = new Key(targetKeyAspectDescriptor);
                    key.setKeyFields(new String[]{(String)refKey});
                    keyList.add((Object)key);
                }
            }
            Aspect targetAspect = new Aspect((ServiceModule)targetServiceModule, this.getDescriptor().getRelationDescriptor(relationName).getTargetAspectDescriptor());
            targetAspect.loadAspectRows(keyList, LockStrategy.SHARED_READ_ONLY);
            Aspect aspect = targetAspect;
            return aspect;
        }
        catch (Exception e) {
            MessageFactory.createAndRegisterMessageFromException((Throwable)e, this, true);
            IAspect iAspect = null;
            return iAspect;
        }
        finally {
            CAFPublicLogger.exiting(null, (String)jARMRequest, (String)method, (Location)logger, (int)1);
        }
    }

    private void createRow(IAspect result, IDataContainerBean bean) {
        AspectRow row = (AspectRow)result.createAspectRow();
        row.supplyRowWithData(bean);
    }

    public IAspect getRelatedAspect(String relationName, String targetAspectName) {
        return this.getRelatedAspect(relationName, targetAspectName, LockStrategy.SHARED_READ_ONLY);
    }

    public IAspect getRelatedAspect(String relationName, String targetAspectName, LockStrategy lockMode) {
        return this.getRelatedAspect(relationName, LockStrategy.SHARED_READ_ONLY);
    }

    public IAspect getKeyAspect() {
        if (this.descriptor.getKeyDescriptor().getName().equals(this.getName())) {
            return this;
        }
        return this.getAspect(this.descriptor.getKeyDescriptor().getName());
    }

    public IAspect getAspect(String aspectName) {
        return this.getAspect(aspectName, LockStrategy.SHARED_READ_ONLY);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IAspect getAspect(String aspectName, LockStrategy lockMode) {
        String method = jARMRequest + ":getAspect(String, LockStrategy)";
        CAFPublicLogger.entering(null, (String)jARMRequest, (String)method, (Location)logger, (int)2);
        try {
            if (this.state != 1) {
                this.handleAccessAspect(true);
            }
            if (!this.isValidAspectName(aspectName)) {
                throw new IllegalArgumentException("No select from aspect '" + this.getName() + "' to Aspect with name '" + aspectName + "'");
            }
            Aspect resultAspect = this.dependantAspectCache.getSiblingAspect(aspectName);
            if (resultAspect != null) {
                if (lockMode != LockStrategy.SHARED_READ_ONLY) {
                    if (resultAspect.getState() != 0 && resultAspect.getState() != 1) {
                        throw new IllegalArgumentException("Locking of aspect '" + aspectName + "' not allowed, cause Aspect is not CLEAN or HOLLOW!");
                    }
                    resultAspect.lockAndRefresh(lockMode);
                }
                Aspect aspect = resultAspect;
                return aspect;
            }
            resultAspect = (Aspect)this.serviceModule.getAspect(this, aspectName, this.liveKeyList, lockMode);
            this.dependantAspectCache.addSiblingAspect(aspectName, resultAspect);
            Aspect aspect = resultAspect;
            return aspect;
        }
        catch (Exception e) {
            MessageFactory.createAndRegisterMessageFromException((Throwable)e, this, true);
            IAspect iAspect = null;
            return iAspect;
        }
        finally {
            CAFPublicLogger.exiting(null, (String)jARMRequest, (String)method, (Location)logger, (int)2);
        }
    }

    void lockAndRefresh(AspectRow row, LockStrategy lockMode) {
        KeyList keyList = new KeyList(this.getKeyAspect().getDescriptor().getKeyDescriptor());
        keyList.add(row.getKey());
        row.setState(0);
    }

    void lockAndRefresh(IKeyList keyList, LockStrategy lockMode) {
        if (this.state == 1) {
            this.lock(keyList, lockMode);
        } else if (this.state == 0) {
            this.loadAspectRows(keyList, lockMode);
        }
    }

    void lockAndRefresh(LockStrategy lockMode) {
        this.lockAndRefresh(this.getKeyList(true), lockMode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadAspectRows(IKeyList keyList, LockStrategy lockMode) {
        String method = jARMRequest + ":loadAspectRows(IKeyList, LockStrategy)";
        CAFPublicLogger.entering(null, (String)jARMRequest, (String)method, (Location)logger, (int)2);
        try {
            try {
                try {
                    this.setState(5);
                    Collection rawResult = this.serviceModule.getAspectServiceAccess().readAspectObjects(this.descriptor.getName(), (Collection)keyList);
                    IKeyAspectDescriptor keyDesc = this.getDescriptor().getKeyDescriptor();
                    IStructureDescriptor keyStruct = keyDesc.getStructure();
                    String[] keyFieldValues = new String[keyStruct.size()];
                    Iterator it = ((List)rawResult).iterator();
                    while (it.hasNext()) {
                        IDataContainerBean bean = (IDataContainerBean)it.next();
                        for (int i = 0; i < keyFieldValues.length; ++i) {
                            String nextName = keyStruct.getFieldDescriptor(i).getName();
                            keyFieldValues[i] = bean.getProperty(nextName) == null ? "" : bean.getProperty(nextName).toString();
                        }
                        Key key = new Key(keyDesc, keyFieldValues);
                        IAspectRow row = this.getAspectRow(key);
                        if (row == null) {
                            row = this.createAspectRow(key);
                        }
                        ((AspectRow)row).supplyRowWithData(bean);
                    }
                }
                catch (Exception e) {
                    MessageFactory.createAndRegisterMessageFromException((Throwable)e, this, true);
                }
                finally {
                    this.setState(0);
                }
            }
            catch (Exception ex) {
                MessageFactory.createAndRegisterMessageFromException((Throwable)ex, this, true);
            }
        }
        finally {
            CAFPublicLogger.exiting(null, (String)jARMRequest, (String)method, (Location)logger, (int)2);
        }
    }

    private void lock(IKeyList keyList, LockStrategy lockMode) {
        String serviceName = this.getServiceModule().getDescriptor().getName();
    }

    private void lock(LockStrategy lockMode) {
        this.lock(this.getKeyList(true), lockMode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int addAspectRow(AspectRow aspectRow) {
        String method = jARMRequest + ":addAspectRow(AspectRow)";
        CAFPublicLogger.entering(null, (String)jARMRequest, (String)method, (Location)logger, (int)2);
        int index = -1;
        try {
            if (aspectRow != null) {
                index = this.aspectRows.indexOf(aspectRow);
                if (index >= 0) {
                    int n = index;
                    return n;
                }
                this.aspectData.append(1);
                index = this.aspectRows.size();
                this.aspectRows.add(aspectRow);
                this.m_observableList.add(aspectRow);
                this.aspectRowsMap.put(aspectRow.getKey(), aspectRow);
                if (this.state == 0 || this.state == 2) {
                    AspectRow sourceRow;
                    if (this.aspectChanges != null) {
                        this.aspectChanges.registerInsert(aspectRow.getKey());
                    }
                    if ((sourceRow = this.getSourceAspectRowOfCreatingRelation()) != null) {
                        sourceRow.handleDirtyState("key");
                    }
                }
            }
        }
        finally {
            CAFPublicLogger.exiting(null, (String)jARMRequest, (String)method, (Location)logger, (int)2);
        }
        return index;
    }

    public IAspectDescriptor getDescriptor() {
        return this.descriptor;
    }

    public IServiceModule getServiceModule() {
        return this.serviceModule;
    }

    protected void registerUpdate(IKey key, String fieldName) {
        if ((this.state == 0 || this.state == 2) && this.aspectChanges != null) {
            this.aspectChanges.registerUpdate(key, fieldName);
            if (this.getState() != 2) {
                this.setState(2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateRows(int[] updateIndices) throws Exception {
        String method = jARMRequest + ":updateRows(int[])";
        CAFPublicLogger.entering(null, (String)jARMRequest, (String)method, (Location)logger, (int)2);
        String serviceName = this.getServiceModule().getDescriptor().getName();
        try {
            for (int i = 0; i < updateIndices.length; ++i) {
                IAspectRow row = this.getAspectRow(updateIndices[i]);
                ((AspectRow)row).calculateReferences();
                Object dataBean = null;
                this.serviceModule.getAspectServiceAccess().updateAspect(row);
            }
            this.aspectChanges.resetAllUpdates();
        }
        finally {
            CAFPublicLogger.exiting(null, (String)jARMRequest, (String)method, (Location)logger, (int)2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deleteRows(KeyList keyList) throws Exception {
        String method = jARMRequest + ":deleteRows(KeyList)";
        CAFPublicLogger.entering(null, (String)jARMRequest, (String)method, (Location)logger, (int)2);
        try {
            String serviceName = this.getServiceModule().getDescriptor().getName();
            try {
                this.deleteRelations(keyList);
                this.serviceModule.getAspectServiceAccess().deleteAspectRows(this.getName(), keyList);
            }
            finally {
                this.aspectChanges.resetDeleteButKeyList(null);
            }
        }
        finally {
            CAFPublicLogger.exiting(null, (String)jARMRequest, (String)method, (Location)logger, (int)2);
        }
    }

    private boolean isFinderException(ServiceException se) {
        Object cause = se;
        while (!((cause = cause.getCause()) == null || cause instanceof ObjectNotFoundException || cause instanceof FinderException || cause instanceof CAFFindException)) {
        }
        return cause != null;
    }

    protected void deleteRelations(IKeyList keyList) throws ServiceException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void insertRows(int[] updateIndices) throws Exception {
        String method = jARMRequest + ":insertRows(int[])";
        CAFPublicLogger.entering(null, (String)jARMRequest, (String)method, (Location)logger, (int)1);
        try {
            String serviceName = this.getServiceModule().getDescriptor().getName();
            for (int i = 0; i < updateIndices.length; ++i) {
                AspectRow row = (AspectRow)this.getAspectRow(updateIndices[i]);
                IKey rowKey = row.getKey();
                row.calculateReferences();
                this.serviceModule.getAspectServiceAccess().insertAspectRow(row);
                this.aspectChanges.resetInsert(rowKey);
                continue;
            }
        }
        finally {
            CAFPublicLogger.exiting(null, (String)jARMRequest, (String)method, (Location)logger, (int)1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendChanges() {
        logger.entering("sendChanges", new Object[]{"Aspect Name = " + this.getName()});
        try {
            String isComplex = this.getDescriptor().getAttributeStringValue("complex_attribute");
            String isCollectionAspect = this.getDescriptor().getAttributeStringValue("collection_support");
            if ("true".equals(isComplex) || "true".equals(isCollectionAspect)) {
                return;
            }
            Iterator i = this.m_relatedAspects.iterator();
            while (i.hasNext()) {
                IAspect relatedAspect = (IAspect)i.next();
                String isCollection = relatedAspect.getDescriptor().getAttributeStringValue("collection_support");
                if (!"true".equals(isCollection)) {
                    relatedAspect.sendChanges();
                    this.messages.transferMessagesFrom((MessageList)relatedAspect.getMessages());
                }
                if (this.getState() != 2 && "true".equals(relatedAspect.getDescriptor().getAttributeStringValue("complex_attribute")) && relatedAspect instanceof Aspect && ((Aspect)relatedAspect).getState() == 2) {
                    this.setState(2);
                }
                if (this.getState() == 2 || !"true".equals(isCollection) || !(relatedAspect instanceof Aspect) || ((Aspect)relatedAspect).getState() != 2) continue;
                this.setState(2);
            }
            if (this.getState() != 2) {
                logger.infoT("sendChanges", "exit, cause Aspect is not dirty");
            } else {
                int[] insertedRowIndices;
                KeyList deletedKeyList;
                this.m_waitingCommit = true;
                int[] updatedRowIndices = this.aspectChanges.getChangedAspectRows();
                if (updatedRowIndices.length > 0) {
                    if (this.isFieldWiseChange()) {
                        throw new UnsupportedOperationException("Field wise update not supported");
                    }
                    this.updateRows(updatedRowIndices);
                    logger.infoT("sendChanges", "Update: updated AspectRows : " + updatedRowIndices.length);
                }
                if ((deletedKeyList = this.aspectChanges.getDeletedKeys()) != null && !deletedKeyList.isEmpty()) {
                    this.deleteRows(deletedKeyList);
                }
                if ((insertedRowIndices = this.aspectChanges.getInsertedAspectRows()).length > 0) {
                    this.insertRows(insertedRowIndices);
                    logger.infoT("sendChanges", "inserted AspectRows : " + insertedRowIndices.length);
                }
                this.setState(0);
            }
        }
        catch (InvocationTargetException ite) {
            MessageFactory.createAndRegisterMessageFromException((Throwable)ite, this);
        }
        catch (ServiceException se) {
            MessageFactory.createAndRegisterMessageFromException((Throwable)se, this, true);
        }
        catch (Throwable ex) {
            MessageFactory.createAndRegisterMessageFromException(ex, this, true);
        }
        finally {
            logger.exiting();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleAccessAspect(boolean readOnly) {
        String method = jARMRequest + ":handleAccessAspect(boolean)";
        CAFPublicLogger.entering(null, (String)jARMRequest, (String)method, (Location)logger, (int)2);
        try {
            if (this.state == 1) {
                this.serviceModule.flush();
            }
            if (this.state == 4) {
                logger.fatalT(" Aspect '" + this.getName() + "' is invalid: Fatal Access Error!!!");
                throw new IllegalStateException(" Aspect '" + this.getName() + "' is invalid: Fatal Access Error!!!");
            }
            if (this.state == 0 && !readOnly) {
                this.setState(2);
            }
        }
        finally {
            CAFPublicLogger.exiting(null, (String)jARMRequest, (String)method, (Location)logger, (int)2);
        }
    }

    public void onServiceQueueWillBeFlushed() {
        if (this.getState() == 2) {
            this.sendChanges();
        }
    }

    public IEdoTableEx getAspectData() {
        return this.aspectData;
    }

    public String toString() {
        try {
            String nl = System.getProperty("line.separator");
            StringBuffer buf = new StringBuffer();
            buf.append("  <Aspect name=\"" + this.getName() + "\" >").append(nl);
            for (int i = 0; i < this.size(); ++i) {
                buf.append("  <Row " + i + ">").append(nl);
                buf.append(this.get(i).toString());
                buf.append("  </Row>").append(nl);
            }
            buf.append("  </Aspect>").append(nl);
            return buf.toString();
        }
        catch (Exception e) {
            return "Error while converting Aspect to String. Super.toString() is: " + super.toString();
        }
    }

    public void addSilently(int index, Object element) {
        if (!(element instanceof IAspectRow)) {
            throw new IllegalArgumentException("The addSilently method must be supplied with parameter of type IAspectRow. Actual supplied parameter class is: " + element.getClass().getName());
        }
        if (((IAspectRow)element).getAspect() != this) {
            throw new UnsupportedOperationException("Aspect Row is invalid for the Aspect: " + this);
        }
        this.m_observableList.add(index, element);
    }

    public Object get(int index) {
        int readlIndex = this.aspectRows.indexOf(this.m_observableList.get(index));
        return this.getAspectRow(readlIndex);
    }

    public Object removeSilently(int index) {
        try {
            int readlIndex = this.aspectRows.indexOf(this.m_observableList.get(index));
            IAspectRow row = this.getAspectRow(readlIndex);
            this.removeAspectRowSilently(row, LockStrategy.SHARED_READ_ONLY);
            return row;
        }
        catch (Exception e) {
            MessageFactory.createAndRegisterMessageFromException((Throwable)e, this, true);
            return null;
        }
    }

    public Object setSilently(int index, Object element) {
        if (this.aspectRows.indexOf(element) < 0) {
            throw new UnsupportedOperationException("Aspect doesn't support changing rows via its List interface");
        }
        this.m_observableList.set(index, element);
        return element;
    }

    public int size() {
        try {
            this.handleAccessAspect(true);
            return this.aspectRows.size();
        }
        catch (Exception e) {
            MessageFactory.createAndRegisterMessageFromException((Throwable)e, this, true);
            return 0;
        }
    }

    public boolean equals(Object o) {
        return this == o;
    }

    public int hashCode() {
        return System.identityHashCode(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invalidate() {
        String method = jARMRequest + ":invalidate()";
        CAFPublicLogger.entering(null, (String)jARMRequest, (String)method, (Location)logger, (int)2);
        try {
            if (!this.isCacheRootObject()) {
                throw new UnsupportedOperationException("Aspect is not root of an AspectCache!");
            }
            this.invalidateInternal();
            this.aspectCache.clear();
            this.sourceAspectRowOfCreatingRelation = null;
        }
        catch (Exception e) {
            MessageFactory.createAndRegisterMessageFromException((Throwable)e, this, true);
        }
        finally {
            CAFPublicLogger.exiting(null, (String)jARMRequest, (String)method, (Location)logger, (int)2);
        }
    }

    protected void invalidateInternal() {
        if (this.getState() == 4) {
            return;
        }
        this.serviceModule.unregisterAspect(this);
        this.setState(4);
        this.dependantAspectCache.invalidate();
        Iterator rowsIterator = this.aspectRows.iterator();
        while (rowsIterator.hasNext()) {
            AspectRow row = (AspectRow)rowsIterator.next();
            row.invalidateInternal();
        }
    }

    protected void bindAspectCache(AspectCache aspectCache) {
        this.aspectCache = aspectCache;
    }

    public boolean isCacheRootObject() {
        return this.cacheRootObject;
    }

    protected void setCacheRootObject(boolean cacheRootObject) {
        this.cacheRootObject = cacheRootObject;
    }

    protected Relation getRelation(String relationName) {
        return this.dependantAspectCache.getRelation(relationName);
    }

    public AspectCache getAspectCache() {
        return this.aspectCache;
    }

    protected Aspect getSelectedAspect(String aspectName) {
        return this.dependantAspectCache.getSiblingAspect(aspectName);
    }

    public IKeyList getKeyList() {
        return this.getKeyList(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IKeyList getKeyList(boolean excludeLocal) {
        String method = jARMRequest + ":getKeyList(boolean)";
        CAFPublicLogger.entering(null, (String)jARMRequest, (String)method, (Location)logger, (int)2);
        try {
            this.handleAccessAspect(true);
            KeyList keyList = (KeyList)this.serviceModule.createKeyList(this.descriptor.getKeyDescriptor().getName());
            Iterator it = this.aspectRows.iterator();
            while (it.hasNext()) {
                AspectRow aspectRow = (AspectRow)it.next();
                IKey k = aspectRow.getKey();
                if (excludeLocal && k.isLocalKey()) continue;
                keyList.add(k);
            }
            KeyList keyList2 = keyList;
            return keyList2;
        }
        catch (Exception e) {
            MessageFactory.createAndRegisterMessageFromException((Throwable)e, this, true);
            IKeyList iKeyList = null;
            return iKeyList;
        }
        finally {
            CAFPublicLogger.exiting(null, (String)jARMRequest, (String)method, (Location)logger, (int)2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BitSet getInvalidationHints() {
        String method = jARMRequest + ":getInvalidationHints()";
        CAFPublicLogger.entering(null, (String)jARMRequest, (String)method, (Location)logger, (int)2);
        try {
            if (this.invalidationHints == null) {
                this.invalidationHints = new BitSet(4);
                if (this.affectsMoreThanOutRecords("UPDATE_FIELDS") || this.affectsMoreThanOutRecords("UPDATE")) {
                    this.invalidationHints.set(1);
                }
                if (this.affectsMoreThanOutRecords("INSERT")) {
                    this.invalidationHints.set(0);
                }
                if (this.affectsMoreThanOutRecords("DELETE")) {
                    this.invalidationHints.set(2);
                }
                IAspectActionDescriptor[] actionDescriptors = this.descriptor.getAspectActionDescriptors();
                for (int i = 0; i < actionDescriptors.length; ++i) {
                    if (!this.affectsMoreThanOutRecords(actionDescriptors[i].getName())) continue;
                    this.invalidationHints.set(3);
                    break;
                }
            }
            BitSet bitSet = this.invalidationHints;
            return bitSet;
        }
        finally {
            CAFPublicLogger.exiting(null, (String)jARMRequest, (String)method, (Location)logger, (int)2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean affectsMoreThanOutRecords(String actionName) {
        String method = jARMRequest + ":affectsMoreThanOutRecords(String)";
        CAFPublicLogger.entering(null, (String)jARMRequest, (String)method, (Location)logger, (int)2);
        try {
            if (this.descriptor.getActionAttributeAffects(actionName) == 3 || this.descriptor.getActionAttributeAffects(actionName) == 2) {
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        catch (UnsupportedOperationException e) {
            boolean bl = false;
            return bl;
        }
        finally {
            CAFPublicLogger.exiting(null, (String)jARMRequest, (String)method, (Location)logger, (int)2);
        }
    }

    public void setInvalidationHints(boolean invalidateOnInsert, boolean invalidateOnUpdate, boolean invalidateOnDelete, boolean invalidateOnAction) {
        BitSet invalidationHints = this.getInvalidationHints();
        if (invalidateOnInsert) {
            invalidationHints.set(0);
        } else {
            invalidationHints.clear(0);
        }
        if (invalidateOnUpdate) {
            invalidationHints.set(1);
        } else {
            invalidationHints.clear(1);
        }
        if (invalidateOnDelete) {
            invalidationHints.set(2);
        } else {
            invalidationHints.clear(2);
        }
        if (invalidateOnAction) {
            invalidationHints.set(3);
        } else {
            invalidationHints.clear(3);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean isInvalidationNeeded() {
        String method = jARMRequest + ":isInvalidationNeeded()";
        CAFPublicLogger.entering(null, (String)jARMRequest, (String)method, (Location)logger, (int)2);
        try {
            BitSet changes = this.aspectChanges.getChangesState();
            changes.and(this.getInvalidationHints());
            if (changes.equals(NO_INVALIDATION)) {
                logger.infoT("isInvalidationNeeded", "no invalidation needed!");
                boolean bl = false;
                return bl;
            }
            boolean bl = true;
            return bl;
        }
        finally {
            CAFPublicLogger.exiting(null, (String)jARMRequest, (String)method, (Location)logger, (int)2);
        }
    }

    private boolean isValidAspectName(String aspectName) {
        if (aspectName == null || aspectName.equals(this.getName())) {
            return false;
        }
        IKeyAspectDescriptor keyDescriptor = this.descriptor.getKeyDescriptor();
        if (keyDescriptor.getName().equals(aspectName)) {
            return true;
        }
        IAspectDescriptor target = keyDescriptor.getAspectDescriptor(aspectName);
        return target != null;
    }

    public void promoteLock() {
    }

    public void unlock() {
    }

    public IMessageList getMessages() {
        return this.messages;
    }

    protected void extendKeyMap(AspectRow row, Key key) {
        key.takeFieldsFromRow(row);
        this.aspectRowsMap.put(key, row);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setAspectData(IEdoTableEx newAspectData) {
        String method = jARMRequest + ":setAspectData(IEdoTableEx)";
        CAFPublicLogger.entering(null, (String)jARMRequest, (String)method, (Location)logger, (int)2);
        try {
            this.setState(5);
            this.aspectData = newAspectData;
            int recordSize = this.aspectData.getRecordCount();
            if (recordSize == 0 && this.size() == 1) {
                ((AspectRow)this.getAspectRow(0)).setState(4);
            }
            for (int i = 0; i < recordSize; ++i) {
                AspectRow row;
                if (i == 0 && this.size() == 1) {
                    row = (AspectRow)this.getAspectRow(0);
                    row.setState(0);
                } else {
                    row = (AspectRow)this.createAspectRow(i);
                }
                this.extendKeyMap(row, (Key)row.getKey());
            }
            this.setState(0);
        }
        finally {
            CAFPublicLogger.exiting(null, (String)jARMRequest, (String)method, (Location)logger, (int)2);
        }
    }

    public boolean isValid() {
        return this.state != 4;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isFieldWiseChange() {
        String method = jARMRequest + ":isFieldWiseChange()";
        CAFPublicLogger.entering(null, (String)jARMRequest, (String)method, (Location)logger, (int)2);
        try {
            if (this.fieldWiseChange == null) {
                boolean rowWiseFlag = false;
                boolean fieldWiseFlag = false;
                try {
                    rowWiseFlag = this.descriptor.getAttributeRowwiseOperation();
                }
                catch (UnsupportedOperationException e) {
                    // empty catch block
                }
                try {
                    fieldWiseFlag = this.descriptor.getAttributeFieldwiseOperation();
                }
                catch (UnsupportedOperationException e) {
                    // empty catch block
                }
                this.fieldWiseChange = rowWiseFlag || !fieldWiseFlag ? Boolean.FALSE : Boolean.TRUE;
            }
            boolean bl = this.fieldWiseChange;
            return bl;
        }
        finally {
            CAFPublicLogger.exiting(null, (String)jARMRequest, (String)method, (Location)logger, (int)2);
        }
    }

    void setSourceAspectOfCreatingRelation(Aspect aspect) {
        this.sourceAspectOfCreatingRelation = aspect;
    }

    void setSourceAspectRowOfCreatingRelation(AspectRow aspectRow) {
        this.sourceAspectRowOfCreatingRelation = aspectRow;
    }

    public IValueSet createValueSet(String arg0) {
        return null;
    }

    public IAspect getRelatedAspect(String arg0, LockStrategy arg1, SortingCriteria arg2) {
        return this.getRelatedAspect(arg0, arg1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refresh() {
        String method = jARMRequest + ":refresh()";
        CAFPublicLogger.entering(null, (String)jARMRequest, (String)method, (Location)logger, (int)2);
        try {
            this.aspectChanges.reset();
            this.setState(1);
            this.aspectData.clear();
            this.aspectRows.clear();
            this.m_observableList.clear();
            this.aspectRowsMap.clear();
            this.loadAspectRows(this.m_originalKeyList, LockStrategy.SHARED_READ_ONLY);
            this.setState(0);
            Iterator i = this.m_relatedAspects.iterator();
            while (i.hasNext()) {
                ((IAspect)i.next()).refresh();
            }
        }
        catch (Exception e) {
            MessageFactory.createAndRegisterMessageFromException((Throwable)e, this, true);
        }
        finally {
            CAFPublicLogger.exiting(null, (String)jARMRequest, (String)method, (Location)logger, (int)2);
        }
    }

    public void setInvalidationHint(String arg0, int arg1) {
    }

    private void refreshAspectRow(IAspectRow row, IDataContainerBean dataBean) throws ServiceException {
        String method = jARMRequest + ":refreshAspectRow(IAspectRow, IDataContainerBean)";
        CAFPublicLogger.entering(null, (String)jARMRequest, (String)method, (Location)logger, (int)2);
        try {
            IStructureDescriptor desc = row.getAspect().getDescriptor().getStructure();
            IFieldDescriptor[] resultFields = desc.getFieldDescriptors();
            int size = resultFields.length;
            ((AspectRow)row).setAttributeValue(dataBean);
        }
        catch (Exception e) {
            throw new ServiceException("Error while refreshing aspect row. Please check module description and module implementation consistency.", null, (Throwable)e);
        }
        finally {
            CAFPublicLogger.exiting(null, (String)jARMRequest, (String)method, (Location)logger, (int)2);
        }
    }

    protected String getKeyAsString(IKey key) throws ServiceException {
        try {
            String strKey = key.toString();
            return strKey.substring(1, strKey.length() - 1);
        }
        catch (Exception ex) {
            throw new ServiceException((Throwable)ex);
        }
    }

    protected Collection getCollectionStringKeys() {
        HashSet<String> result = new HashSet<String>();
        for (int i = 0; i < this.size(); ++i) {
            String key = this.getAspectData().getStringValue(i, "key");
            if (key == null || "".equals(key)) continue;
            result.add(key);
        }
        return result;
    }

    protected Collection getCollectionValues(String propertyName) {
        ArrayList<Object> result = new ArrayList<Object>();
        for (int i = 0; i < this.size(); ++i) {
            Object value = this.getAspectData().getValue(i, propertyName);
            if (value == null) continue;
            result.add(value);
        }
        return result;
    }

    protected void addRelatedAspect(IAspect aspect) {
        if (this.m_relatedAspects.indexOf(aspect) < 0) {
            this.m_relatedAspects.add(aspect);
        }
    }

    protected boolean isWaitingForCommit() {
        return this.m_waitingCommit;
    }

    protected static synchronized void clearAspectWaitingStates() {
        Iterator i = m_aspects.iterator();
        while (i.hasNext()) {
            Aspect a = (Aspect)i.next();
            if (a == null) continue;
            a.m_waitingCommit = false;
            a.aspectChanges.commitChanges();
        }
    }

    protected static synchronized void setDirtyStateForChangedAspects() {
        Iterator i = m_aspects.iterator();
        while (i.hasNext()) {
            Aspect a = (Aspect)i.next();
            if (a == null || !a.m_waitingCommit) continue;
            a.m_waitingCommit = false;
            a.setState(2);
            a.aspectChanges.rollbackChanges();
        }
    }

    private static synchronized int cleanupList() {
        int result = 0;
        Iterator i = m_aspects.iterator();
        while (i.hasNext()) {
            if (i.next() != null) continue;
            i.remove();
            ++result;
        }
        return result;
    }

    public AspectRow getSourceAspectRowOfCreatingRelation() {
        return this.sourceAspectRowOfCreatingRelation;
    }

    public boolean isDirty() {
        Iterator i = this.aspectRows.iterator();
        while (i.hasNext()) {
            AspectRow row = (AspectRow)i.next();
            if (!row.isDirty()) continue;
            return true;
        }
        return !this.aspectChanges.getChangesState().isEmpty();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class WeakArrayList
    extends AbstractList {
        private List internalList;

        public WeakArrayList() {
            this.internalList = new ArrayList();
        }

        public WeakArrayList(int initialCapacity) {
            this.internalList = new ArrayList(initialCapacity);
        }

        public WeakArrayList(Collection c) {
            this.internalList = new ArrayList(c);
        }

        public int size() {
            return this.internalList.size();
        }

        public Object get(int index) {
            return ((WeakReference)this.internalList.get(index)).get();
        }

        public Object set(int index, Object element) {
            return this.internalList.set(index, new WeakReference<Object>(element)).get();
        }

        public Object remove(int index) {
            return ((WeakReference)this.internalList.remove(index)).get();
        }

        public boolean add(Object o) {
            return this.internalList.add(new WeakReference<Object>(o));
        }
    }

    private class LiveKeyList
    extends AbstractList
    implements IKeyList {
        private LiveKeyList() {
        }

        public IKeyAspectDescriptor getDescriptor() {
            return Aspect.this.getDescriptor().getKeyDescriptor();
        }

        public IKey getKey(int index) {
            return Aspect.this.getAspectRow(index).getKey();
        }

        public Object get(int index) {
            return this.getKey(index);
        }

        public int size() {
            return Aspect.this.size();
        }
    }
}

