/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.webdynpro.admin.statistic;

import com.sap.tc.webdynpro.admin.statistic.Statistic;

public class TimeStatistic
extends Statistic {
    protected long count = 0L;
    protected long minTime = Long.MAX_VALUE;
    protected long maxTime = Long.MIN_VALUE;
    protected long totalTime = 0L;
    public static final String MILLISECOND = "MILLISECOND";

    public TimeStatistic() {
        this.unit = MILLISECOND;
    }

    public void addSamples(long[] samples) {
        int i = 0;
        while (i < samples.length) {
            this.addSample(samples[i]);
            ++i;
        }
    }

    public void addSample(long sample) {
        ++this.count;
        if (sample < this.minTime) {
            this.minTime = sample;
        }
        if (sample > this.maxTime) {
            this.maxTime = sample;
        }
        this.totalTime += sample;
    }

    public long getCount() {
        return this.count;
    }

    public long getMaxTime() {
        return this.maxTime;
    }

    public long getMinTime() {
        return this.minTime;
    }

    public long getTotalTime() {
        return this.totalTime;
    }

    public void add(Statistic s) {
        super.add(s);
        if (s instanceof TimeStatistic) {
            TimeStatistic ts = (TimeStatistic)s;
            this.count += ts.getCount();
            if (ts.getMinTime() < this.minTime) {
                this.minTime = ts.getMinTime();
            }
            if (ts.getMaxTime() > this.maxTime) {
                this.maxTime = ts.getMaxTime();
            }
            this.totalTime += ts.getTotalTime();
        }
    }
}

