/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.webdynpro.admin.mbeans.performance;

import com.sap.tc.webdynpro.admin.mbeans.MBeanServerProxy;
import com.sap.tc.webdynpro.admin.mbeans.performance.ClientPerformanceMBean;
import com.sap.tc.webdynpro.admin.statistic.SampleBuffer;
import com.sap.tc.webdynpro.admin.statistic.Stats;
import com.sap.tc.webdynpro.admin.statistic.TimeStatistic;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.management.ObjectName;

public class ClientPerformance
implements ClientPerformanceMBean {
    private String clientInfo;
    private Stats stats;
    private Map statisticMap;
    private Map bufferMap;
    private static final String[] BUFFERNAME = new String[3];
    private static final int TRANSMISSION_TIME = 0;
    private static final int RESPONSE_TIME = 1;
    private static final int NAVIGATION_TIME = 2;
    private final int bufferSize;
    private final int halfSize;
    private static final long[] EMPTY_ARRAY = new long[0];

    public ClientPerformance(int aBufferSize) {
        ClientPerformance.BUFFERNAME[0] = "TransmissionTime";
        ClientPerformance.BUFFERNAME[1] = "ResponseTime";
        ClientPerformance.BUFFERNAME[2] = "NavigationTime";
        this.bufferSize = aBufferSize;
        this.halfSize = this.bufferSize / 2;
        this.statisticMap = new HashMap();
        this.bufferMap = new HashMap();
        int i = 0;
        while (i < BUFFERNAME.length) {
            TimeStatistic statistic = new TimeStatistic();
            statistic.setName(BUFFERNAME[i]);
            this.statisticMap.put(BUFFERNAME[i], statistic);
            this.bufferMap.put(BUFFERNAME[i], new SampleBuffer(this.bufferSize));
            ++i;
        }
    }

    public ClientPerformance() {
        this(50);
    }

    public String getClientInfo() {
        return this.clientInfo;
    }

    public Stats getStats() {
        String name;
        Iterator it;
        Set keySet;
        if (this.stats == null) {
            this.stats = new Stats();
            keySet = this.statisticMap.keySet();
            it = keySet.iterator();
            while (it.hasNext()) {
                name = (String)it.next();
                TimeStatistic statistic = (TimeStatistic)this.statisticMap.get(name);
                this.stats.addStatistic(statistic, name);
            }
        }
        keySet = this.statisticMap.keySet();
        it = keySet.iterator();
        while (it.hasNext()) {
            name = (String)it.next();
            SampleBuffer buffer = (SampleBuffer)this.bufferMap.get(name);
            if (buffer.getCurrentSize() <= 0) continue;
            TimeStatistic statistic = (TimeStatistic)this.statisticMap.get(name);
            statistic.addSamples(buffer.removeAllValues());
        }
        return this.stats;
    }

    private void addSample(int sampleType, long value) {
        SampleBuffer buffer = (SampleBuffer)this.bufferMap.get(BUFFERNAME[sampleType]);
        if (!buffer.add(value)) {
            long[] samples = buffer.removeValues(this.halfSize);
            TimeStatistic statistic = (TimeStatistic)this.statisticMap.get(BUFFERNAME[sampleType]);
            statistic.addSamples(samples);
            buffer.add(value);
        }
    }

    private long[] getLastSamples(int sampleType) {
        SampleBuffer buffer = (SampleBuffer)this.bufferMap.get(BUFFERNAME[sampleType]);
        if (buffer == null) {
            return EMPTY_ARRAY;
        }
        return buffer.getAllValues();
    }

    public void addLastResponseTime(long value) {
        this.addSample(1, value);
    }

    public void addLastTransmissionTime(long value) {
        this.addSample(0, value);
    }

    public void addLastNavigationTime(long value) {
        this.addSample(2, value);
    }

    public long[] getLastResponseTimeSamples() {
        return this.getLastSamples(1);
    }

    public long[] getLastTransmissionTimeSamples() {
        return this.getLastSamples(0);
    }

    public long[] getLastNavigationTimeSamples() {
        return this.getLastSamples(2);
    }

    public void setClientInfo(String clientInfo) {
        this.clientInfo = clientInfo;
    }

    public static ObjectName getObjectName(String id) {
        return MBeanServerProxy.getObjectName("ClientPerformance", id);
    }

    public static boolean isValidName(ObjectName name) {
        return MBeanServerProxy.hasCategory(name, "ClientPerformance");
    }
}

