/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.webdynpro.admin.mbeans.client;

import com.sap.tc.webdynpro.admin.mbeans.MBeanServerProxy;
import com.sap.tc.webdynpro.admin.mbeans.client.ClientPerformanceMBean;
import com.sap.tc.webdynpro.admin.statistic.SampleBuffer;
import com.sap.tc.webdynpro.admin.statistic.Stats;
import com.sap.tc.webdynpro.admin.statistic.TimeStatistic;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.management.ObjectName;

public class ClientPerformance
implements ClientPerformanceMBean {
    private String clientType = "";
    private Stats stats = null;
    private Map statisticMap = new HashMap();
    private Map bufferMap = new HashMap();
    private final int bufferSize = 50;
    private final int halfSize = 25;
    private static final long[] EMPTY_ARRAY = new long[0];

    public ClientPerformance(String aClientType) {
        this.clientType = aClientType;
    }

    public void addSample(String sampleType, long value) {
        SampleBuffer buffer = this.getSampleBuffer(sampleType);
        if (!buffer.add(value)) {
            long[] samples = buffer.removeValues(25);
            TimeStatistic statistic = this.getTimeStatistic(sampleType);
            statistic.addSamples(samples);
            buffer.add(value);
        }
    }

    public String getClientType() {
        return this.clientType;
    }

    public Stats getStats() {
        int i;
        String[] sampleTypes = this.getSampleTypes();
        if (this.stats == null) {
            this.stats = new Stats();
            i = 0;
            while (i < sampleTypes.length) {
                TimeStatistic statistic = this.getTimeStatistic(sampleTypes[i]);
                this.stats.addStatistic(statistic, sampleTypes[i]);
                ++i;
            }
        }
        i = 0;
        while (i < sampleTypes.length) {
            SampleBuffer buffer = (SampleBuffer)this.bufferMap.get(sampleTypes[i]);
            if (buffer.getCurrentSize() > 0) {
                TimeStatistic statistic = (TimeStatistic)this.statisticMap.get(sampleTypes[i]);
                statistic.addSamples(buffer.removeAllValues());
            }
            ++i;
        }
        return this.stats;
    }

    public String[] getSampleTypes() {
        Set keySet = this.bufferMap.keySet();
        String[] sampleTypes = new String[keySet.size()];
        int i = 0;
        Iterator iter = keySet.iterator();
        while (iter.hasNext()) {
            String name = (String)iter.next();
            sampleTypes[i++] = name;
        }
        return sampleTypes;
    }

    public long[] getLastSamples(String sampleType) {
        long[] samples = EMPTY_ARRAY;
        if (this.bufferMap.containsKey(sampleType)) {
            SampleBuffer buffer = (SampleBuffer)this.bufferMap.get(sampleType);
            samples = buffer.getAllValues();
        }
        return samples;
    }

    private SampleBuffer getSampleBuffer(String sampleType) {
        SampleBuffer buffer = (SampleBuffer)this.bufferMap.get(sampleType);
        if (buffer == null) {
            buffer = new SampleBuffer(50);
            this.bufferMap.put(sampleType, buffer);
        }
        return buffer;
    }

    private TimeStatistic getTimeStatistic(String sampleType) {
        TimeStatistic timeStatistic = (TimeStatistic)this.statisticMap.get(sampleType);
        if (timeStatistic == null) {
            timeStatistic = new TimeStatistic();
            this.statisticMap.put(sampleType, timeStatistic);
        }
        return timeStatistic;
    }

    public static ObjectName getObjectName(String id) {
        return MBeanServerProxy.getObjectName("ClientPerformance", id);
    }

    public static boolean isValidName(ObjectName name) {
        return MBeanServerProxy.hasCategory(name, "ClientPerformance");
    }
}

