/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.junit.util;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.ISourceReference;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeHierarchy;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.search.IJavaSearchResultCollector;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.ISearchPattern;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.internal.junit.ui.JUnitMessages;
import org.eclipse.jdt.internal.junit.ui.JUnitPlugin;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.ui.IFileEditorInput;

public class TestSearchEngine {
    private List searchMethod(IProgressMonitor pm, IJavaSearchScope scope) throws JavaModelException {
        ArrayList typesFound = new ArrayList(200);
        this.searchMethod(typesFound, scope, pm);
        return typesFound;
    }

    private List searchMethod(List v, IJavaSearchScope scope, IProgressMonitor progressMonitor) throws JavaModelException {
        JUnitSearchResultCollector collector = new JUnitSearchResultCollector(v, progressMonitor);
        ISearchPattern suitePattern = SearchEngine.createSearchPattern((String)"suite() Test", (int)1, (int)0, (boolean)true);
        ISearchPattern testPattern = SearchEngine.createSearchPattern((String)"test*() void", (int)1, (int)0, (boolean)true);
        SearchEngine engine = new SearchEngine();
        engine.search(ResourcesPlugin.getWorkspace(), SearchEngine.createOrSearchPattern((ISearchPattern)suitePattern, (ISearchPattern)testPattern), scope, (IJavaSearchResultCollector)collector);
        return v;
    }

    public static IType[] findTests(IRunnableContext context, final Object[] elements) throws InvocationTargetException, InterruptedException {
        final HashSet result = new HashSet();
        if (elements.length > 0) {
            IRunnableWithProgress runnable = new IRunnableWithProgress(){

                public void run(IProgressMonitor pm) throws InterruptedException {
                    TestSearchEngine.doFindTests(elements, result, pm);
                }
            };
            context.run(true, true, runnable);
        }
        return result.toArray(new IType[result.size()]);
    }

    public static void doFindTests(Object[] elements, Set result, IProgressMonitor pm) throws InterruptedException {
        int nElements = elements.length;
        pm.beginTask(JUnitMessages.getString("TestSearchEngine.message.searching"), nElements);
        try {
            int i = 0;
            while (i < nElements) {
                try {
                    TestSearchEngine.collectTypes(elements[i], (IProgressMonitor)new SubProgressMonitor(pm, 1), result);
                }
                catch (JavaModelException e) {
                    JUnitPlugin.log(e.getStatus());
                }
                if (pm.isCanceled()) {
                    throw new InterruptedException();
                }
                ++i;
            }
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            pm.done();
            throw throwable;
        }
        Object var6_8 = null;
        pm.done();
    }

    private static void collectTypes(Object element, IProgressMonitor pm, Set result) throws JavaModelException {
        element = TestSearchEngine.computeScope(element);
        while (element instanceof IJavaElement && !(element instanceof ICompilationUnit) && element instanceof ISourceReference) {
            if (element instanceof IType && (TestSearchEngine.hasSuiteMethod((IType)element) || TestSearchEngine.isTestType((IType)element))) {
                result.add(element);
                return;
            }
            element = ((IJavaElement)element).getParent();
        }
        if (element instanceof ICompilationUnit) {
            ICompilationUnit cu = (ICompilationUnit)element;
            IType[] types = cu.getAllTypes();
            int i = 0;
            while (i < types.length) {
                if (TestSearchEngine.hasSuiteMethod(types[i]) || TestSearchEngine.isTestType(types[i])) {
                    result.add(types[i]);
                }
                ++i;
            }
        } else if (element instanceof IJavaElement) {
            List found = TestSearchEngine.searchSuiteMethods(pm, (IJavaElement)element);
            result.addAll(found);
        }
    }

    private static Object computeScope(Object element) throws JavaModelException {
        if (element instanceof IFileEditorInput) {
            element = ((IFileEditorInput)element).getFile();
        }
        if (element instanceof IResource) {
            element = JavaCore.create((IResource)((IResource)element));
        }
        if (element instanceof IClassFile) {
            IClassFile cf = (IClassFile)element;
            element = cf.getType();
        }
        return element;
    }

    private static List searchSuiteMethods(IProgressMonitor pm, IJavaElement element) throws JavaModelException {
        IJavaSearchScope scope = SearchEngine.createJavaSearchScope((IJavaElement[])new IJavaElement[]{element});
        TestSearchEngine searchEngine = new TestSearchEngine();
        return searchEngine.searchMethod(pm, scope);
    }

    private static boolean hasSuiteMethod(IType type) throws JavaModelException {
        IMethod method = type.getMethod("suite", new String[0]);
        if (method == null || !method.exists()) {
            return false;
        }
        return Flags.isStatic((int)method.getFlags()) && Flags.isPublic((int)method.getFlags()) && Flags.isPublic((int)method.getDeclaringType().getFlags());
    }

    private static boolean isTestType(IType type) throws JavaModelException {
        if (Flags.isAbstract((int)type.getFlags())) {
            return false;
        }
        if (!Flags.isPublic((int)type.getFlags())) {
            return false;
        }
        IType[] interfaces = type.newSupertypeHierarchy(null).getAllSuperInterfaces(type);
        int i = 0;
        while (i < interfaces.length) {
            if (interfaces[i].getFullyQualifiedName().equals("junit.framework.Test")) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static boolean isTestImplementor(IType type) throws JavaModelException {
        ITypeHierarchy typeHier = type.newSupertypeHierarchy(null);
        IType[] superInterfaces = typeHier.getAllInterfaces();
        int i = 0;
        while (i < superInterfaces.length) {
            if (superInterfaces[i].getFullyQualifiedName().equals("junit.framework.Test")) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private class JUnitSearchResultCollector
    implements IJavaSearchResultCollector {
        IProgressMonitor fProgressMonitor;
        List fList;
        Set fFailed = new HashSet();
        Set fMatches = new HashSet();

        public JUnitSearchResultCollector(List list, IProgressMonitor progressMonitor) {
            this.fProgressMonitor = progressMonitor;
            this.fList = list;
        }

        public void accept(IResource resource, int start, int end, IJavaElement enclosingElement, int accuracy) throws JavaModelException {
            if (!(enclosingElement instanceof IMethod)) {
                return;
            }
            IMethod method = (IMethod)enclosingElement;
            IType declaringType = method.getDeclaringType();
            if (this.fMatches.contains(declaringType) || this.fFailed.contains(declaringType)) {
                return;
            }
            if (!TestSearchEngine.hasSuiteMethod(declaringType) && !TestSearchEngine.isTestType(declaringType)) {
                this.fFailed.add(declaringType);
                return;
            }
            this.fMatches.add(declaringType);
        }

        public IProgressMonitor getProgressMonitor() {
            return this.fProgressMonitor;
        }

        public void aboutToStart() {
        }

        public void done() {
            this.fList.addAll(this.fMatches);
        }
    }
}

