/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.junit.ui;

import java.net.MalformedURLException;
import java.net.URL;
import java.text.NumberFormat;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.jdt.core.ElementChangedEvent;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IElementChangedListener;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaElementDelta;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.internal.junit.ui.CopyTraceAction;
import org.eclipse.jdt.internal.junit.ui.CounterPanel;
import org.eclipse.jdt.internal.junit.ui.EnableStackFilterAction;
import org.eclipse.jdt.internal.junit.ui.FailureRunView;
import org.eclipse.jdt.internal.junit.ui.FailureTraceView;
import org.eclipse.jdt.internal.junit.ui.HierarchyRunView;
import org.eclipse.jdt.internal.junit.ui.ITestRunListener2;
import org.eclipse.jdt.internal.junit.ui.ITestRunView;
import org.eclipse.jdt.internal.junit.ui.JUnitMessages;
import org.eclipse.jdt.internal.junit.ui.JUnitPlugin;
import org.eclipse.jdt.internal.junit.ui.JUnitPreferencePage;
import org.eclipse.jdt.internal.junit.ui.JUnitProgressBar;
import org.eclipse.jdt.internal.junit.ui.ProgressImages;
import org.eclipse.jdt.internal.junit.ui.RemoteTestRunnerClient;
import org.eclipse.jdt.internal.junit.ui.TabFolderLayout;
import org.eclipse.jdt.internal.junit.ui.TestRunInfo;
import org.eclipse.jdt.junit.ITestRunListener;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.custom.ViewForm;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorActionBarContributor;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.help.WorkbenchHelp;
import org.eclipse.ui.part.EditorActionBarContributor;
import org.eclipse.ui.part.ViewPart;

public class TestRunnerViewPart
extends ViewPart
implements ITestRunListener2,
IPropertyChangeListener {
    public static final String NAME = "org.eclipse.jdt.junit.ResultView";
    protected int fExecutedTests;
    protected int fErrors;
    protected int fFailures;
    private int fTestCount;
    private Map fTestInfos = new HashMap();
    private TestRunInfo fFirstFailure;
    private JUnitProgressBar fProgressBar;
    private ProgressImages fProgressImages;
    private Image fViewImage;
    private CounterPanel fCounterPanel;
    private boolean fShowOnErrorOnly = false;
    private Clipboard fClipboard;
    private FailureTraceView fFailureView;
    private Vector fTestRunViews = new Vector();
    private ITestRunView fActiveRunView;
    private boolean fIsDisposed = false;
    private IJavaProject fTestProject;
    private String fLaunchMode;
    private ILaunch fLastLaunch = null;
    private Action fRerunLastTestAction;
    private RemoteTestRunnerClient fTestRunnerClient;
    final Image fStackViewIcon = TestRunnerViewPart.createImage("cview16/stackframe.gif");
    final Image fTestRunOKIcon = TestRunnerViewPart.createImage("cview16/junitsucc.gif");
    final Image fTestRunFailIcon = TestRunnerViewPart.createImage("cview16/juniterr.gif");
    final Image fTestRunOKDirtyIcon = TestRunnerViewPart.createImage("cview16/junitsuccq.gif");
    final Image fTestRunFailDirtyIcon = TestRunnerViewPart.createImage("cview16/juniterrq.gif");
    Image fOriginalViewImage = null;
    IElementChangedListener fDirtyListener = null;

    public void stopTest() {
        if (this.fTestRunnerClient != null) {
            this.fTestRunnerClient.stopTest();
        }
    }

    public void rerunTestRun() {
        if (this.fLastLaunch != null && this.fLastLaunch.getLaunchConfiguration() != null) {
            try {
                DebugUITools.saveAndBuildBeforeLaunch();
                this.fLastLaunch.getLaunchConfiguration().launch(this.fLastLaunch.getLaunchMode(), null);
            }
            catch (CoreException e) {
                ErrorDialog.openError((Shell)this.getSite().getShell(), (String)JUnitMessages.getString("TestRunnerViewPart.error.cannotrerun"), (String)e.getMessage(), (IStatus)e.getStatus());
            }
        }
    }

    public void testRunStarted(int testCount) {
        this.reset(testCount);
        this.fShowOnErrorOnly = JUnitPreferencePage.getShowOnErrorOnly();
        ++this.fExecutedTests;
    }

    public void reset() {
        this.reset(0);
        this.setViewPartTitle(null);
        this.clearStatus();
        this.resetViewIcon();
    }

    public void testRunEnded(long elapsedTime) {
        --this.fExecutedTests;
        Object[] keys = new String[]{this.elapsedTimeAsString(elapsedTime), String.valueOf(this.fErrors), String.valueOf(this.fFailures)};
        String msg = JUnitMessages.getFormattedString("TestRunnerViewPart.message.finish", keys);
        if (this.hasErrorsOrFailures()) {
            this.postError(msg);
        } else {
            this.postInfo(msg);
        }
        this.postAsyncRunnable(new Runnable(){

            public void run() {
                if (TestRunnerViewPart.this.isDisposed()) {
                    return;
                }
                if (TestRunnerViewPart.this.fFirstFailure != null) {
                    TestRunnerViewPart.this.fActiveRunView.setSelectedTest(TestRunnerViewPart.this.fFirstFailure.getTestId());
                    TestRunnerViewPart.this.handleTestSelected(TestRunnerViewPart.this.fFirstFailure.getTestId());
                }
                TestRunnerViewPart.this.updateViewIcon();
                if (TestRunnerViewPart.this.fDirtyListener == null) {
                    TestRunnerViewPart.this.fDirtyListener = new DirtyListener();
                    JavaCore.addElementChangedListener((IElementChangedListener)TestRunnerViewPart.this.fDirtyListener);
                }
            }
        });
    }

    private void updateViewIcon() {
        this.fViewImage = this.hasErrorsOrFailures() ? this.fTestRunFailIcon : this.fTestRunOKIcon;
        this.firePropertyChange(1);
    }

    private boolean hasErrorsOrFailures() {
        return this.fErrors + this.fFailures > 0;
    }

    private String elapsedTimeAsString(long runTime) {
        return NumberFormat.getInstance().format((double)runTime / 1000.0);
    }

    public void testRunStopped(long elapsedTime) {
        String msg = JUnitMessages.getFormattedString("TestRunnerViewPart.message.stopped", this.elapsedTimeAsString(elapsedTime));
        this.postInfo(msg);
        this.postAsyncRunnable(new Runnable(){

            public void run() {
                if (TestRunnerViewPart.this.isDisposed()) {
                    return;
                }
                TestRunnerViewPart.this.resetViewIcon();
            }
        });
    }

    private void resetViewIcon() {
        this.fViewImage = this.fOriginalViewImage;
        this.firePropertyChange(1);
    }

    public void testRunTerminated() {
        String msg = JUnitMessages.getString("TestRunnerViewPart.message.terminated");
        this.showMessage(msg);
    }

    private void showMessage(String msg) {
        this.showInformation(msg);
        this.postError(msg);
    }

    public void testStarted(String testId, String testName) {
        if (!this.fShowOnErrorOnly && this.fExecutedTests == 1) {
            this.postShowTestResultsView();
        }
        this.postInfo(JUnitMessages.getFormattedString("TestRunnerViewPart.message.started", testName));
        TestRunInfo testInfo = this.getTestInfo(testId);
        if (testInfo == null) {
            this.fTestInfos.put(testId, new TestRunInfo(testId, testName));
        }
    }

    public void testEnded(String testId, String testName) {
        this.postEndTest(testId, testName);
        ++this.fExecutedTests;
    }

    public void testFailed(int status, String testId, String testName, String trace) {
        TestRunInfo testInfo = this.getTestInfo(testId);
        if (testInfo == null) {
            testInfo = new TestRunInfo(testId, testName);
            this.fTestInfos.put(testName, testInfo);
        }
        testInfo.setTrace(trace);
        testInfo.setStatus(status);
        if (status == 1) {
            ++this.fErrors;
        } else {
            ++this.fFailures;
        }
        if (this.fFirstFailure == null) {
            this.fFirstFailure = testInfo;
        }
        if (this.fShowOnErrorOnly && this.fErrors + this.fFailures == 1) {
            this.postShowTestResultsView();
        }
    }

    public void testReran(String testId, String className, String testName, int status, String trace) {
        String msg;
        if (status == 1) {
            msg = JUnitMessages.getFormattedString("TestRunnerViewPart.message.error", new String[]{testName, className});
            this.postError(msg);
        } else if (status == 2) {
            msg = JUnitMessages.getFormattedString("TestRunnerViewPart.message.failure", new String[]{testName, className});
            this.postError(msg);
        } else {
            msg = JUnitMessages.getFormattedString("TestRunnerViewPart.message.success", new String[]{testName, className});
            this.postInfo(msg);
        }
        TestRunInfo info = this.getTestInfo(testId);
        this.updateTest(info, status);
        if (info.getTrace() == null || !info.getTrace().equals(trace)) {
            info.setTrace(trace);
            this.showFailure(info.getTrace());
        }
    }

    private void updateTest(TestRunInfo info, int status) {
        if (status == info.getStatus()) {
            return;
        }
        if (info.getStatus() == 0) {
            if (status == 2) {
                ++this.fFailures;
            } else if (status == 1) {
                ++this.fErrors;
            }
        } else if (info.getStatus() == 1) {
            if (status == 0) {
                --this.fErrors;
            } else if (status == 2) {
                --this.fErrors;
                ++this.fFailures;
            }
        } else if (info.getStatus() == 2) {
            if (status == 0) {
                --this.fFailures;
            } else if (status == 1) {
                --this.fFailures;
                ++this.fErrors;
            }
        }
        info.setStatus(status);
        final TestRunInfo finalInfo = info;
        this.postAsyncRunnable(new Runnable(){

            public void run() {
                TestRunnerViewPart.this.refreshCounters();
                Enumeration e = TestRunnerViewPart.this.fTestRunViews.elements();
                while (e.hasMoreElements()) {
                    ITestRunView v = (ITestRunView)e.nextElement();
                    v.testStatusChanged(finalInfo);
                }
            }
        });
    }

    public void testTreeEntry(final String treeEntry) {
        this.postSyncRunnable(new Runnable(){

            public void run() {
                if (TestRunnerViewPart.this.isDisposed()) {
                    return;
                }
                Enumeration e = TestRunnerViewPart.this.fTestRunViews.elements();
                while (e.hasMoreElements()) {
                    ITestRunView v = (ITestRunView)e.nextElement();
                    v.newTreeEntry(treeEntry);
                }
            }
        });
    }

    public void startTestRunListening(IJavaElement type, int port, ILaunch launch) {
        this.fTestProject = type.getJavaProject();
        this.fLaunchMode = launch.getLaunchMode();
        this.aboutToLaunch();
        if (this.fTestRunnerClient != null) {
            this.stopTest();
        }
        this.fTestRunnerClient = new RemoteTestRunnerClient();
        Vector listeners = JUnitPlugin.getDefault().getTestRunListeners();
        Object[] listenerArray = new ITestRunListener[listeners.size() + 1];
        listeners.copyInto(listenerArray);
        System.arraycopy(listenerArray, 0, listenerArray, 1, listenerArray.length - 1);
        listenerArray[0] = this;
        this.fTestRunnerClient.startListening((ITestRunListener[])listenerArray, port);
        this.fLastLaunch = launch;
        this.setViewPartTitle(type);
        if (type instanceof IType) {
            this.setTitleToolTip(((IType)type).getFullyQualifiedName());
        } else {
            this.setTitleToolTip(type.getElementName());
        }
    }

    private void setViewPartTitle(IJavaElement type) {
        String title = type == null ? JUnitMessages.getString("TestRunnerViewPart.title_no_type") : JUnitMessages.getFormattedString("TestRunnerViewPart.title", type.getElementName());
        this.setTitle(title);
    }

    private void aboutToLaunch() {
        String msg = JUnitMessages.getString("TestRunnerViewPart.message.launching");
        this.showInformation(msg);
        this.postInfo(msg);
        this.fViewImage = this.fOriginalViewImage;
        this.firePropertyChange(1);
    }

    public synchronized void dispose() {
        this.fIsDisposed = true;
        this.stopTest();
        if (this.fProgressImages != null) {
            this.fProgressImages.dispose();
        }
        JUnitPlugin.getDefault().getPreferenceStore().removePropertyChangeListener((IPropertyChangeListener)this);
        this.fTestRunOKIcon.dispose();
        this.fTestRunFailIcon.dispose();
        this.fStackViewIcon.dispose();
        this.fTestRunOKDirtyIcon.dispose();
        this.fTestRunFailDirtyIcon.dispose();
        if (this.fClipboard != null) {
            this.fClipboard.dispose();
        }
    }

    private void start(int total) {
        this.resetProgressBar(total);
        this.fCounterPanel.setTotal(total);
        this.fCounterPanel.setRunValue(0);
    }

    private void resetProgressBar(int total) {
        this.fProgressBar.reset();
        this.fProgressBar.setMaximum(total);
    }

    private void postSyncRunnable(Runnable r) {
        if (!this.isDisposed()) {
            this.getDisplay().syncExec(r);
        }
    }

    private void postAsyncRunnable(Runnable r) {
        if (!this.isDisposed()) {
            this.getDisplay().syncExec(r);
        }
    }

    private void aboutToStart() {
        this.postSyncRunnable(new Runnable(){

            public void run() {
                if (!TestRunnerViewPart.this.isDisposed()) {
                    Enumeration e = TestRunnerViewPart.this.fTestRunViews.elements();
                    while (e.hasMoreElements()) {
                        ITestRunView v = (ITestRunView)e.nextElement();
                        v.aboutToStart();
                    }
                }
            }
        });
    }

    private void postEndTest(final String testId, String testName) {
        this.postSyncRunnable(new Runnable(){

            public void run() {
                if (TestRunnerViewPart.this.isDisposed()) {
                    return;
                }
                TestRunnerViewPart.this.handleEndTest();
                Enumeration e = TestRunnerViewPart.this.fTestRunViews.elements();
                while (e.hasMoreElements()) {
                    ITestRunView v = (ITestRunView)e.nextElement();
                    v.endTest(testId);
                }
            }
        });
    }

    private void handleEndTest() {
        Image progress;
        this.refreshCounters();
        this.fProgressBar.step(this.fFailures + this.fErrors);
        if (this.fShowOnErrorOnly && (progress = this.fProgressImages.getImage(this.fExecutedTests, this.fTestCount, this.fErrors, this.fFailures)) != this.fViewImage) {
            this.fViewImage = progress;
            this.firePropertyChange(1);
        }
    }

    private void refreshCounters() {
        this.fCounterPanel.setErrorValue(this.fErrors);
        this.fCounterPanel.setFailureValue(this.fFailures);
        this.fCounterPanel.setRunValue(this.fExecutedTests);
        this.fProgressBar.refresh(this.fErrors + this.fFailures > 0);
    }

    protected void postShowTestResultsView() {
        this.postAsyncRunnable(new Runnable(){

            public void run() {
                if (TestRunnerViewPart.this.isDisposed()) {
                    return;
                }
                TestRunnerViewPart.this.showTestResultsView();
            }
        });
    }

    public void showTestResultsView() {
        IWorkbenchWindow window = this.getSite().getWorkbenchWindow();
        IWorkbenchPage page = window.getActivePage();
        TestRunnerViewPart testRunner = null;
        if (page != null) {
            try {
                testRunner = (TestRunnerViewPart)page.findView(NAME);
                if (testRunner == null) {
                    IWorkbenchPart activePart = page.getActivePart();
                    testRunner = (TestRunnerViewPart)page.showView(NAME);
                    page.activate(activePart);
                } else {
                    page.bringToTop((IWorkbenchPart)testRunner);
                }
            }
            catch (PartInitException pie) {
                JUnitPlugin.log(pie);
            }
        }
    }

    protected void postInfo(final String message) {
        this.postAsyncRunnable(new Runnable(){

            public void run() {
                if (TestRunnerViewPart.this.isDisposed()) {
                    return;
                }
                TestRunnerViewPart.this.getStatusLine().setErrorMessage(null);
                TestRunnerViewPart.this.getStatusLine().setMessage(message);
            }
        });
    }

    protected void postError(final String message) {
        this.postAsyncRunnable(new Runnable(){

            public void run() {
                if (TestRunnerViewPart.this.isDisposed()) {
                    return;
                }
                TestRunnerViewPart.this.getStatusLine().setMessage(null);
                TestRunnerViewPart.this.getStatusLine().setErrorMessage(message);
            }
        });
    }

    protected void showInformation(final String info) {
        this.postSyncRunnable(new Runnable(){

            public void run() {
                if (!TestRunnerViewPart.this.isDisposed()) {
                    TestRunnerViewPart.this.fFailureView.setInformation(info);
                }
            }
        });
    }

    private CTabFolder createTestRunViews(Composite parent) {
        CTabFolder tabFolder = new CTabFolder(parent, 128);
        tabFolder.setLayoutData((Object)new GridData(1808));
        FailureRunView failureRunView = new FailureRunView(tabFolder, this);
        HierarchyRunView testHierarchyRunView = new HierarchyRunView(tabFolder, this);
        this.fTestRunViews.addElement(failureRunView);
        this.fTestRunViews.addElement(testHierarchyRunView);
        tabFolder.setSelection(0);
        this.fActiveRunView = (ITestRunView)this.fTestRunViews.firstElement();
        tabFolder.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                TestRunnerViewPart.this.testViewChanged(event);
            }
        });
        return tabFolder;
    }

    private void testViewChanged(SelectionEvent event) {
        Enumeration e = this.fTestRunViews.elements();
        while (e.hasMoreElements()) {
            ITestRunView v = (ITestRunView)e.nextElement();
            if (((CTabFolder)event.widget).getSelection().getText() != v.getName()) continue;
            v.setSelectedTest(this.fActiveRunView.getSelectedTestId());
            this.fActiveRunView = v;
            this.fActiveRunView.activate();
        }
    }

    private SashForm createSashForm(Composite parent) {
        SashForm sashForm = new SashForm(parent, 512);
        ViewForm top = new ViewForm((Composite)sashForm, 0);
        CTabFolder tabFolder = this.createTestRunViews((Composite)top);
        tabFolder.setLayoutData((Object)new TabFolderLayout());
        top.setContent((Control)tabFolder);
        ViewForm bottom = new ViewForm((Composite)sashForm, 0);
        ToolBar failureToolBar = new ToolBar((Composite)bottom, 0x800040);
        bottom.setTopCenter((Control)failureToolBar);
        this.fFailureView = new FailureTraceView((Composite)bottom, this, this.fClipboard);
        bottom.setContent((Control)this.fFailureView.getComposite());
        CLabel label = new CLabel((Composite)bottom, 0);
        label.setText(JUnitMessages.getString("TestRunnerViewPart.label.failure"));
        label.setImage(this.fStackViewIcon);
        bottom.setTopLeft((Control)label);
        ToolBarManager failureToolBarmanager = new ToolBarManager(failureToolBar);
        failureToolBarmanager.add((IAction)new EnableStackFilterAction(this.fFailureView));
        failureToolBarmanager.update(true);
        sashForm.setWeights(new int[]{50, 50});
        return sashForm;
    }

    private void reset(final int testCount) {
        this.postAsyncRunnable(new Runnable(){

            public void run() {
                if (TestRunnerViewPart.this.isDisposed()) {
                    return;
                }
                TestRunnerViewPart.this.fCounterPanel.reset();
                TestRunnerViewPart.this.fFailureView.clear();
                TestRunnerViewPart.this.fProgressBar.reset();
                TestRunnerViewPart.this.clearStatus();
                TestRunnerViewPart.this.start(testCount);
            }
        });
        this.fExecutedTests = 0;
        this.fFailures = 0;
        this.fErrors = 0;
        this.fTestCount = testCount;
        this.aboutToStart();
        this.fTestInfos.clear();
        this.fFirstFailure = null;
    }

    private void clearStatus() {
        this.getStatusLine().setMessage(null);
        this.getStatusLine().setErrorMessage(null);
    }

    public void setFocus() {
        if (this.fActiveRunView != null) {
            this.fActiveRunView.setFocus();
        }
    }

    public void createPartControl(Composite parent) {
        this.fClipboard = new Clipboard(parent.getDisplay());
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginWidth = 0;
        parent.setLayout((Layout)gridLayout);
        IActionBars actionBars = this.getViewSite().getActionBars();
        IToolBarManager toolBar = actionBars.getToolBarManager();
        this.fRerunLastTestAction = new RerunLastAction();
        this.fRerunLastTestAction.setActionDefinitionId("org.eclipse.jdt.junit.reruntest");
        toolBar.add((IAction)new StopAction());
        toolBar.add((IAction)this.fRerunLastTestAction);
        actionBars.updateActionBars();
        Composite counterPanel = this.createProgressCountPanel(parent);
        counterPanel.setLayoutData((Object)new GridData(768));
        SashForm sashForm = this.createSashForm(parent);
        sashForm.setLayoutData((Object)new GridData(1808));
        actionBars.setGlobalActionHandler("copy", (IAction)new CopyTraceAction(this.fFailureView, this.fClipboard));
        JUnitPlugin.getDefault().getPreferenceStore().addPropertyChangeListener((IPropertyChangeListener)this);
        this.fOriginalViewImage = this.getTitleImage();
        this.fProgressImages = new ProgressImages();
        WorkbenchHelp.setHelp((Control)parent, (String)"org.eclipse.jdt.junit.results_view_context");
    }

    private IStatusLineManager getStatusLine() {
        IEditorPart activeEditorPart;
        IEditorActionBarContributor contributor;
        IViewSite site = this.getViewSite();
        IWorkbenchPage page = site.getPage();
        IWorkbenchPart activePart = page.getActivePart();
        if (activePart instanceof IViewPart) {
            IViewPart activeViewPart = (IViewPart)activePart;
            IViewSite activeViewSite = activeViewPart.getViewSite();
            return activeViewSite.getActionBars().getStatusLineManager();
        }
        if (activePart instanceof IEditorPart && (contributor = (activeEditorPart = (IEditorPart)activePart).getEditorSite().getActionBarContributor()) instanceof EditorActionBarContributor) {
            return ((EditorActionBarContributor)contributor).getActionBars().getStatusLineManager();
        }
        return this.getViewSite().getActionBars().getStatusLineManager();
    }

    private Composite createProgressCountPanel(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout());
        this.fProgressBar = new JUnitProgressBar(composite);
        this.fProgressBar.setLayoutData(new GridData(768));
        this.fCounterPanel = new CounterPanel(composite);
        this.fCounterPanel.setLayoutData(new GridData(768));
        return composite;
    }

    public TestRunInfo getTestInfo(String testId) {
        if (testId == null) {
            return null;
        }
        return (TestRunInfo)this.fTestInfos.get(testId);
    }

    public void handleTestSelected(String testId) {
        TestRunInfo testInfo = this.getTestInfo(testId);
        if (testInfo == null) {
            this.showFailure("");
        } else {
            this.showFailure(testInfo.getTrace());
        }
    }

    private void showFailure(final String failure) {
        this.postSyncRunnable(new Runnable(){

            public void run() {
                if (!TestRunnerViewPart.this.isDisposed()) {
                    TestRunnerViewPart.this.fFailureView.showFailure(failure);
                }
            }
        });
    }

    public IJavaProject getLaunchedProject() {
        return this.fTestProject;
    }

    public ILaunch getLastLaunch() {
        return this.fLastLaunch;
    }

    protected static Image createImage(String path) {
        try {
            ImageDescriptor id = ImageDescriptor.createFromURL((URL)JUnitPlugin.makeIconFileURL(path));
            return id.createImage();
        }
        catch (MalformedURLException malformedURLException) {
            return null;
        }
    }

    private boolean isDisposed() {
        return this.fIsDisposed || this.fCounterPanel.isDisposed();
    }

    private Display getDisplay() {
        return this.getViewSite().getShell().getDisplay();
    }

    public Image getTitleImage() {
        if (this.fOriginalViewImage == null) {
            this.fOriginalViewImage = super.getTitleImage();
        }
        if (this.fViewImage == null) {
            return super.getTitleImage();
        }
        return this.fViewImage;
    }

    public void propertyChange(PropertyChangeEvent event) {
        if (this.isDisposed()) {
            return;
        }
        if ("org.eclipse.jdt.junit.show_on_error".equals(event.getProperty()) && !JUnitPreferencePage.getShowOnErrorOnly()) {
            this.fViewImage = this.fOriginalViewImage;
            this.firePropertyChange(1);
        }
    }

    void codeHasChanged() {
        this.postAsyncRunnable(new Runnable(){

            public void run() {
                if (TestRunnerViewPart.this.isDisposed()) {
                    return;
                }
                if (TestRunnerViewPart.this.fDirtyListener != null) {
                    JavaCore.removeElementChangedListener((IElementChangedListener)TestRunnerViewPart.this.fDirtyListener);
                    TestRunnerViewPart.this.fDirtyListener = null;
                }
                if (TestRunnerViewPart.this.fViewImage == TestRunnerViewPart.this.fTestRunOKIcon) {
                    TestRunnerViewPart.this.fViewImage = TestRunnerViewPart.this.fTestRunOKDirtyIcon;
                } else if (TestRunnerViewPart.this.fViewImage == TestRunnerViewPart.this.fTestRunFailIcon) {
                    TestRunnerViewPart.this.fViewImage = TestRunnerViewPart.this.fTestRunFailDirtyIcon;
                }
                TestRunnerViewPart.this.firePropertyChange(1);
            }
        });
    }

    boolean isCreated() {
        return this.fCounterPanel != null;
    }

    public void rerunTest(String testId, String className, String testName) {
        DebugUITools.saveAndBuildBeforeLaunch();
        if (this.fTestRunnerClient != null && this.fTestRunnerClient.isRunning() && "debug".equals(this.fLaunchMode)) {
            this.fTestRunnerClient.rerunTest(testId, className, testName);
        } else if (this.fLastLaunch != null) {
            ILaunchConfiguration launchConfiguration = this.fLastLaunch.getLaunchConfiguration();
            if (launchConfiguration != null) {
                try {
                    ILaunchConfigurationWorkingCopy tmp = launchConfiguration.copy("Rerun " + testName);
                    tmp.setAttribute("org.eclipse.jdt.junit.TESTNAME", testName);
                    tmp.launch(this.fLastLaunch.getLaunchMode(), null);
                    return;
                }
                catch (CoreException e) {
                    ErrorDialog.openError((Shell)this.getSite().getShell(), (String)JUnitMessages.getString("TestRunnerViewPart.error.cannotrerun"), (String)e.getMessage(), (IStatus)e.getStatus());
                }
            }
            MessageDialog.openInformation((Shell)this.getSite().getShell(), (String)JUnitMessages.getString("TestRunnerViewPart.cannotrerun.title"), (String)JUnitMessages.getString("TestRunnerViewPart.cannotrerurn.message"));
        }
    }

    private class StopAction
    extends Action {
        public StopAction() {
            this.setText(JUnitMessages.getString("TestRunnerViewPart.stopaction.text"));
            this.setToolTipText(JUnitMessages.getString("TestRunnerViewPart.stopaction.tooltip"));
            this.setDisabledImageDescriptor(JUnitPlugin.getImageDescriptor("dlcl16/stop.gif"));
            this.setHoverImageDescriptor(JUnitPlugin.getImageDescriptor("clcl16/stop.gif"));
            this.setImageDescriptor(JUnitPlugin.getImageDescriptor("elcl16/stop.gif"));
        }

        public void run() {
            TestRunnerViewPart.this.stopTest();
        }
    }

    private class RerunLastAction
    extends Action {
        public RerunLastAction() {
            this.setText(JUnitMessages.getString("TestRunnerViewPart.rerunaction.label"));
            this.setToolTipText(JUnitMessages.getString("TestRunnerViewPart.rerunaction.tooltip"));
            this.setDisabledImageDescriptor(JUnitPlugin.getImageDescriptor("dlcl16/relaunch.gif"));
            this.setHoverImageDescriptor(JUnitPlugin.getImageDescriptor("clcl16/relaunch.gif"));
            this.setImageDescriptor(JUnitPlugin.getImageDescriptor("elcl16/relaunch.gif"));
        }

        public void run() {
            TestRunnerViewPart.this.rerunTestRun();
        }
    }

    private class DirtyListener
    implements IElementChangedListener {
        DirtyListener() {
        }

        public void elementChanged(ElementChangedEvent event) {
            this.processDelta(event.getDelta());
        }

        private boolean processDelta(IJavaElementDelta delta) {
            int kind = delta.getKind();
            int details = delta.getFlags();
            int type = delta.getElement().getElementType();
            switch (type) {
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    if (kind == 4 && details == 8) break;
                    TestRunnerViewPart.this.codeHasChanged();
                    return false;
                }
                case 5: {
                    ICompilationUnit unit = (ICompilationUnit)delta.getElement();
                    if (unit.isWorkingCopy()) {
                        return true;
                    }
                    TestRunnerViewPart.this.codeHasChanged();
                    return false;
                }
                case 6: {
                    return true;
                }
                default: {
                    TestRunnerViewPart.this.codeHasChanged();
                    return false;
                }
            }
            IJavaElementDelta[] affectedChildren = delta.getAffectedChildren();
            if (affectedChildren == null) {
                return true;
            }
            int i = 0;
            while (i < affectedChildren.length) {
                if (!this.processDelta(affectedChildren[i])) {
                    return false;
                }
                ++i;
            }
            return true;
        }
    }
}

