/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.junit.ui;

import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.junit.ui.OpenEditorAction;
import org.eclipse.jdt.internal.junit.ui.TestRunnerViewPart;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.ui.help.WorkbenchHelp;
import org.eclipse.ui.texteditor.ITextEditor;

public class OpenEditorAtLineAction
extends OpenEditorAction {
    private int fLineNumber;

    public OpenEditorAtLineAction(TestRunnerViewPart testRunner, String className, int line) {
        super(testRunner, className);
        WorkbenchHelp.setHelp((IAction)this, (String)"org.eclipse.jdt.junit.open_editor_atline_action_context");
        this.fLineNumber = line;
    }

    protected void reveal(ITextEditor textEditor) {
        if (this.fLineNumber >= 0) {
            try {
                IDocument document = textEditor.getDocumentProvider().getDocument((Object)textEditor.getEditorInput());
                textEditor.selectAndReveal(document.getLineOffset(this.fLineNumber - 1), document.getLineLength(this.fLineNumber - 1));
            }
            catch (BadLocationException badLocationException) {}
        }
    }

    protected IJavaElement findElement(IJavaProject project, String className) throws JavaModelException {
        return project.findType(className);
    }

    public boolean isEnabled() {
        try {
            return this.getLaunchedProject().findType(this.getClassName()) != null;
        }
        catch (JavaModelException javaModelException) {
            return false;
        }
    }
}

