/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.junit.ui;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.junit.ui.JUnitMessages;
import org.eclipse.jdt.internal.junit.ui.TestRunnerViewPart;
import org.eclipse.jdt.internal.ui.javaeditor.EditorUtility;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.texteditor.ITextEditor;

public abstract class OpenEditorAction
extends Action {
    protected String fClassName;
    protected TestRunnerViewPart fTestRunner;

    protected OpenEditorAction(TestRunnerViewPart testRunner, String testClassName) {
        super(JUnitMessages.getString("OpenEditorAction.action.label"));
        this.fClassName = testClassName;
        this.fTestRunner = testRunner;
    }

    public void run() {
        ITextEditor textEditor = null;
        try {
            IJavaElement element = this.findElement(this.getLaunchedProject(), this.fClassName);
            if (element == null) {
                MessageDialog.openError((Shell)this.fTestRunner.getSite().getShell(), (String)JUnitMessages.getString("OpenEditorAction.error.cannotopen.title"), (String)JUnitMessages.getString("OpenEditorAction.error.cannotopen.message"));
                return;
            }
            textEditor = (ITextEditor)EditorUtility.openInEditor((Object)element, (boolean)false);
        }
        catch (CoreException e) {
            ErrorDialog.openError((Shell)this.fTestRunner.getSite().getShell(), (String)JUnitMessages.getString("OpenEditorAction.error.dialog.title"), (String)JUnitMessages.getString("OpenEditorAction.error.dialog.message"), (IStatus)e.getStatus());
            return;
        }
        if (textEditor == null) {
            this.fTestRunner.postInfo(JUnitMessages.getString("OpenEditorAction.message.cannotopen"));
            return;
        }
        this.reveal(textEditor);
    }

    protected IJavaProject getLaunchedProject() {
        return this.fTestRunner.getLaunchedProject();
    }

    protected String getClassName() {
        return this.fClassName;
    }

    protected abstract IJavaElement findElement(IJavaProject var1, String var2) throws JavaModelException;

    protected abstract void reveal(ITextEditor var1);
}

