/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.junit.ui;

import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import org.eclipse.jdt.internal.junit.ui.ITestRunView;
import org.eclipse.jdt.internal.junit.ui.JUnitMessages;
import org.eclipse.jdt.internal.junit.ui.OpenTestAction;
import org.eclipse.jdt.internal.junit.ui.RerunAction;
import org.eclipse.jdt.internal.junit.ui.TestRunInfo;
import org.eclipse.jdt.internal.junit.ui.TestRunnerViewPart;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;

class HierarchyRunView
implements ITestRunView,
IMenuListener {
    private Tree fTree;
    private Vector fSuiteInfos = new Vector();
    private Map fTreeItemMap = new HashMap();
    private TestRunnerViewPart fTestRunnerPart;
    private final Image fOkIcon = TestRunnerViewPart.createImage("obj16/testok.gif");
    private final Image fErrorIcon = TestRunnerViewPart.createImage("obj16/testerr.gif");
    private final Image fFailureIcon = TestRunnerViewPart.createImage("obj16/testfail.gif");
    private final Image fHierarchyIcon = TestRunnerViewPart.createImage("obj16/testhier.gif");
    private final Image fSuiteIcon = TestRunnerViewPart.createImage("obj16/tsuite.gif");
    private final Image fSuiteErrorIcon = TestRunnerViewPart.createImage("obj16/tsuiteerror.gif");
    private final Image fSuiteFailIcon = TestRunnerViewPart.createImage("obj16/tsuitefail.gif");
    private final Image fTestIcon = TestRunnerViewPart.createImage("obj16/test.gif");

    public HierarchyRunView(CTabFolder tabFolder, TestRunnerViewPart runner) {
        this.fTestRunnerPart = runner;
        CTabItem hierarchyTab = new CTabItem(tabFolder, 0);
        hierarchyTab.setText(this.getName());
        hierarchyTab.setImage(this.fHierarchyIcon);
        Composite testTreePanel = new Composite((Composite)tabFolder, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        testTreePanel.setLayout((Layout)gridLayout);
        GridData gridData = new GridData(1536);
        testTreePanel.setLayoutData((Object)gridData);
        hierarchyTab.setControl((Control)testTreePanel);
        hierarchyTab.setToolTipText(JUnitMessages.getString("HierarchyRunView.tab.tooltip"));
        this.fTree = new Tree(testTreePanel, 512);
        gridData = new GridData(1808);
        this.fTree.setLayoutData((Object)gridData);
        this.initMenu();
        this.addListeners();
    }

    private void disposeIcons() {
        this.fErrorIcon.dispose();
        this.fFailureIcon.dispose();
        this.fOkIcon.dispose();
        this.fHierarchyIcon.dispose();
        this.fTestIcon.dispose();
        this.fSuiteIcon.dispose();
        this.fSuiteErrorIcon.dispose();
        this.fSuiteFailIcon.dispose();
    }

    private void initMenu() {
        MenuManager menuMgr = new MenuManager();
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener((IMenuListener)this);
        Menu menu = menuMgr.createContextMenu((Control)this.fTree);
        this.fTree.setMenu(menu);
    }

    private String getTestLabel() {
        TreeItem treeItem = this.fTree.getSelection()[0];
        if (treeItem == null) {
            return "";
        }
        return treeItem.getText();
    }

    private TestRunInfo getTestInfo() {
        TreeItem[] treeItems = this.fTree.getSelection();
        if (treeItems.length == 0) {
            return null;
        }
        return (TestRunInfo)treeItems[0].getData();
    }

    private boolean isSuiteSelected() {
        TreeItem[] treeItems = this.fTree.getSelection();
        if (treeItems.length != 1) {
            return false;
        }
        return treeItems[0].getItems().length > 0;
    }

    private String getClassName() {
        TestRunInfo testInfo = this.getTestInfo();
        if (testInfo == null) {
            return null;
        }
        return this.extractClassName(testInfo.getTestName());
    }

    public String getSelectedTestId() {
        TestRunInfo testInfo = this.getTestInfo();
        if (testInfo == null) {
            return null;
        }
        return testInfo.getTestId();
    }

    private String extractClassName(String testNameString) {
        if (testNameString == null) {
            return null;
        }
        int index = testNameString.indexOf(40);
        if (index < 0) {
            return testNameString;
        }
        testNameString = testNameString.substring(index + 1);
        return testNameString.substring(0, testNameString.indexOf(41));
    }

    public String getName() {
        return JUnitMessages.getString("HierarchyRunView.tab.title");
    }

    public void setSelectedTest(String testId) {
        TreeItem treeItem = this.findTreeItem(testId);
        if (treeItem != null) {
            this.fTree.setSelection(new TreeItem[]{treeItem});
        }
    }

    public void endTest(String testId) {
        TreeItem treeItem = this.findTreeItem(testId);
        if (treeItem == null) {
            return;
        }
        TestRunInfo testInfo = this.fTestRunnerPart.getTestInfo(testId);
        this.updateItem(treeItem, testInfo);
        if (testInfo.getTrace() != null) {
            this.fTree.showItem(treeItem);
        }
    }

    private void updateItem(TreeItem treeItem, TestRunInfo testInfo) {
        treeItem.setData((Object)testInfo);
        if (testInfo.getStatus() == 0) {
            treeItem.setImage(this.fOkIcon);
            return;
        }
        if (testInfo.getStatus() == 2) {
            treeItem.setImage(this.fFailureIcon);
        } else if (testInfo.getStatus() == 1) {
            treeItem.setImage(this.fErrorIcon);
        }
        this.propagateStatus(treeItem, testInfo.getStatus());
    }

    private void propagateStatus(TreeItem item, int status) {
        TreeItem parent = item.getParentItem();
        if (parent == null) {
            return;
        }
        Image parentImage = parent.getImage();
        if (status == 2) {
            if (parentImage == this.fSuiteErrorIcon || parentImage == this.fSuiteFailIcon) {
                return;
            }
            parent.setImage(this.fSuiteFailIcon);
        } else {
            if (parentImage == this.fSuiteErrorIcon) {
                return;
            }
            parent.setImage(this.fSuiteErrorIcon);
        }
        this.propagateStatus(parent, status);
    }

    public void activate() {
        this.testSelected();
    }

    public void setFocus() {
        this.fTree.setFocus();
    }

    public void aboutToStart() {
        this.fTree.removeAll();
        this.fSuiteInfos.removeAllElements();
        this.fTreeItemMap = new HashMap();
    }

    private void testSelected() {
        this.fTestRunnerPart.handleTestSelected(this.getSelectedTestId());
    }

    private void addListeners() {
        this.fTree.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                HierarchyRunView.this.activate();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                HierarchyRunView.this.activate();
            }
        });
        this.fTree.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                HierarchyRunView.this.disposeIcons();
            }
        });
        this.fTree.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent e) {
                HierarchyRunView.this.handleDoubleClick(e);
            }
        });
    }

    void handleDoubleClick(MouseEvent e) {
        TestRunInfo testInfo = this.getTestInfo();
        String testLabel = testInfo.getTestName();
        OpenTestAction action = null;
        action = this.isSuiteSelected() ? new OpenTestAction(this.fTestRunnerPart, testLabel) : new OpenTestAction(this.fTestRunnerPart, this.getClassName(), this.getTestLabel());
        if (action != null && action.isEnabled()) {
            action.run();
        }
    }

    public void menuAboutToShow(IMenuManager manager) {
        if (this.fTree.getSelectionCount() > 0) {
            TreeItem treeItem = this.fTree.getSelection()[0];
            TestRunInfo testInfo = (TestRunInfo)treeItem.getData();
            String testLabel = testInfo.getTestName();
            if (this.isSuiteSelected()) {
                manager.add((IAction)new OpenTestAction(this.fTestRunnerPart, testLabel));
            } else {
                manager.add((IAction)new OpenTestAction(this.fTestRunnerPart, this.getClassName(), this.getTestLabel()));
                manager.add((IAction)new RerunAction(this.fTestRunnerPart, this.getSelectedTestId(), this.getClassName(), this.getTestLabel()));
            }
        }
    }

    public void newTreeEntry(String treeEntry) {
        TreeItem treeItem;
        int index0 = treeEntry.indexOf(44);
        int index1 = treeEntry.indexOf(44, index0 + 1);
        int index2 = treeEntry.indexOf(44, index1 + 1);
        String label = treeEntry.substring(index0 + 1, index1).trim();
        String id = treeEntry.substring(0, index0);
        TestRunInfo testInfo = new TestRunInfo(id, label);
        int index3 = label.indexOf(40);
        if (index3 > 0) {
            label = label.substring(0, index3);
        }
        if ((index3 = label.indexOf(64)) > 0) {
            label = label.substring(0, index3);
        }
        String isSuite = treeEntry.substring(index1 + 1, index2);
        int testCount = Integer.parseInt(treeEntry.substring(index2 + 1));
        while (this.fSuiteInfos.size() > 0 && ((SuiteInfo)this.fSuiteInfos.lastElement()).fTestCount == 0) {
            this.fSuiteInfos.removeElementAt(this.fSuiteInfos.size() - 1);
        }
        if (this.fSuiteInfos.size() == 0) {
            treeItem = new TreeItem(this.fTree, 0);
            treeItem.setImage(this.fSuiteIcon);
            this.fSuiteInfos.addElement(new SuiteInfo(treeItem, testCount));
        } else if (isSuite.equals("true")) {
            treeItem = new TreeItem(((SuiteInfo)this.fSuiteInfos.lastElement()).fTreeItem, 0);
            treeItem.setImage(this.fHierarchyIcon);
            --((SuiteInfo)this.fSuiteInfos.lastElement()).fTestCount;
            this.fSuiteInfos.addElement(new SuiteInfo(treeItem, testCount));
        } else {
            treeItem = new TreeItem(((SuiteInfo)this.fSuiteInfos.lastElement()).fTreeItem, 0);
            treeItem.setImage(this.fTestIcon);
            --((SuiteInfo)this.fSuiteInfos.lastElement()).fTestCount;
            this.mapTest(testInfo, treeItem);
        }
        treeItem.setText(label);
        treeItem.setData((Object)testInfo);
    }

    private void mapTest(TestRunInfo info, TreeItem item) {
        this.fTreeItemMap.put(info.getTestId(), item);
    }

    private TreeItem findTreeItem(String testId) {
        Object o = this.fTreeItemMap.get(testId);
        if (o instanceof TreeItem) {
            return (TreeItem)o;
        }
        return null;
    }

    public void testStatusChanged(TestRunInfo newInfo) {
        Object o = this.fTreeItemMap.get(newInfo.getTestId());
        if (o instanceof TreeItem) {
            this.updateItem((TreeItem)o, newInfo);
            return;
        }
    }

    private static class SuiteInfo {
        public int fTestCount;
        public TreeItem fTreeItem;

        public SuiteInfo(TreeItem treeItem, int testCount) {
            this.fTreeItem = treeItem;
            this.fTestCount = testCount;
        }
    }
}

