/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.junit.ui;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.StringWriter;
import org.eclipse.jdt.internal.junit.ui.CopyTraceAction;
import org.eclipse.jdt.internal.junit.ui.JUnitPreferencePage;
import org.eclipse.jdt.internal.junit.ui.OpenEditorAtLineAction;
import org.eclipse.jdt.internal.junit.ui.TestRunnerViewPart;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.util.Assert;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;

class FailureTraceView
implements IMenuListener {
    private static final String FRAME_PREFIX = "at ";
    private Table fTable;
    private TestRunnerViewPart fTestRunner;
    private String fInputTrace;
    private final Clipboard fClipboard;
    private final Image fStackIcon = TestRunnerViewPart.createImage("obj16/stkfrm_obj.gif");
    private final Image fExceptionIcon = TestRunnerViewPart.createImage("obj16/exc_catch.gif");

    public FailureTraceView(Composite parent, TestRunnerViewPart testRunner, Clipboard clipboard) {
        Assert.isNotNull((Object)clipboard);
        this.fTable = new Table(parent, 772);
        this.fTestRunner = testRunner;
        this.fClipboard = clipboard;
        this.fTable.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent e) {
                FailureTraceView.this.handleDoubleClick(e);
            }
        });
        this.initMenu();
        parent.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                FailureTraceView.this.disposeIcons();
            }
        });
    }

    void handleDoubleClick(MouseEvent e) {
        Action a;
        if (this.fTable.getSelection().length != 0 && (a = this.createOpenEditorAction(this.getSelectedText())) != null) {
            a.run();
        }
    }

    private void initMenu() {
        MenuManager menuMgr = new MenuManager();
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener((IMenuListener)this);
        Menu menu = menuMgr.createContextMenu((Control)this.fTable);
        this.fTable.setMenu(menu);
    }

    public void menuAboutToShow(IMenuManager manager) {
        Action a;
        if (this.fTable.getSelectionCount() > 0 && (a = this.createOpenEditorAction(this.getSelectedText())) != null) {
            manager.add((IAction)a);
        }
        manager.add((IAction)new CopyTraceAction(this, this.fClipboard));
    }

    public String getTrace() {
        return this.fInputTrace;
    }

    private String getSelectedText() {
        return this.fTable.getSelection()[0].getText();
    }

    private Action createOpenEditorAction(String traceLine) {
        try {
            String testName = traceLine;
            testName = testName.substring(testName.indexOf(FRAME_PREFIX));
            testName = testName.substring(FRAME_PREFIX.length(), testName.indexOf(40)).trim();
            testName = testName.substring(0, testName.lastIndexOf(46));
            int innerSeparatorIndex = testName.indexOf(36);
            if (innerSeparatorIndex != -1) {
                testName = testName.substring(0, innerSeparatorIndex);
            }
            String lineNumber = traceLine;
            lineNumber = lineNumber.substring(lineNumber.indexOf(58) + 1, lineNumber.indexOf(")"));
            int line = Integer.valueOf(lineNumber);
            return new OpenEditorAtLineAction(this.fTestRunner, testName, line);
        }
        catch (NumberFormatException numberFormatException) {
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {}
        return null;
    }

    private void disposeIcons() {
        if (this.fExceptionIcon != null && !this.fExceptionIcon.isDisposed()) {
            this.fExceptionIcon.dispose();
        }
        if (this.fStackIcon != null && !this.fStackIcon.isDisposed()) {
            this.fStackIcon.dispose();
        }
    }

    Composite getComposite() {
        return this.fTable;
    }

    public void refresh() {
        this.updateTable(this.fInputTrace);
    }

    public void showFailure(String trace) {
        if (this.fInputTrace == trace) {
            return;
        }
        this.fInputTrace = trace;
        this.updateTable(trace);
    }

    private void updateTable(String trace) {
        if (trace == null || trace.trim().equals("")) {
            this.clear();
            return;
        }
        trace = trace.trim();
        this.fTable.setRedraw(false);
        this.fTable.removeAll();
        this.fillTable(this.filterStack(trace));
        this.fTable.setRedraw(true);
    }

    private void fillTable(String trace) {
        StringReader stringReader = new StringReader(trace);
        BufferedReader bufferedReader = new BufferedReader(stringReader);
        try {
            String line = bufferedReader.readLine();
            if (line == null) {
                return;
            }
            TableItem tableItem = new TableItem(this.fTable, 0);
            String itemLabel = line.replace('\t', ' ');
            tableItem.setText(itemLabel);
            tableItem.setImage(this.fExceptionIcon);
            while ((line = bufferedReader.readLine()) != null) {
                itemLabel = line.replace('\t', ' ');
                tableItem = new TableItem(this.fTable, 0);
                if (itemLabel.indexOf(" at ") >= 0) {
                    tableItem.setImage(this.fStackIcon);
                }
                tableItem.setText(itemLabel);
            }
        }
        catch (IOException iOException) {
            TableItem tableItem = new TableItem(this.fTable, 0);
            tableItem.setText(trace);
        }
    }

    public void setInformation(String text) {
        this.clear();
        TableItem tableItem = new TableItem(this.fTable, 0);
        tableItem.setText(text);
    }

    public void clear() {
        this.fTable.removeAll();
        this.fInputTrace = null;
    }

    private String filterStack(String stackTrace) {
        if (!JUnitPreferencePage.getFilterStack() || stackTrace == null) {
            return stackTrace;
        }
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        StringReader stringReader = new StringReader(stackTrace);
        BufferedReader bufferedReader = new BufferedReader(stringReader);
        String[] patterns = JUnitPreferencePage.getFilterPatterns();
        try {
            String line;
            while ((line = bufferedReader.readLine()) != null) {
                if (this.filterLine(patterns, line)) continue;
                printWriter.println(line);
            }
        }
        catch (IOException iOException) {
            return stackTrace;
        }
        return stringWriter.toString();
    }

    private boolean filterLine(String[] patterns, String line) {
        int i = patterns.length - 1;
        while (i >= 0) {
            String pattern = patterns[i];
            int len = pattern.length() - 1;
            if (pattern.charAt(len) == '*') {
                pattern = pattern.substring(0, len);
            } else if (Character.isUpperCase(pattern.charAt(0))) {
                pattern = FRAME_PREFIX + pattern + '.';
            } else {
                int lastDotIndex = pattern.lastIndexOf(46);
                if (lastDotIndex != -1 && lastDotIndex != len && Character.isUpperCase(pattern.charAt(lastDotIndex + 1))) {
                    pattern = String.valueOf(pattern) + '.';
                }
            }
            if (line.indexOf(pattern) > 0) {
                return true;
            }
            --i;
        }
        return false;
    }
}

