/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.junit.ui;

import org.eclipse.jdt.internal.junit.ui.ITestRunView;
import org.eclipse.jdt.internal.junit.ui.JUnitMessages;
import org.eclipse.jdt.internal.junit.ui.OpenTestAction;
import org.eclipse.jdt.internal.junit.ui.RerunAction;
import org.eclipse.jdt.internal.junit.ui.TestRunInfo;
import org.eclipse.jdt.internal.junit.ui.TestRunnerViewPart;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;

class FailureRunView
implements ITestRunView,
IMenuListener {
    private Table fTable;
    private TestRunnerViewPart fRunnerViewPart;
    private final Image fErrorIcon = TestRunnerViewPart.createImage("obj16/testerr.gif");
    private final Image fFailureIcon = TestRunnerViewPart.createImage("obj16/testfail.gif");
    private final Image fFailureTabIcon = TestRunnerViewPart.createImage("obj16/failures.gif");

    public FailureRunView(CTabFolder tabFolder, TestRunnerViewPart runner) {
        this.fRunnerViewPart = runner;
        CTabItem failureTab = new CTabItem(tabFolder, 0);
        failureTab.setText(this.getName());
        failureTab.setImage(this.fFailureTabIcon);
        Composite composite = new Composite((Composite)tabFolder, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        composite.setLayout((Layout)gridLayout);
        GridData gridData = new GridData(1808);
        composite.setLayoutData((Object)gridData);
        this.fTable = new Table(composite, 0);
        gridLayout = new GridLayout();
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        this.fTable.setLayout((Layout)gridLayout);
        gridData = new GridData(1808);
        this.fTable.setLayoutData((Object)gridData);
        failureTab.setControl((Control)composite);
        failureTab.setToolTipText(JUnitMessages.getString("FailureRunView.tab.tooltip"));
        this.initMenu();
        this.addListeners();
    }

    private void disposeIcons() {
        this.fErrorIcon.dispose();
        this.fFailureIcon.dispose();
        this.fFailureTabIcon.dispose();
    }

    private void initMenu() {
        MenuManager menuMgr = new MenuManager();
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener((IMenuListener)this);
        Menu menu = menuMgr.createContextMenu((Control)this.fTable);
        this.fTable.setMenu(menu);
    }

    public String getName() {
        return JUnitMessages.getString("FailureRunView.tab.title");
    }

    public String getSelectedTestId() {
        int index = this.fTable.getSelectionIndex();
        if (index == -1) {
            return null;
        }
        return this.getTestInfo(this.fTable.getItem(index)).getTestId();
    }

    private String getClassName() {
        return FailureRunView.cutFromTo(this.getSelectedText(), '(', ')');
    }

    private String getMethodName() {
        return FailureRunView.cutTo(this.getSelectedText(), '(');
    }

    private static String cutFromTo(String string, char from, char to) {
        String modified = string;
        modified = modified.substring(modified.indexOf(from) + 1);
        return FailureRunView.cutTo(modified, to);
    }

    private static String cutTo(String string, char to) {
        int toIndex = string.indexOf(to);
        if (toIndex == -1) {
            return string;
        }
        return string.substring(0, toIndex);
    }

    public void menuAboutToShow(IMenuManager manager) {
        if (this.fTable.getSelectionCount() > 0) {
            String className = this.getClassName();
            String methodName = this.getMethodName();
            if (className != null) {
                manager.add((IAction)new OpenTestAction(this.fRunnerViewPart, className, methodName));
                manager.add((IAction)new RerunAction(this.fRunnerViewPart, this.getSelectedTestId(), className, methodName));
            }
        }
    }

    private String getSelectedText() {
        int index = this.fTable.getSelectionIndex();
        if (index == -1) {
            return null;
        }
        return this.fTable.getItem(index).getText();
    }

    public void setSelectedTest(String testId) {
        TableItem[] items = this.fTable.getItems();
        int i = 0;
        while (i < items.length) {
            TableItem tableItem = items[i];
            TestRunInfo info = this.getTestInfo(tableItem);
            if (info.getTestId().equals(testId)) {
                this.fTable.setSelection(new TableItem[]{tableItem});
                this.fTable.showItem(tableItem);
                return;
            }
            ++i;
        }
    }

    private TestRunInfo getTestInfo(TableItem item) {
        return (TestRunInfo)item.getData();
    }

    public void setFocus() {
        this.fTable.setFocus();
    }

    public void endTest(String testId) {
        TestRunInfo testInfo = this.fRunnerViewPart.getTestInfo(testId);
        if (testInfo == null || testInfo.getStatus() == 0) {
            return;
        }
        TableItem tableItem = new TableItem(this.fTable, 0);
        this.updateTableItem(testInfo, tableItem);
        this.fTable.showItem(tableItem);
    }

    private void updateTableItem(TestRunInfo testInfo, TableItem tableItem) {
        tableItem.setText(testInfo.getTestName());
        if (testInfo.getStatus() == 2) {
            tableItem.setImage(this.fFailureIcon);
        } else {
            tableItem.setImage(this.fErrorIcon);
        }
        tableItem.setData((Object)testInfo);
    }

    private TableItem findItem(String testId) {
        TableItem[] items = this.fTable.getItems();
        int i = 0;
        while (i < items.length) {
            TestRunInfo info = this.getTestInfo(items[i]);
            if (info.getTestId().equals(testId)) {
                return items[i];
            }
            ++i;
        }
        return null;
    }

    public void activate() {
        this.testSelected();
    }

    public void aboutToStart() {
        this.fTable.removeAll();
    }

    private void testSelected() {
        this.fRunnerViewPart.handleTestSelected(this.getSelectedTestId());
    }

    private void addListeners() {
        this.fTable.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                FailureRunView.this.activate();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                FailureRunView.this.activate();
            }
        });
        this.fTable.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                FailureRunView.this.disposeIcons();
            }
        });
        this.fTable.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent e) {
                FailureRunView.this.handleDoubleClick(e);
            }

            public void mouseDown(MouseEvent e) {
                FailureRunView.this.activate();
            }

            public void mouseUp(MouseEvent e) {
                FailureRunView.this.activate();
            }
        });
    }

    void handleDoubleClick(MouseEvent e) {
        if (this.fTable.getSelectionCount() > 0) {
            new OpenTestAction(this.fRunnerViewPart, this.getClassName(), this.getMethodName()).run();
        }
    }

    public void newTreeEntry(String treeEntry) {
    }

    public void testStatusChanged(TestRunInfo info) {
        TableItem item = this.findItem(info.getTestId());
        if (item != null) {
            if (info.getStatus() == 0) {
                item.dispose();
                return;
            }
            this.updateTableItem(info, item);
        }
        if (item == null && info.getStatus() != 0) {
            item = new TableItem(this.fTable, 0);
            this.updateTableItem(info, item);
        }
        if (item != null) {
            this.fTable.showItem(item);
        }
    }
}

