/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.junit.launcher;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.internal.junit.ui.JUnitPlugin;
import org.eclipse.jdt.internal.junit.util.TestSearchEngine;
import org.eclipse.jdt.ui.JavaElementLabelProvider;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.util.Assert;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.TwoPaneElementSelector;

public class TestSelectionDialog
extends TwoPaneElementSelector {
    private IRunnableContext fRunnableContext;
    private IJavaProject fProject;

    public TestSelectionDialog(Shell shell, IRunnableContext context, IJavaProject project) {
        super(shell, (ILabelProvider)new JavaElementLabelProvider(16), (ILabelProvider)new PackageRenderer());
        Assert.isNotNull((Object)context);
        Assert.isNotNull((Object)project);
        this.fRunnableContext = context;
        this.fProject = project;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
    }

    public int open() {
        Object[] types = new IType[]{};
        try {
            types = TestSearchEngine.findTests(this.fRunnableContext, new Object[]{this.fProject});
        }
        catch (InterruptedException interruptedException) {
            return 1;
        }
        catch (InvocationTargetException e) {
            JUnitPlugin.log(e.getTargetException());
            return 1;
        }
        this.setElements(types);
        return super.open();
    }

    private static class PackageRenderer
    extends JavaElementLabelProvider {
        public PackageRenderer() {
            super(2114);
        }

        public Image getImage(Object element) {
            return super.getImage((Object)((IType)element).getPackageFragment());
        }

        public String getText(Object element) {
            return super.getText((Object)((IType)element).getPackageFragment());
        }
    }
}

