/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.junit.launcher;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.net.URL;
import java.util.Vector;
import org.eclipse.core.boot.BootLoader;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.internal.junit.launcher.JUnitBaseLaunchConfiguration;
import org.eclipse.jdt.internal.junit.ui.JUnitPlugin;
import org.eclipse.jdt.launching.ExecutionArguments;
import org.eclipse.jdt.launching.VMRunnerConfiguration;

public class JUnitLaunchConfiguration
extends JUnitBaseLaunchConfiguration {
    public static final String ID_JUNIT_APPLICATION = "org.eclipse.jdt.junit.launchconfig";

    protected VMRunnerConfiguration createVMRunner(ILaunchConfiguration configuration, IType[] testTypes, int port, String runMode) throws CoreException {
        String[] classPath = this.createClassPath(configuration);
        String progArgs = this.getProgramArguments(configuration);
        VMRunnerConfiguration vmConfig = new VMRunnerConfiguration("org.eclipse.jdt.internal.junit.runner.RemoteTestRunner", classPath);
        String testName = configuration.getAttribute("org.eclipse.jdt.junit.TESTNAME", "");
        Vector<String> argv = new Vector<String>(10);
        ExecutionArguments execArgs = new ExecutionArguments("", progArgs);
        String[] pa = execArgs.getProgramArgumentsArray();
        int i = 0;
        while (i < pa.length) {
            argv.add(pa[i]);
            ++i;
        }
        argv.add("-port");
        argv.add(Integer.toString(port));
        if (this.keepAlive(configuration) && runMode.equals("debug")) {
            argv.add(0, "-keepalive");
        }
        if (testName.length() > 0) {
            argv.add("-test");
            argv.add(String.valueOf(testTypes[0].getFullyQualifiedName()) + ":" + testName);
        } else if (testTypes.length > 1) {
            String fileName = this.createTestNamesFile(testTypes);
            argv.add("-testNameFile");
            argv.add(fileName);
        } else {
            argv.add("-classNames");
            i = 0;
            while (i < testTypes.length) {
                argv.add(testTypes[i].getFullyQualifiedName());
                ++i;
            }
        }
        Object[] args = new String[argv.size()];
        argv.copyInto(args);
        vmConfig.setProgramArguments((String[])args);
        return vmConfig;
    }

    private String createTestNamesFile(IType[] testTypes) throws CoreException {
        try {
            File file = File.createTempFile("testNames", ".txt");
            file.deleteOnExit();
            BufferedWriter bw = null;
            try {
                bw = new BufferedWriter(new FileWriter(file));
                int i = 0;
                while (i < testTypes.length) {
                    String testName = testTypes[i].getFullyQualifiedName();
                    bw.write(testName);
                    bw.newLine();
                    ++i;
                }
            }
            catch (Throwable throwable) {
                Object var6_8 = null;
                if (bw != null) {
                    bw.close();
                }
                throw throwable;
            }
            Object var6_9 = null;
            if (bw != null) {
                bw.close();
            }
            return file.getAbsolutePath();
        }
        catch (IOException e) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.jdt.junit", 4, "", (Throwable)e));
        }
    }

    private String[] createClassPath(ILaunchConfiguration configuration) throws CoreException {
        URL url = JUnitPlugin.getDefault().getDescriptor().getInstallURL();
        String[] cp = this.getClasspath(configuration);
        String[] classPath = null;
        try {
            if (BootLoader.inDevelopmentMode()) {
                classPath = new String[cp.length + 2];
                System.arraycopy(cp, 0, classPath, 2, cp.length);
                classPath[0] = Platform.asLocalURL((URL)new URL(url, "bin")).getFile();
                classPath[1] = Platform.asLocalURL((URL)new URL(url, "junitsupport.jar")).getFile();
            } else {
                classPath = new String[cp.length + 1];
                System.arraycopy(cp, 0, classPath, 1, cp.length);
                classPath[0] = Platform.asLocalURL((URL)new URL(url, "junitsupport.jar")).getFile();
            }
        }
        catch (IOException e) {
            JUnitPlugin.log(e);
        }
        return classPath;
    }
}

