/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.junit.launcher;

import java.io.File;
import java.text.MessageFormat;
import java.util.HashSet;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.junit.ui.JUnitMessages;
import org.eclipse.jdt.internal.junit.util.SocketUtil;
import org.eclipse.jdt.internal.junit.util.TestSearchEngine;
import org.eclipse.jdt.launching.AbstractJavaLaunchConfigurationDelegate;
import org.eclipse.jdt.launching.ExecutionArguments;
import org.eclipse.jdt.launching.IJavaLaunchConfigurationConstants;
import org.eclipse.jdt.launching.IVMInstall;
import org.eclipse.jdt.launching.IVMRunner;
import org.eclipse.jdt.launching.VMRunnerConfiguration;

public abstract class JUnitBaseLaunchConfiguration
extends AbstractJavaLaunchConfigurationDelegate {
    public static final String PORT_ATTR = "org.eclipse.jdt.junit.PORT";
    public static final String TESTTYPE_ATTR = "org.eclipse.jdt.junit.TESTTYPE";
    public static final String TESTNAME_ATTR = "org.eclipse.jdt.junit.TESTNAME";
    public static final String ATTR_KEEPRUNNING = "org.eclipse.jdt.junit.KEEPRUNNING_ATTR";
    public static final String LAUNCH_CONTAINER_ATTR = "org.eclipse.jdt.junit.CONTAINER";

    public void launch(ILaunchConfiguration configuration, String mode, ILaunch launch, IProgressMonitor pm) throws CoreException {
        IJavaProject javaProject = this.getJavaProject(configuration);
        if (javaProject == null || !javaProject.exists()) {
            this.abort(JUnitMessages.getString("JUnitBaseLaunchConfiguration.error.invalidproject"), null, 107);
        }
        IType[] testTypes = this.getTestTypes(configuration, javaProject, pm);
        IVMInstall install = this.getVMInstall(configuration);
        IVMRunner runner = install.getVMRunner(mode);
        if (runner == null) {
            this.abort(MessageFormat.format(JUnitMessages.getString("JUnitBaseLaunchConfiguration.error.novmrunner"), install.getId()), null, 106);
        }
        int port = SocketUtil.findUnusedLocalPort("", 5000, 15000);
        VMRunnerConfiguration runConfig = this.launchTypes(configuration, mode, testTypes, port);
        this.setDefaultSourceLocator(launch, configuration);
        launch.setAttribute(PORT_ATTR, Integer.toString(port));
        launch.setAttribute(TESTTYPE_ATTR, testTypes[0].getHandleIdentifier());
        runner.run(runConfig, launch, pm);
    }

    protected VMRunnerConfiguration launchTypes(ILaunchConfiguration configuration, String mode, IType[] tests, int port) throws CoreException {
        File workingDir = this.verifyWorkingDirectory(configuration);
        String workingDirName = null;
        if (workingDir != null) {
            workingDirName = workingDir.getAbsolutePath();
        }
        String vmArgs = this.getVMArguments(configuration);
        ExecutionArguments execArgs = new ExecutionArguments(vmArgs, "");
        VMRunnerConfiguration runConfig = this.createVMRunner(configuration, tests, port, mode);
        runConfig.setVMArguments(execArgs.getVMArgumentsArray());
        runConfig.setWorkingDirectory(workingDirName);
        String[] bootpath = this.getBootpath(configuration);
        runConfig.setBootClassPath(bootpath);
        return runConfig;
    }

    public IType[] getTestTypes(ILaunchConfiguration configuration, IJavaProject javaProject, IProgressMonitor pm) throws CoreException {
        String containerHandle;
        String testTypeName = configuration.getAttribute(IJavaLaunchConfigurationConstants.ATTR_MAIN_TYPE_NAME, null);
        if (pm == null) {
            pm = new NullProgressMonitor();
        }
        if ((containerHandle = configuration.getAttribute(LAUNCH_CONTAINER_ATTR, "")).length() == 0) {
            return this.findSingleTest(javaProject, testTypeName);
        }
        return this.findTestsInContainer(javaProject, containerHandle, pm);
    }

    private IType[] findTestsInContainer(IJavaProject javaProject, String containerHandle, IProgressMonitor pm) {
        IJavaElement container = JavaCore.create((String)containerHandle);
        HashSet result = new HashSet();
        try {
            TestSearchEngine.doFindTests(new Object[]{container}, result, pm);
        }
        catch (InterruptedException interruptedException) {}
        return result.toArray(new IType[result.size()]);
    }

    public IType[] findSingleTest(IJavaProject javaProject, String testName) throws CoreException {
        IType type = null;
        try {
            type = this.findType(javaProject, testName);
        }
        catch (JavaModelException javaModelException) {
            this.abort("Test type does not exist", null, 101);
        }
        if (type == null) {
            this.abort("Test type does not exist", null, 101);
        }
        return new IType[]{type};
    }

    protected void abort(String message, Throwable exception, int code) throws CoreException {
        throw new CoreException((IStatus)new Status(4, "org.eclipse.jdt.junit", code, message, exception));
    }

    private IType findType(IJavaProject javaProject, String mainTypeName) throws JavaModelException {
        return javaProject.findType(mainTypeName);
    }

    protected abstract VMRunnerConfiguration createVMRunner(ILaunchConfiguration var1, IType[] var2, int var3, String var4) throws CoreException;

    protected boolean keepAlive(ILaunchConfiguration config) {
        try {
            return config.getAttribute(ATTR_KEEPRUNNING, false);
        }
        catch (CoreException coreException) {
            return false;
        }
    }
}

