/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.lib.logging.descriptors;

import com.sap.tc.logging.Location;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.InputStream;

public class PersistenceAdapter {
    private static final Location TRACER = Location.getLocation((Class)(class$com$sap$engine$lib$logging$descriptors$PersistenceAdapter == null ? (class$com$sap$engine$lib$logging$descriptors$PersistenceAdapter = PersistenceAdapter.class$("com.sap.engine.lib.logging.descriptors.PersistenceAdapter")) : class$com$sap$engine$lib$logging$descriptors$PersistenceAdapter));
    public static final String KERNEL_CONFIG_DIR = "." + File.separator + "cfg" + File.separator + "kernel" + File.separator;
    public static final String CUSTOM_CONFIG_FILE_NAME = "custom-log-configuration.xml";
    public static final String CONFIG_FILE_NAME = "log-configuration.xml";
    protected static final byte PERSISTENCE_TYPE_FILE = 0;
    protected final byte type;
    private final File defaultFile;
    private final File file;
    static /* synthetic */ Class class$com$sap$engine$lib$logging$descriptors$PersistenceAdapter;

    public PersistenceAdapter(File file) {
        this(file, file);
    }

    public PersistenceAdapter(File customFile, File defaultFile) {
        this.type = 0;
        this.defaultFile = defaultFile;
        this.file = customFile;
    }

    protected PersistenceAdapter(byte type) {
        this.type = type;
        this.defaultFile = null;
        this.file = null;
    }

    public InputStream getDefaultPersistentEntryStream() {
        return this.getStream(this.defaultFile);
    }

    public InputStream getPersistentEntryStream() {
        return this.getStream(this.file);
    }

    private InputStream getStream(File source) {
        switch (this.type) {
            case 0: {
                try {
                    return new FileInputStream(source);
                }
                catch (FileNotFoundException fnfe) {
                    TRACER.traceThrowableT(200, "", (Throwable)fnfe);
                    return null;
                }
            }
        }
        return null;
    }

    public void setPersistentEntryStream(InputStream stream) {
        this.setStream(stream, this.file);
    }

    private void setStream(InputStream stream, File destination) {
        switch (this.type) {
            case 0: {
                try {
                    FileOutputStream fos = new FileOutputStream(destination);
                    byte[] buffer = new byte[512];
                    int l = -1;
                    while ((l = stream.read(buffer)) != -1) {
                        fos.write(buffer, 0, l);
                    }
                    stream.close();
                    fos.flush();
                    fos.close();
                }
                catch (Exception exc) {
                    TRACER.traceThrowableT(200, "", (Throwable)exc);
                }
                return;
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

