/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.lib.logging.descriptors;

import com.sap.engine.lib.logging.descriptors.LogConfiguration;
import com.sap.engine.lib.logging.descriptors.LogControllerDescriptor;
import com.sap.engine.lib.logging.descriptors.LogDestinationDescriptor;
import com.sap.engine.lib.logging.descriptors.LogFormatterDescriptor;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.StringTokenizer;

class LogPropertiesParser {
    LogPropertiesParser() {
    }

    public static LogConfiguration parse(String fileName) throws FileNotFoundException, IOException, Exception {
        return LogPropertiesParser.parse(new FileInputStream(fileName));
    }

    public static LogConfiguration parse(InputStream in) throws IOException, Exception {
        Properties props = new Properties();
        props.load(in);
        return LogPropertiesParser.parse(props);
    }

    public static LogConfiguration parse(Properties props) throws Exception {
        Hashtable formatters = new Hashtable();
        Hashtable destinations = new Hashtable();
        Hashtable controllers = new Hashtable();
        LogConfiguration config = new LogConfiguration();
        Enumeration keys = ((Hashtable)props).keys();
        while (keys.hasMoreElements()) {
            StringTokenizer filters;
            String value;
            String name;
            String key = (String)keys.nextElement();
            String param = null;
            if (key.startsWith("log[")) {
                try {
                    name = key.substring(4, key.indexOf(93));
                    if (key.length() > name.length() + 5) {
                        int index = key.lastIndexOf(46);
                        if (index == -1) {
                            throw new Exception();
                        }
                        param = key.substring(index + 1, key.length());
                    }
                }
                catch (Exception e) {
                    throw new Exception("Invalid log name: '" + key + "'");
                }
                LogDestinationDescriptor log = LogPropertiesParser.getLog(name, destinations, config);
                value = props.getProperty(key);
                if (param == null || param.equals("")) {
                    log.setType(value);
                    continue;
                }
                if (param.equals("effSeverity") || param.equals("severity")) {
                    log.setEffectiveSeverity(value);
                    continue;
                }
                if (param.equals("encoding")) {
                    log.setEncoding(value);
                    continue;
                }
                if (param.equals("filters")) {
                    if (value.startsWith("+")) {
                        value = value.substring(1);
                    }
                    filters = new StringTokenizer(value, ",");
                    while (filters.hasMoreTokens()) {
                        log.addFilter(filters.nextToken().trim());
                    }
                    continue;
                }
                if (param.equals("formatter")) {
                    if (value.startsWith("formatter[")) {
                        try {
                            log.setFormatter(LogPropertiesParser.getFormatter(value.substring(10, value.indexOf(93)), formatters, config));
                            continue;
                        }
                        catch (Exception e) {
                            throw new Exception("Invalid formatter name: '" + value + "' in '" + key + "'");
                        }
                    }
                    LogFormatterDescriptor lfd = new LogFormatterDescriptor();
                    lfd.setType(value);
                    log.setFormatter(lfd);
                    continue;
                }
                if (param.equals("pattern")) {
                    log.setPattern(value);
                    continue;
                }
                if (param.equals("limit")) {
                    try {
                        log.setLimit(Integer.parseInt(value));
                        continue;
                    }
                    catch (Exception e) {
                        throw new Exception("Invalid number format for limit: '" + value + "'");
                    }
                }
                if (param.equals("cnt")) {
                    try {
                        log.setCount(Integer.parseInt(value));
                        continue;
                    }
                    catch (Exception e) {
                        throw new Exception("Invalid number format for count: '" + value + "'");
                    }
                }
                throw new Exception("Invalid log property: '" + param + "' in '" + key + "'");
            }
            if (key.startsWith("formatter[")) {
                try {
                    name = key.substring(10, key.indexOf(93));
                    if (key.length() > name.length() + 11) {
                        int index = key.lastIndexOf(46);
                        if (index == -1) {
                            throw new Exception();
                        }
                        param = key.substring(index + 1, key.length());
                    }
                }
                catch (Exception e) {
                    throw new Exception("Invalid formatter: '" + key + "'");
                }
                LogFormatterDescriptor formatter = LogPropertiesParser.getFormatter(name, formatters, config);
                value = props.getProperty(key);
                if (param == null || param.equals("")) {
                    formatter.setType(value);
                    continue;
                }
                if (param.equals("pattern")) {
                    formatter.setPattern(value);
                    continue;
                }
                throw new Exception("Invalid formatter property: '" + param + "' in '" + key + "'");
            }
            try {
                int index = key.lastIndexOf(46);
                name = key.substring(0, index);
                param = key.substring(index + 1, key.length());
            }
            catch (Exception e) {
                throw new Exception("Invalid controller property: '" + key + "'");
            }
            LogControllerDescriptor controller = LogPropertiesParser.getController(name, controllers, config);
            value = props.getProperty(key);
            if (param == null || param.equals("")) {
                throw new Exception("Invalid controller format: '" + key + "'");
            }
            if (param.equals("severity") || param.equals("effSeverity")) {
                controller.setMinSeverity(value);
                controller.setMaxSeverity(value);
                continue;
            }
            if (param.equals("minSeverity")) {
                controller.setMinSeverity(value);
                continue;
            }
            if (param.equals("maxSeverity")) {
                controller.setMaxSeverity(value);
                continue;
            }
            if (param.startsWith("severity[")) {
                controller.setRelativeSeverity(param.substring("severity[".length(), param.indexOf(93)), value);
                continue;
            }
            if (param.startsWith("effSeverity[")) {
                controller.setRelativeSeverity(param.substring("effSeverity[".length(), param.indexOf(93)), value);
                continue;
            }
            if (param.startsWith("minSeverity[")) {
                controller.setMinRelativeSeverity(param.substring("minSeverity[".length(), param.indexOf(93)), value);
                continue;
            }
            if (param.startsWith("maxSeverity[")) {
                controller.setMaxRelativeSeverity(param.substring("maxSeverity[".length(), param.indexOf(93)), value);
                continue;
            }
            if (param.equals("logs")) {
                LogPropertiesParser.addLogsToController(controller, value, destinations, config, (byte)0);
                continue;
            }
            if (param.equals("localLogs")) {
                LogPropertiesParser.addLogsToController(controller, value, destinations, config, (byte)2);
                continue;
            }
            if (param.equals("privateLogs")) {
                LogPropertiesParser.addLogsToController(controller, value, destinations, config, (byte)1);
                continue;
            }
            if (param.equals("filters")) {
                if (value.startsWith("+")) {
                    value = value.substring(1);
                }
                filters = new StringTokenizer(value, ",");
                while (filters.hasMoreTokens()) {
                    controller.addFilter(filters.nextToken().trim());
                }
                continue;
            }
            if (param.equals("bundleName")) {
                controller.setBundleName(value);
                continue;
            }
            throw new Exception("Invalid controller property: '" + param + "' in '" + key + "'");
        }
        return config;
    }

    private static LogDestinationDescriptor getLog(String name, Hashtable destinations, LogConfiguration config) {
        LogDestinationDescriptor log = (LogDestinationDescriptor)destinations.get(name);
        if (log == null) {
            log = new LogDestinationDescriptor();
            log.setName(name);
            destinations.put(name, log);
            config.addLogDestination(log);
        }
        return log;
    }

    private static LogFormatterDescriptor getFormatter(String name, Hashtable formatters, LogConfiguration config) {
        LogFormatterDescriptor formatter = (LogFormatterDescriptor)formatters.get(name);
        if (formatter == null) {
            formatter = new LogFormatterDescriptor();
            formatter.setName(name);
            formatters.put(name, formatter);
            config.addLogFormatter(formatter);
        }
        return formatter;
    }

    private static LogControllerDescriptor getController(String name, Hashtable controllers, LogConfiguration config) {
        LogControllerDescriptor controller = (LogControllerDescriptor)controllers.get(name);
        if (controller == null) {
            controller = new LogControllerDescriptor();
            controller.setName(name);
            controllers.put(name, controller);
            config.addLogController(controller);
        }
        return controller;
    }

    private static void addLogsToController(LogControllerDescriptor controller, String value, Hashtable destinations, LogConfiguration config, byte logType) throws Exception {
        if (value.startsWith("+")) {
            value = value.substring(1);
        }
        StringTokenizer logs = new StringTokenizer(value, ",");
        while (logs.hasMoreTokens()) {
            value = logs.nextToken().trim();
            if (value.startsWith("log[")) {
                try {
                    controller.addDestination(LogPropertiesParser.getLog(value.substring(4, value.indexOf(93)), destinations, config), logType);
                    continue;
                }
                catch (Exception e) {
                    throw new Exception("Invalid log name: '" + value + "'");
                }
            }
            LogDestinationDescriptor ldd = new LogDestinationDescriptor();
            ldd.setType(value);
            controller.addDestination(ldd, logType);
        }
    }
}

